/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.NutritionalInfoProduct;
import fr.protactile.procaisse.dao.entities.ProductInfo;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class NutritionalInfoProductDao
extends DaoConfig<NutritionalInfoProduct> {
    @Override
    protected Class<NutritionalInfoProduct> classType() {
        return NutritionalInfoProduct.class;
    }

    public List<NutritionalInfoProduct> getAllNutritionalInfos() {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("from NutritionalInfoProduct", NutritionalInfoProduct.class);
            List list = query.list();
            tx.commit();
            session.close();
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutritionalInfoProduct getNutriValuesByProduct(int product) {
        Session session = null;
        Transaction tx = null;
        NutritionalInfoProduct result = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query query = session.createQuery("from NutritionalInfoProduct n where n.product.id = :product", NutritionalInfoProduct.class);
                query.setParameter("product", (Object)product);
                result = (NutritionalInfoProduct)query.uniqueResult();
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return result;
    }

    public void addNutritionalInfo(NutritionalInfoProduct info) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)info);
            tx.commit();
            session.close();
        }
    }

    public void updateNutritionalInfo(NutritionalInfoProduct info, int product) {
        System.out.println("****** updateNutritionalInfo ******");
        NutritionalInfoProduct existingInfo = this.getNutriValuesByProduct(product);
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            if (existingInfo != null) {
                System.out.println("*******update ******** ");
                existingInfo.setEnergyKcalValue(info.getEnergyKcalValue());
                existingInfo.setEnergyKcalDailyPercentage(info.getEnergyKcalDailyPercentage());
                existingInfo.setFiberGValue(info.getFiberGValue());
                existingInfo.setFiberGDailyPercentage(info.getFiberGDailyPercentage());
                existingInfo.setFatGValue(info.getFatGValue());
                existingInfo.setFatSaturatedG(info.getFatSaturatedG());
                existingInfo.setFatGDailyPercentage(info.getFatGDailyPercentage());
                existingInfo.setCarbsGValue(info.getCarbsGValue());
                existingInfo.setSugarG(info.getSugarG());
                existingInfo.setCarbsGDailyPercentage(info.getCarbsGDailyPercentage());
                existingInfo.setProteinGValue(info.getProteinGValue());
                existingInfo.setProteinGDailyPercentage(info.getProteinGDailyPercentage());
                existingInfo.setSaltGValue(info.getSaltGValue());
                existingInfo.setSaltGDailyPercentage(info.getSaltGDailyPercentage());
                session.update((Object)existingInfo);
            } else {
                System.out.println("*******adding ******** ");
                this.addNutritionalInfo(product, info);
            }
            tx.commit();
            session.close();
        }
    }

    public void deleteNutritionalInfo(NutritionalInfoProduct info) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.delete((Object)info);
            tx.commit();
            session.close();
        }
    }

    public void addNutritionalInfo(int product, NutritionalInfoProduct mNutritionalInfoProduct) {
        ProductInfo productInfo = new ProductInfo();
        productInfo.setId(product);
        mNutritionalInfoProduct.setProduct(productInfo);
        this.save(mNutritionalInfoProduct);
    }
}

