/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.NutrientData;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class NutrientDataDao
extends DaoConfig<NutrientData> {
    @Override
    protected Class<NutrientData> classType() {
        return NutrientData.class;
    }

    public List<NutrientData> getAllNutrients() {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("from NutrientData", NutrientData.class);
            List list = query.list();
            tx.commit();
            session.close();
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutrientData getById(int id) {
        Session session = null;
        Transaction tx = null;
        NutrientData result = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                result = (NutrientData)session.get(NutrientData.class, (Serializable)Integer.valueOf(id));
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return result;
    }

    public void addNutrientData(NutrientData data) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)data);
            tx.commit();
            session.close();
        }
    }

    public void updateNutrientData(NutrientData data) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.update((Object)data);
            tx.commit();
            session.close();
        }
    }

    public void deleteNutrientData(NutrientData data) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.delete((Object)data);
            tx.commit();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutrientData getByNutrient(String nutrient) {
        Session session = null;
        Transaction tx = null;
        NutrientData result = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query query = session.createQuery("from NutrientData n where n.nutrient = :nutrient", NutrientData.class);
                query.setParameter("nutrient", (Object)nutrient);
                result = (NutrientData)query.uniqueResult();
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return result;
    }
}

