/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.MultiLanguageSupplementItem;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class MultiLanguageSupplementItemDao
extends DaoConfig<MultiLanguageSupplementItem> {
    @Override
    protected Class<MultiLanguageSupplementItem> classType() {
        return MultiLanguageSupplementItem.class;
    }

    public void setMultiLanguageSupplementItem(MultiLanguageSupplementItem multiLanguageSupplementItem) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageSupplementItem SET name = :name  WHERE id = :id");
                q.setParameter("name", (Object)multiLanguageSupplementItem.getName());
                q.setParameter("id", (Object)multiLanguageSupplementItem.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<MultiLanguageSupplementItem> getMultiLanguageTexts(int idSupplementItem) {
        Session session = null;
        Transaction tx = null;
        List<MultiLanguageSupplementItem> multiLanguageTexts = new ArrayList<MultiLanguageSupplementItem>();
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageSupplementItem M WHERE M.supplementItem.id = :supplement_item_id");
                q.setParameter("supplement_item_id", (Object)idSupplementItem);
                multiLanguageTexts = q.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return multiLanguageTexts;
    }

    public MultiLanguageSupplementItem getTextSupplementItemByLanguage(int idSupplementItem, String language) {
        Session session = null;
        Transaction tx = null;
        MultiLanguageSupplementItem textsProduct = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageSupplementItem M WHERE M.supplementItem.id = :supplement_item_id and M.language = :language");
                q.setParameter("supplement_item_id", (Object)idSupplementItem);
                q.setParameter("language", (Object)language);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    textsProduct = (MultiLanguageSupplementItem)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return textsProduct;
    }

    public void setMultiLanguageSupplementItem(String nameSupplementItem, int idSupplementItem, String language) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageSupplementItem SET name = :nameSupplementItem  WHERE language = :language and supplementItem.id = :idSupplementItem");
                q.setParameter("nameSupplementItem", (Object)nameSupplementItem);
                q.setParameter("language", (Object)language);
                q.setParameter("idSupplementItem", (Object)idSupplementItem);
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

