/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.MultiLanguageSupplement;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class MultiLanguageSupplementDao
extends DaoConfig<MultiLanguageSupplement> {
    @Override
    protected Class<MultiLanguageSupplement> classType() {
        return MultiLanguageSupplement.class;
    }

    public void setMultiLanguageSupplement(MultiLanguageSupplement multiLanguageSupplement) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageSupplement SET name = :name  WHERE id = :id");
                q.setParameter("name", (Object)multiLanguageSupplement.getName());
                q.setParameter("id", (Object)multiLanguageSupplement.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<MultiLanguageSupplement> getMultiLanguageTexts(int idSupplement) {
        Session session = null;
        Transaction tx = null;
        List<MultiLanguageSupplement> multiLanguageTexts = new ArrayList<MultiLanguageSupplement>();
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageSupplement M WHERE M.supplement.id = :supplement_id");
                q.setParameter("supplement_id", (Object)idSupplement);
                multiLanguageTexts = q.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return multiLanguageTexts;
    }

    public MultiLanguageSupplement getTextSupplementByLanguage(int idSupplement, String language) {
        Session session = null;
        Transaction tx = null;
        MultiLanguageSupplement textsProduct = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageSupplement M WHERE M.supplement.id = :supplement_id and M.language = :language");
                q.setParameter("supplement_id", (Object)idSupplement);
                q.setParameter("language", (Object)language);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    textsProduct = (MultiLanguageSupplement)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return textsProduct;
    }

    public void setMultiLanguageSupplement(String nameSupplement, int idSupplement, String language) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageSupplement SET name = :nameSupplement  WHERE language = :language and supplement.id = :idSupplement");
                q.setParameter("nameSupplement", (Object)nameSupplement);
                q.setParameter("language", (Object)language);
                q.setParameter("idSupplement", (Object)idSupplement);
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

