/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.MultiLanguagePromotion;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class MultiLanguagePromotionDao
extends DaoConfig<MultiLanguagePromotion> {
    @Override
    protected Class<MultiLanguagePromotion> classType() {
        return MultiLanguagePromotion.class;
    }

    public void setMultiLanguagePromotion(MultiLanguagePromotion multiLanguagePromotion) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguagePromotion SET name = :name , text_promo = :text_promo, description = :description WHERE id = :id");
                q.setParameter("name", (Object)multiLanguagePromotion.getName());
                q.setParameter("text_promo", (Object)multiLanguagePromotion.getText_promo());
                q.setParameter("description", (Object)multiLanguagePromotion.getDescription());
                q.setParameter("id", (Object)multiLanguagePromotion.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<MultiLanguagePromotion> getMultiLanguageTexts(int idPromotion) {
        Session session = null;
        Transaction tx = null;
        List<MultiLanguagePromotion> multiLanguageTexts = new ArrayList<MultiLanguagePromotion>();
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguagePromotion M WHERE M.promotion.id = :promotion_id");
                q.setParameter("promotion_id", (Object)idPromotion);
                multiLanguageTexts = q.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return multiLanguageTexts;
    }

    public MultiLanguagePromotion getTextPromotionByLanguage(int idPromotion, String language) {
        Session session = null;
        Transaction tx = null;
        MultiLanguagePromotion textsProduct = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguagePromotion M WHERE M.promotion.id = :promotion_id and M.language = :language");
                q.setParameter("promotion_id", (Object)idPromotion);
                q.setParameter("language", (Object)language);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    textsProduct = (MultiLanguagePromotion)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return textsProduct;
    }

    public void setMultiLanguagePromotion(String name_promotion, String description, String text_promo, int idPromotion, String language) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguagePromotion SET name = :name_promotion , text_promo = :text_promo, description = :description WHERE language = :language and promotion.id = :idPromotion");
                q.setParameter("name_promotion", (Object)name_promotion);
                q.setParameter("text_promo", (Object)text_promo);
                q.setParameter("description", (Object)description);
                q.setParameter("language", (Object)language);
                q.setParameter("idPromotion", (Object)idPromotion);
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

