/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.MultiLanguageProduct;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class MultiLanguageProductDao
extends DaoConfig<MultiLanguageProduct> {
    @Override
    protected Class<MultiLanguageProduct> classType() {
        return MultiLanguageProduct.class;
    }

    public void setMultiLanguageProduct(MultiLanguageProduct multiLanguageProduct) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageProduct SET name = :name , description = :description, description_platform = :description_platform WHERE id = :id");
                q.setParameter("name", (Object)multiLanguageProduct.getName());
                q.setParameter("description", (Object)multiLanguageProduct.getDescription());
                q.setParameter("description_platform", (Object)multiLanguageProduct.getDescription_platform());
                q.setParameter("id", (Object)multiLanguageProduct.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<MultiLanguageProduct> getMultiLanguageTexts(int idProduct) {
        Session session = null;
        Transaction tx = null;
        List<MultiLanguageProduct> multiLanguageTexts = new ArrayList<MultiLanguageProduct>();
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageProduct M WHERE M.product.id = :product_id");
                q.setParameter("product_id", (Object)idProduct);
                multiLanguageTexts = q.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return multiLanguageTexts;
    }

    public MultiLanguageProduct getTextProductByLanguage(int idProduct, String language) {
        Session session = null;
        Transaction tx = null;
        MultiLanguageProduct textsProduct = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageProduct M WHERE M.product.id = :product_id and M.language = :language");
                q.setParameter("product_id", (Object)idProduct);
                q.setParameter("language", (Object)language);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    textsProduct = (MultiLanguageProduct)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return textsProduct;
    }

    public void setMultiLanguageProduct(String nameProduct, String description, String description_platform, int idProduct, String language) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageProduct SET name = :nameProduct, description = :description, description_platform = :description_platform WHERE language = :language and product.id = :idProduct");
                q.setParameter("nameProduct", (Object)nameProduct);
                q.setParameter("description", (Object)description);
                q.setParameter("description_platform", (Object)description_platform);
                q.setParameter("language", (Object)language);
                q.setParameter("idProduct", (Object)idProduct);
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

