/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.MultiLanguageGSS;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class MultiLanguageGSSDao
extends DaoConfig<MultiLanguageGSS> {
    @Override
    protected Class<MultiLanguageGSS> classType() {
        return MultiLanguageGSS.class;
    }

    public void setMultiLanguageGSS(MultiLanguageGSS multiLanguageGSS) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageGSS SET name = :name, title_group = :title_group WHERE id = :id");
                q.setParameter("name", (Object)multiLanguageGSS.getName());
                q.setParameter("title_group", (Object)multiLanguageGSS.getTitle_group());
                q.setParameter("id", (Object)multiLanguageGSS.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<MultiLanguageGSS> getMultiLanguageTexts(int idGroupSubSupplement) {
        Session session = null;
        Transaction tx = null;
        List<MultiLanguageGSS> multiLanguageTexts = new ArrayList<MultiLanguageGSS>();
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageGSS M WHERE M.groupSubSupplementInfo.id = :group_sub_supplement_id");
                q.setParameter("group_sub_supplement_id", (Object)idGroupSubSupplement);
                multiLanguageTexts = q.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return multiLanguageTexts;
    }

    public MultiLanguageGSS getTextGSSByLanguage(int idGroupSubSupplement, String language) {
        Session session = null;
        Transaction tx = null;
        MultiLanguageGSS textsProduct = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageGSS M WHERE M.groupSubSupplementInfo.id = :group_sub_supplement_id and M.language = :language");
                q.setParameter("group_sub_supplement_id", (Object)idGroupSubSupplement);
                q.setParameter("language", (Object)language);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    textsProduct = (MultiLanguageGSS)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return textsProduct;
    }

    public void setMultiLanguageGSS(String nameGSS, String titleGroup, int idGSS, String language) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageGSS SET name = :nameGSS, title_group = :titleGroup WHERE language = :language and groupSubSupplementInfo.id = :idGSS");
                q.setParameter("name", (Object)nameGSS);
                q.setParameter("title_group", (Object)titleGroup);
                q.setParameter("language", (Object)language);
                q.setParameter("idGSS", (Object)idGSS);
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

