/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.MultiLanguageCategory;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class MultiLanguageCategoryDao
extends DaoConfig<MultiLanguageCategory> {
    @Override
    protected Class<MultiLanguageCategory> classType() {
        return MultiLanguageCategory.class;
    }

    public void setMultiLanguageCategory(MultiLanguageCategory multiLanguageCategory) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageCategory SET name = :name  WHERE id = :id");
                q.setParameter("name", (Object)multiLanguageCategory.getName());
                q.setParameter("id", (Object)multiLanguageCategory.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<MultiLanguageCategory> getMultiLanguageTexts(int idCategory) {
        Session session = null;
        Transaction tx = null;
        List<MultiLanguageCategory> multiLanguageTexts = new ArrayList<MultiLanguageCategory>();
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageCategory M WHERE M.category.id = :category_id");
                q.setParameter("category_id", (Object)idCategory);
                multiLanguageTexts = q.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return multiLanguageTexts;
    }

    public MultiLanguageCategory getTextCategoryByLanguage(int idCategory, String language) {
        Session session = null;
        Transaction tx = null;
        MultiLanguageCategory textsProduct = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageCategory M WHERE M.category.id = :category_id and M.language = :language");
                q.setParameter("category_id", (Object)idCategory);
                q.setParameter("language", (Object)language);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    textsProduct = (MultiLanguageCategory)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return textsProduct;
    }

    public void setMultiLanguageCategory(String nameCategory, int idCategory, String language) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageCategory SET name = :nameCategory  WHERE language = :language and category.id = :idCategory");
                q.setParameter("nameCategory", (Object)nameCategory);
                q.setParameter("language", (Object)language);
                q.setParameter("idCategory", (Object)idCategory);
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

