/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.MultiLanguageCarte;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class MultiLanguageCarteDao
extends DaoConfig<MultiLanguageCarte> {
    @Override
    protected Class<MultiLanguageCarte> classType() {
        return MultiLanguageCarte.class;
    }

    public void setMultiLanguageCarte(MultiLanguageCarte multiLanguageCarte) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageCarte SET name = :name  WHERE id = :id");
                q.setParameter("name", (Object)multiLanguageCarte.getName());
                q.setParameter("id", (Object)multiLanguageCarte.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<MultiLanguageCarte> getMultiLanguageTexts(int idProduct) {
        Session session = null;
        Transaction tx = null;
        List<MultiLanguageCarte> multiLanguageTexts = new ArrayList<MultiLanguageCarte>();
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageCarte M WHERE M.carte.id = :carte_id");
                q.setParameter("carte_id", (Object)idProduct);
                multiLanguageTexts = q.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return multiLanguageTexts;
    }

    public MultiLanguageCarte getTextCarteByLanguage(int idProduct, String language) {
        Session session = null;
        Transaction tx = null;
        MultiLanguageCarte textsProduct = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MultiLanguageCarte M WHERE M.carte.id = :carte_id and M.language = :language");
                q.setParameter("carte_id", (Object)idProduct);
                q.setParameter("language", (Object)language);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    textsProduct = (MultiLanguageCarte)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return textsProduct;
    }

    public void setMultiLanguageCarte(String nameCarte, int idCarte, String language) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE MultiLanguageCarte SET name = :nameCarte  WHERE language = :language and carte.id = :idCarte");
                q.setParameter("nameCarte", (Object)nameCarte);
                q.setParameter("language", (Object)language);
                q.setParameter("idCarte", (Object)idCarte);
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

