/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.MoneyMouvement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class MoneyMouvementDao
extends DaoConfig<MoneyMouvement> {
    @Override
    protected Class<MoneyMouvement> classType() {
        return MoneyMouvement.class;
    }

    public List<MoneyMouvement> getMoneyMouvements() {
        List<MoneyMouvement> moneyMouvements = new ArrayList<MoneyMouvement>();
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from MoneyMouvement s WHERE  s.deleted = :deleted");
                q.setParameter("deleted", (Object)false);
                moneyMouvements = q.list();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return moneyMouvements;
    }

    public void addMoneyMouvementInfo(MoneyMouvement mMoneyMouvement) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                session.save((Object)mMoneyMouvement);
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void updateMoneyMouvement(MoneyMouvement mMoneyMouvement) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                String hqlUpdate = "update MoneyMouvement p set  p.caissier = :caissier  ,p.raison = :raison,p.total = :total ,p.type = :type,p.deleted = :deleted where p.id = :id ";
                int updatedEntities = session.createQuery(hqlUpdate).setString("caissier", mMoneyMouvement.getCaissier()).setString("raison", mMoneyMouvement.getRaison()).setString("type", mMoneyMouvement.getType()).setDouble("total", mMoneyMouvement.getTotal()).setInteger("id", mMoneyMouvement.getId().intValue()).setBoolean("deleted", mMoneyMouvement.isDeleted()).executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void deleteMoneyMouvement(MoneyMouvement mMoneyMouvement) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                String hqlUpdate = "update MoneyMouvement p set p.deleted = :deleted where p.id = :id ";
                int updatedEntities = session.createQuery(hqlUpdate).setParameter("deleted", (Object)true).setInteger("id", mMoneyMouvement.getId().intValue()).executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<MoneyMouvement> findMouvementByTimeRange(Date dateStart, Date dateEnd) {
        List<MoneyMouvement> moneyMouvements = new ArrayList<MoneyMouvement>();
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                String hqlUpdate = "update MoneyMouvement p set p.deleted = :deleted where p.id = :id ";
                Query q = session.createQuery("from MoneyMouvement m WHERE m.deleted <> 1  and m.created_at <= :dateEnd AND m.created_at >= :dateStart  order by id desc");
                q.setParameter("dateStart", (Object)dateStart);
                q.setParameter("dateEnd", (Object)dateEnd);
                moneyMouvements = q.list();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return moneyMouvements;
    }
}

