/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.LoyaltyCardInfo;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class LoyaltyCardInfoDao
extends DaoConfig<LoyaltyCardInfo> {
    @Override
    protected Class<LoyaltyCardInfo> classType() {
        return LoyaltyCardInfo.class;
    }

    public LoyaltyCardInfo getLoyaltyCardByBarCode(String code_carte) {
        DaoConfig.s.clear();
        Query query = DaoConfig.s.createQuery("from LoyaltyCardInfo l WHERE l.code_carte = :code_carte");
        query.setParameter("code_carte", (Object)code_carte);
        LoyaltyCardInfo loyaltyCard = null;
        if (!query.getResultList().isEmpty()) {
            loyaltyCard = (LoyaltyCardInfo)query.getSingleResult();
        }
        return loyaltyCard;
    }

    public int increaseCredit(double credit, int idLoyaltyCard) {
        Query q = DaoConfig.s.createQuery("UPDATE LoyaltyCardInfo l SET l.credit = l.credit + :credit WHERE l.id = :id");
        q.setParameter("credit", (Object)credit);
        q.setParameter("id", (Object)idLoyaltyCard);
        return q.executeUpdate();
    }

    public int decreaseCredit(double credit, int idLoyaltyCard) {
        Query q = DaoConfig.s.createQuery("UPDATE LoyaltyCardInfo l SET l.credit = l.credit - :credit WHERE l.id = :id");
        q.setParameter("credit", (Object)credit);
        q.setParameter("id", (Object)idLoyaltyCard);
        return q.executeUpdate();
    }

    public int initializeCard(int idLoyaltyCard) {
        Query q = DaoConfig.s.createQuery("UPDATE LoyaltyCardInfo l SET l.initialized_at = CURRENT_TIMESTAMP, l.number_use = 0WHERE l.id = :id");
        q.setParameter("id", (Object)idLoyaltyCard);
        return q.executeUpdate();
    }

    public int increaseNumberUser(int idLoyaltyCard) {
        Query q = DaoConfig.s.createQuery("UPDATE LoyaltyCardInfo l SET l.number_use = l.number_use + 1 WHERE l.id = :id");
        q.setParameter("id", (Object)idLoyaltyCard);
        return q.executeUpdate();
    }

    public List<LoyaltyCardInfo> findByCustomer(int customer_id) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("from LoyaltyCardInfo l WHERE l.customer.id = :customer");
            query.setParameter("customer", (Object)customer_id);
            List result = query.list();
            tx.commit();
            session.close();
            return result;
        }
        return null;
    }
}

