/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.LocalScreen;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class LocalScreenDao
extends DaoConfig<LocalScreen> {
    @Override
    protected Class<LocalScreen> classType() {
        return LocalScreen.class;
    }

    public List<LocalScreen> getScreens() {
        if (!s.isOpen()) {
            this.openSession();
        }
        Transaction tx = s.beginTransaction();
        Query q = s.createQuery("from LocalScreen s WHERE  s.deleted = :deleted");
        q.setParameter("deleted", (Object)false);
        List screens = q.list();
        tx.commit();
        s.close();
        return screens;
    }

    public LocalScreen getScreenByIdGlocal(int id_global) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Transaction tx = s.beginTransaction();
        Query q = s.createQuery("from LocalScreen s where s.id_screen_global = :id_screen_global");
        q.setParameter("id_screen_global", (Object)id_global);
        Object o = q.list() != null && !q.list().isEmpty() ? q.getSingleResult() : null;
        tx.commit();
        s.close();
        if (o != null) {
            return (LocalScreen)o;
        }
        return null;
    }

    public void addLocalScreen(LocalScreen mLocalScreens) {
        this.save(mLocalScreens);
    }

    public void updateScreen(LocalScreen mScreen) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update LocalScreen s set s.name = :name, s.number = :number where s.id = :id ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setString("name", mScreen.getName()).setInteger("number", mScreen.getNumber()).setInteger("id", mScreen.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public void deleteScreen(LocalScreen mScreen) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update LocalScreen s set s.deleted = :deleted where s.id = :id ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setParameter("deleted", (Object)true).setInteger("id", mScreen.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public LocalScreen findByNumber(int number) {
        LocalScreen mLocalScreen = null;
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query q = session.createQuery("from LocalScreen s where s.number = :number");
            q.setParameter("number", (Object)number);
            List results = q.getResultList();
            if (results != null && !results.isEmpty()) {
                mLocalScreen = (LocalScreen)results.get(0);
            }
            tx.commit();
            session.close();
        }
        return mLocalScreen;
    }

    public void deleteScreen(boolean deleted, int number) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update LocalScreen s set s.deleted = :deleted where s.number = :number ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setParameter("deleted", (Object)deleted).setInteger("number", number).executeUpdate();
        tx.commit();
        s.close();
    }

    public void updateScreen(String name, boolean deleted, int number) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update LocalScreen s set s.name = :name, s.deleted = :deleted where s.number = :number ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setString("name", name).setParameter("deleted", (Object)deleted).setInteger("number", number).executeUpdate();
        tx.commit();
        s.close();
    }
}

