/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.LanguageInfo;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class LanguageInfoDao
extends DaoConfig<LanguageInfo> {
    @Override
    protected Class<LanguageInfo> classType() {
        return LanguageInfo.class;
    }

    public List<LanguageInfo> getAllLanguages() {
        List<LanguageInfo> languages;
        block4: {
            languages = new ArrayList<LanguageInfo>();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query query = session.createQuery("from LanguageInfo L");
                    languages = query.list();
                    tx.commit();
                    session.close();
                }
                catch (Exception exception) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return languages;
    }

    public List<LanguageInfo> getEnabledLanguages() {
        List<LanguageInfo> languages;
        block4: {
            languages = new ArrayList<LanguageInfo>();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query query = session.createQuery("from LanguageInfo L where L.enabled = :enabled");
                    query.setParameter("enabled", (Object)true);
                    languages = query.list();
                    tx.commit();
                    session.close();
                }
                catch (Exception exception) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return languages;
    }

    public LanguageInfo addLanguage(LanguageInfo language) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    session.save((Object)language);
                    tx.commit();
                    session.close();
                }
                catch (Exception exception) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return language;
    }

    public void setEnabled(LanguageInfo languageInfo) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query query = session.createQuery("UPDATE LanguageInfo L SET L.enabled = :enabled WHERE L.id = :id");
                    query.setParameter("enabled", (Object)languageInfo.isEnabled());
                    query.setParameter("id", (Object)languageInfo.getId());
                    query.executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception exception) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public LanguageInfo getLanguageByCode(String code_language) {
        Session session = null;
        Transaction tx = null;
        LanguageInfo languageInfo = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from LanguageInfo L WHERE L.code_language = :code_language");
                q.setParameter("code_language", (Object)code_language);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    languageInfo = (LanguageInfo)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return languageInfo;
    }

    public void setLanguage(LanguageInfo languageInfo) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query query = session.createQuery("UPDATE LanguageInfo L SET L.label_language = :label_language, L.enabled = :enabled , L.default_language = :default_language  WHERE L.id = :id");
                    query.setParameter("label_language", (Object)languageInfo.getLabel_language());
                    query.setParameter("enabled", (Object)languageInfo.isEnabled());
                    query.setParameter("default_language", (Object)languageInfo.isDefault_language());
                    query.setParameter("id", (Object)languageInfo.getId());
                    query.executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception exception) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public LanguageInfo getDefaultLanguage() {
        Session session = null;
        Transaction tx = null;
        LanguageInfo languageInfo = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from LanguageInfo L WHERE L.default_language = :default_language");
                q.setParameter("default_language", (Object)true);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    languageInfo = (LanguageInfo)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return languageInfo;
    }
}

