/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class ImageProductDao
extends DaoConfig<ImageProduct> {
    @Override
    protected Class<ImageProduct> classType() {
        return ImageProduct.class;
    }

    public void setImage(ImageProduct imageProduct) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE ImageProduct SET name = :name , path = :path, url = :url, graphic_type = :graphic_type WHERE id = :id");
                q.setParameter("name", (Object)imageProduct.getName());
                q.setParameter("path", (Object)imageProduct.getPath());
                q.setParameter("url", (Object)imageProduct.getUrl());
                q.setParameter("graphic_type", (Object)imageProduct.getGraphic_type());
                q.setParameter("id", (Object)imageProduct.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<ImageProduct> getImages(int idProduct) {
        Session session = null;
        Transaction tx = null;
        List<ImageProduct> images = new ArrayList<ImageProduct>();
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from ImageProduct I WHERE I.product.id = :product_id");
                q.setParameter("product_id", (Object)idProduct);
                images = q.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return images;
    }

    public ImageProduct getImage(int idProduct, String nameImage) {
        Session session = null;
        Transaction tx = null;
        ImageProduct imageProduct = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from ImageProduct I WHERE I.product.id = :product_id and name = :name");
                q.setParameter("product_id", (Object)idProduct);
                q.setParameter("name", (Object)nameImage);
                List result = q.list();
                if (result != null && result.size() > 0) {
                    imageProduct = (ImageProduct)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return imageProduct;
    }

    public List<ImageProduct> getImagesPlatform(String nameImage) {
        Session session = null;
        Transaction tx = null;
        List<ImageProduct> images = new ArrayList<ImageProduct>();
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("from ImageProduct I WHERE I.name = :name and I.path is not null");
                q.setParameter("name", (Object)nameImage);
                images = q.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return images;
    }
}

