/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.DebitCustomerInfo;
import fr.protactile.procaisse.dao.entities.TicketInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;

public class DebitCustomerInfoDao
extends DaoConfig<DebitCustomerInfo> {
    @Override
    protected Class<DebitCustomerInfo> classType() {
        return DebitCustomerInfo.class;
    }

    public List<DebitCustomerInfo> getByCustomerId(Integer customerId) {
        ArrayList<DebitCustomerInfo> result = new ArrayList<DebitCustomerInfo>();
        Query q = DaoConfig.s.createQuery("SELECT dc.id, dc.amount, dc.datePayment, dc.paid, dc.transferNumber, t.id, t.numeroOrder FROM DebitCustomerInfo dc LEFT JOIN dc.ticket t LEFT JOIN dc.customer c WHERE c.id = :id_customer ORDER BY dc.datePayment");
        q.setParameter("id_customer", (Object)customerId);
        List myList = q.getResultList();
        for (Object[] next : myList) {
            DebitCustomerInfo mInfo = new DebitCustomerInfo((Integer)next[0]);
            TicketInfo mTicketInfo = new TicketInfo((String)next[5]);
            mTicketInfo.setNumeroOrder((Integer)next[6]);
            mInfo.setAmount((Double)next[1]);
            mInfo.setDatePayment((Date)next[2]);
            mInfo.setPaid((Boolean)next[3]);
            mInfo.setTransferNumber((String)next[4]);
            mInfo.setTicket(mTicketInfo);
            result.add(mInfo);
        }
        return result;
    }

    public int updatePaidAttribute(DebitCustomerInfo mDebitCustomerInfo) {
        Query q = DaoConfig.s.createQuery("UPDATE DebitCustomerInfo dc SET dc.paid = :isPaid WHERE dc.id = :id");
        q.setParameter("isPaid", (Object)mDebitCustomerInfo.isPaid());
        q.setParameter("id", (Object)mDebitCustomerInfo.getId());
        return q.executeUpdate();
    }

    public int deleteByPaymentId(String paymentId) {
        Query q = DaoConfig.s.createQuery("DELETE FROM DebitCustomerInfo dc WHERE dc.payment.id = :paymentId");
        q.setParameter("paymentId", (Object)paymentId);
        return q.executeUpdate();
    }
}

