/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class CustomerInfoDao
extends DaoConfig<CustomerInfo> {
    @Override
    protected Class<CustomerInfo> classType() {
        return CustomerInfo.class;
    }

    public List<CustomerInfo> findAllVisibledAndNotRemoved() {
        if (!s.isOpen()) {
            this.openSession();
        }
        Query q = DaoConfig.s.createQuery("from CustomerInfo c WHERE c.visible = :isVisibled AND c.removed = :isRemoved");
        q.setParameter("isVisibled", (Object)true);
        q.setParameter("isRemoved", (Object)false);
        return q.list();
    }

    public List<CustomerInfo> getCustomers() {
        if (!s.isOpen()) {
            this.openSession();
        }
        Query q = DaoConfig.s.createQuery("from CustomerInfo c WHERE c.visible = :isVisibled AND c.removed = :isRemoved ORDER BY c.name");
        q.setParameter("isVisibled", (Object)true);
        q.setParameter("isRemoved", (Object)false);
        return q.list();
    }

    public List<CustomerInfo> findByName(String name) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Query q = DaoConfig.s.createQuery("from CustomerInfo c WHERE c.visible = :isVisibled AND c.removed = :isRemoved AND c.name LIKE '%" + name + "%' ORDER BY c.name");
        q.setParameter("isVisibled", (Object)true);
        q.setParameter("isRemoved", (Object)false);
        return q.list();
    }

    public void onlyUpdate(CustomerInfo customerInfo) {
        if (!s.isOpen()) {
            this.openSession();
        }
        s.detach((Object)customerInfo);
        s.update((Object)customerInfo);
    }

    public CustomerInfo findOneByName(String name) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Query q = DaoConfig.s.createQuery("from CustomerInfo c WHERE c.visible = :isVisibled AND c.removed = :isRemoved AND c.name = :name");
        q.setParameter("isVisibled", (Object)true);
        q.setParameter("isRemoved", (Object)false);
        q.setParameter("name", (Object)name);
        List result = q.list();
        if (result != null && result.size() > 0) {
            return (CustomerInfo)result.get(0);
        }
        return null;
    }

    @Override
    public void remove(Object o) {
        CustomerInfo m = null;
        if (o instanceof CustomerInfo) {
            m = (CustomerInfo)o;
        } else if (o instanceof Integer) {
            m = (CustomerInfo)this.find(o);
        }
        if (m != null) {
            try {
                m.setRemoved(true);
                m.setVisible(false);
                s.getTransaction().begin();
                s.merge(o);
                s.getTransaction().commit();
            }
            catch (Exception e) {
                s.getTransaction().rollback();
                LogToFile.log("severe", e.getMessage(), e);
            }
        }
    }

    public void forceRemove(Object o) throws BasicException {
        CustomerInfo m = null;
        if (o instanceof CustomerInfo) {
            m = (CustomerInfo)o;
        } else if (o instanceof Integer) {
            m = (CustomerInfo)this.find(o);
        }
        if (m == null) {
            throw new BasicException();
        }
        super.remove(o);
    }

    public List<CustomerInfo> filterByPhoneOrName(String phone, String name) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Object qW = "";
        if (phone != null && !phone.isEmpty()) {
            qW = (String)qW + " AND (c.phone LIKE '%" + phone + "%' OR c.phone2 LIKE '%" + phone + "%') ";
        }
        if (name != null && !name.isEmpty()) {
            qW = (String)qW + " AND UPPER(c.name) LIKE '%" + name.toUpperCase() + "%' ";
        }
        Query q = DaoConfig.s.createQuery("from CustomerInfo c WHERE c.visible = :isVisibled AND c.removed = :isRemoved " + (String)qW + " ORDER BY c.name");
        q.setParameter("isVisibled", (Object)true);
        q.setParameter("isRemoved", (Object)false);
        return q.list();
    }

    public List<CustomerInfo> getCustomersAsType(String type) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Query q = DaoConfig.s.createQuery("from CustomerInfo c WHERE c.removed = :isRemoved AND c.type = :type ORDER BY c.name");
        q.setParameter("isRemoved", (Object)false);
        q.setParameter("type", (Object)type);
        return q.list();
    }

    public int increaseTurnover(double turnover, int id_customer) {
        block3: {
            if (sessionFactory != null) {
                Transaction tx = null;
                try {
                    Session session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("UPDATE CustomerInfo c SET c.turnover = c.turnover + :turnover WHERE c.id = :id");
                    q.setParameter("turnover", (Object)turnover);
                    q.setParameter("id", (Object)id_customer);
                    int result = q.executeUpdate();
                    tx.commit();
                    return result;
                }
                catch (Exception exception) {
                    if (tx == null) break block3;
                    tx.rollback();
                }
            }
        }
        return 0;
    }

    public int decreaseTurnover(double turnover, int id_customer) {
        block3: {
            if (sessionFactory != null) {
                Transaction tx = null;
                try {
                    Session session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("UPDATE CustomerInfo c SET c.turnover = c.turnover - :turnover WHERE c.id = :id");
                    q.setParameter("turnover", (Object)turnover);
                    q.setParameter("id", (Object)id_customer);
                    int result = q.executeUpdate();
                    tx.commit();
                    return result;
                }
                catch (Exception exception) {
                    if (tx == null) break block3;
                    tx.rollback();
                }
            }
        }
        return 0;
    }

    public int increaseNBOrders(int id_customer) {
        block3: {
            if (sessionFactory != null) {
                Transaction tx = null;
                try {
                    Session session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("UPDATE CustomerInfo c SET c.nb_orders = c.nb_orders + :nb_order WHERE c.id = :id");
                    q.setParameter("nb_order", (Object)1);
                    q.setParameter("id", (Object)id_customer);
                    int result = q.executeUpdate();
                    tx.commit();
                    return result;
                }
                catch (Exception exception) {
                    if (tx == null) break block3;
                    tx.rollback();
                }
            }
        }
        return 0;
    }

    public int decreaseNBOrders(int id_customer) {
        block3: {
            if (sessionFactory != null) {
                Transaction tx = null;
                try {
                    Session session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("UPDATE CustomerInfo c SET c.nb_orders = c.nb_orders - :nb_order WHERE c.id = :id");
                    q.setParameter("nb_order", (Object)1);
                    q.setParameter("id", (Object)id_customer);
                    int result = q.executeUpdate();
                    tx.commit();
                    return result;
                }
                catch (Exception exception) {
                    if (tx == null) break block3;
                    tx.rollback();
                }
            }
        }
        return 0;
    }

    public int changeLastOrder(int id_customer, Date date_last_order) {
        block3: {
            if (sessionFactory != null) {
                Transaction tx = null;
                try {
                    Session session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("UPDATE CustomerInfo c SET c.last_order = :last_order WHERE c.id = :id");
                    q.setParameter("last_order", (Object)date_last_order);
                    q.setParameter("id", (Object)id_customer);
                    int result = q.executeUpdate();
                    tx.commit();
                    return result;
                }
                catch (Exception exception) {
                    if (tx == null) break block3;
                    tx.rollback();
                }
            }
        }
        return 0;
    }

    public CustomerInfo findOneByPhone(String phone) {
        block4: {
            if (sessionFactory != null) {
                Transaction tx = null;
                try {
                    Session session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from CustomerInfo c WHERE c.visible = :isVisibled AND c.removed = :isRemoved AND c.phone = :phone");
                    q.setParameter("isVisibled", (Object)true);
                    q.setParameter("isRemoved", (Object)false);
                    q.setParameter("phone", (Object)phone);
                    List result = q.list();
                    tx.commit();
                    if (result != null && result.size() > 0) {
                        return (CustomerInfo)result.get(0);
                    }
                }
                catch (Exception exception) {
                    if (tx == null) break block4;
                    tx.rollback();
                }
            }
        }
        return null;
    }

    public CustomerInfo findOneByPhoneName(String phone, String name) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Query q = DaoConfig.s.createQuery("from CustomerInfo c WHERE c.visible = :isVisibled AND c.removed = :isRemoved AND c.phone = :phone AND c.name = :name");
        q.setParameter("isVisibled", (Object)true);
        q.setParameter("isRemoved", (Object)false);
        q.setParameter("phone", (Object)phone);
        q.setParameter("name", (Object)name);
        List result = q.list();
        if (result != null && result.size() > 0) {
            return (CustomerInfo)result.get(0);
        }
        return null;
    }

    public CustomerInfo findOneByPhoneSiret(String siret) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Query q = DaoConfig.s.createQuery("from CustomerInfo c WHERE c.visible = :isVisibled AND c.removed = :isRemoved AND c.siret = :siret");
        q.setParameter("isVisibled", (Object)true);
        q.setParameter("isRemoved", (Object)false);
        q.setParameter("siret", (Object)siret);
        List result = q.list();
        if (result != null && result.size() > 0) {
            return (CustomerInfo)result.get(0);
        }
        return null;
    }

    public List<CustomerInfo> fetchNotSynchronizedCostumors() {
        block3: {
            if (sessionFactory != null) {
                Transaction tx = null;
                try {
                    Session session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from CustomerInfo c WHERE c.isSynchro = :isSynchro and c.visible = :isVisibled AND c.removed = :isRemoved");
                    q.setParameter("isSynchro", (Object)false);
                    q.setParameter("isVisibled", (Object)true);
                    q.setParameter("isRemoved", (Object)false);
                    List result = q.list();
                    tx.commit();
                    return result;
                }
                catch (Exception exception) {
                    if (tx == null) break block3;
                    tx.rollback();
                }
            }
        }
        return null;
    }

    public void updateNameCustomer(CustomerInfo mCustomerInfo) {
        block3: {
            if (sessionFactory != null) {
                Transaction tx = null;
                try {
                    Session session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("UPDATE CustomerInfo c SET c.name = :name WHERE c.id = :id");
                    q.setParameter("name", (Object)mCustomerInfo.getName());
                    q.setParameter("id", (Object)mCustomerInfo.getId());
                    q.executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception exception) {
                    if (tx == null) break block3;
                    tx.rollback();
                }
            }
        }
    }

    public void udpateCustomer(CustomerInfo mCustomerInfo, Session session) {
        Query q = session.createQuery("UPDATE CustomerInfo c SET c.company = :company, c.name = :name, c.phone = :phone, c.phone2 = :phone2, c.email = :email, c.responsible = :responsible,c.interlocutor = :interlocutor, c.function_interlocutor = :function_interlocutor, c.range = :range, c.discount = :discount WHERE c.id = :id");
        q.setParameter("company", (Object)mCustomerInfo.getCompany());
        q.setParameter("name", (Object)mCustomerInfo.getName());
        q.setParameter("phone", (Object)mCustomerInfo.getPhone());
        q.setParameter("phone2", (Object)mCustomerInfo.getPhone2());
        q.setParameter("email", (Object)mCustomerInfo.getEmail());
        q.setParameter("responsible", (Object)mCustomerInfo.getResponsible());
        q.setParameter("interlocutor", (Object)mCustomerInfo.getInterlocutor());
        q.setParameter("function_interlocutor", (Object)mCustomerInfo.getFunction_interlocutor());
        q.setParameter("range", (Object)mCustomerInfo.getRange());
        q.setParameter("discount", (Object)mCustomerInfo.getDiscount());
        q.setParameter("id", (Object)mCustomerInfo.getId());
        q.executeUpdate();
    }
}

