/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.CurrencyPOS;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class CurrencyPOSDao
extends DaoConfig<CurrencyPOS> {
    @Override
    protected Class<CurrencyPOS> classType() {
        return CurrencyPOS.class;
    }

    public void save(CurrencyPOS currencyPOS) {
        if (sessionFactory != null) {
            Session session = null;
            Transaction tx = null;
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                session.save((Object)currencyPOS);
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public CurrencyPOS getCurrencyPOS() {
        CurrencyPOS currencyPOS = null;
        if (sessionFactory != null) {
            Session session = null;
            Transaction tx = null;
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query query = session.createQuery("from CurrencyPOS C ");
                List result = query.list();
                if (result != null && result.size() > 0) {
                    currencyPOS = (CurrencyPOS)result.get(0);
                }
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", null, ex);
            }
        }
        return currencyPOS;
    }

    public void setCurrencyPOS(CurrencyPOS currencyPOS) {
        Session session = null;
        Transaction tx = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE CurrencyPOS SET code = :code , symbol = :symbol, label = :label WHERE id = :id");
                q.setParameter("code", (Object)currencyPOS.getCode());
                q.setParameter("symbol", (Object)currencyPOS.getSymbol());
                q.setParameter("label", (Object)currencyPOS.getLabel());
                q.setParameter("id", (Object)currencyPOS.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

