/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.CityDeliveryInfo;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class CityDeliveryInfoDao
extends DaoConfig<CityDeliveryInfo> {
    @Override
    protected Class<CityDeliveryInfo> classType() {
        return CityDeliveryInfo.class;
    }

    public List<CityDeliveryInfo> findByZone(int zone_id) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Query q = DaoConfig.s.createQuery("from CityDeliveryInfo c WHERE c.idZoneDelivery = :zone_id");
        q.setParameter("zone_id", (Object)zone_id);
        List cities = q.getResultList();
        return cities;
    }

    public void change(CityDeliveryInfo city) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update CityDeliveryInfo c set c.city = :city, c.zipCode = :zipCode where c.id = :id ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setString("city", city.getCity()).setString("zipCode", city.getZipCode()).setInteger("id", city.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public void setZone(CityDeliveryInfo city) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update CityDeliveryInfo c set c.idZoneDelivery = :idZoneDelivery where c.id = :id ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setInteger("idZoneDelivery", city.getIdZoneDelivery()).setInteger("id", city.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public CityDeliveryInfo findByZipCod(String zipCode) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query q = session.createQuery("from CityDeliveryInfo c WHERE c.zipCode = :zipCode");
            q.setParameter("zipCode", (Object)zipCode);
            List cities = q.list();
            tx.commit();
            return cities != null && !cities.isEmpty() ? (CityDeliveryInfo)cities.get(0) : null;
        }
        return null;
    }
}

