/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class CaisseInfoDao
extends DaoConfig<CaisseInfo> {
    @Override
    protected Class<CaisseInfo> classType() {
        return CaisseInfo.class;
    }

    public CaisseInfo findByToken(String token) {
        CaisseInfo caisseInfo;
        block4: {
            caisseInfo = null;
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from CaisseInfo c WHERE c.token = :token");
                    q.setParameter("token", (Object)token);
                    List caisses = q.list();
                    tx.commit();
                    session.close();
                    caisseInfo = caisses != null && !caisses.isEmpty() ? (CaisseInfo)caisses.get(0) : null;
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return caisseInfo;
    }

    public int doOpenCaisse(CaisseInfo mCaisseInfo) {
        int result;
        block4: {
            Session session = null;
            Transaction tx = null;
            result = 0;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("UPDATE CaisseInfo SET dateOpen = :dateOpen, fondCaisse = :fondCaisse, ouverte = true, userOpen.id = :user_id WHERE id = :id");
                    q.setParameter("dateOpen", (Object)mCaisseInfo.getDateOpen());
                    q.setParameter("fondCaisse", (Object)NumericUtils.round(mCaisseInfo.getFondCaisse()));
                    q.setParameter("user_id", (Object)mCaisseInfo.getUser_open().getId());
                    q.setParameter("id", (Object)mCaisseInfo.getId());
                    result = q.executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return result;
    }

    public int doCloseCaisse(CaisseInfo mCaisseInfo) {
        int result;
        block4: {
            Session session = null;
            Transaction tx = null;
            result = 0;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("UPDATE CaisseInfo SET dateClose = :dateClose, fondClose = :fondClose, ouverte = false, userClose.id = :user_id WHERE id = :id");
                    q.setParameter("dateClose", (Object)mCaisseInfo.getDateClose());
                    q.setParameter("fondClose", (Object)NumericUtils.round(mCaisseInfo.getFondClose()));
                    q.setParameter("user_id", (Object)mCaisseInfo.getUser_close().getId());
                    q.setParameter("id", (Object)mCaisseInfo.getId());
                    result = q.executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return result;
    }

    public int updateStatusBlocked(CaisseInfo mCaisseInfo) {
        int result = 0;
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = null;
            try {
                tx = session.beginTransaction();
                Query q = session.createQuery("UPDATE CaisseInfo SET blocked = :blocked , active = :active WHERE id = :id");
                q.setParameter("blocked", (Object)mCaisseInfo.isBlocked());
                q.setParameter("active", (Object)mCaisseInfo.isActive());
                q.setParameter("id", (Object)mCaisseInfo.getId());
                result = q.executeUpdate();
                tx.commit();
                session.close();
                return result;
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return result;
    }
}

