/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.BorneInfo;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class BorneInfoDao
extends DaoConfig<BorneInfo> {
    @Override
    protected Class<BorneInfo> classType() {
        return BorneInfo.class;
    }

    public void setAddress(BorneInfo borne) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    String hqlUpdate = "update BorneInfo b set b.address_ip = :address where b.id = :id ";
                    tx = session.beginTransaction();
                    int updatedEntities = session.createQuery(hqlUpdate).setString("address", borne.getAddress_ip()).setInteger("id", borne.getId().intValue()).executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public void setName(BorneInfo borne) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    String hqlUpdate = "update BorneInfo b set b.name_borne = :name_borne where b.id = :id ";
                    tx = session.beginTransaction();
                    int updatedEntities = session.createQuery(hqlUpdate).setString("name_borne", borne.getName_borne()).setInteger("id", borne.getId().intValue()).executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public void setPaymentEnabled(BorneInfo borne) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    String hqlUpdate = "update BorneInfo b set b.payment_enabled = :payment_enabled where b.id = :id ";
                    tx = session.beginTransaction();
                    int updatedEntities = session.createQuery(hqlUpdate).setBoolean("payment_enabled", borne.isPayment_enabled()).setInteger("id", borne.getId().intValue()).executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public void changeBorneStatus(BorneInfo borne) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    String hqlUpdate = "update BorneInfo b set b.blocked = :blocked where b.id = :id ";
                    tx = session.beginTransaction();
                    int updatedEntities = session.createQuery(hqlUpdate).setBoolean("blocked", borne.isBlocked()).setInteger("id", borne.getId().intValue()).executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public List<BorneInfo> getBornesByName(String name) {
        List<BorneInfo> bornes;
        block4: {
            bornes = new ArrayList<BorneInfo>();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from BorneInfo b WHERE b.name_borne like 'Equipement%'");
                    bornes = q.list();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return bornes;
    }

    public List<BorneInfo> getAllBorne() {
        List<BorneInfo> bornes;
        block4: {
            bornes = new ArrayList<BorneInfo>();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from BorneInfo b");
                    bornes = q.list();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return bornes;
    }

    public void setDisableEquipment(BorneInfo borne) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    String hqlUpdate = "update BorneInfo b set b.equipment_disabled = :equipment_disabled where b.id = :id ";
                    tx = session.beginTransaction();
                    int updatedEntities = session.createQuery(hqlUpdate).setBoolean("equipment_disabled", borne.isEquipment_disabled()).setInteger("id", borne.getId().intValue()).executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public List<BorneInfo> getEnabledBornes() {
        List<BorneInfo> bornes;
        block4: {
            bornes = new ArrayList<BorneInfo>();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from BorneInfo b where b.equipment_disabled = :equipment_disabled");
                    q.setBoolean("equipment_disabled", false);
                    bornes = q.list();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return bornes;
    }

    public void setOnseatEnabled(BorneInfo borne) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update BorneInfo b set b.onseatEnabled = :onseatEnabled where b.id = :id ";
            Transaction tx = session.beginTransaction();
            session.createQuery(hqlUpdate).setBoolean("onseatEnabled", borne.isOnseatEnabled()).setInteger("id", borne.getId().intValue()).executeUpdate();
            tx.commit();
        }
    }

    public void setInMaintenance(BorneInfo borne) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update BorneInfo b set b.inMaintenance = :inMaintenance where b.id = :id ";
            Transaction tx = session.beginTransaction();
            session.createQuery(hqlUpdate).setBoolean("inMaintenance", borne.isInMaintenance()).setInteger("id", borne.getId().intValue()).executeUpdate();
            tx.commit();
        }
    }

    public void saveSettings(BorneInfo borne) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update BorneInfo b set b.payment_enabled = :payment_enabled where b.id = :id ";
            Transaction tx = session.beginTransaction();
            session.createQuery(hqlUpdate).setBoolean("payment_enabled", borne.isPayment_enabled()).setInteger("id", borne.getId().intValue()).executeUpdate();
            tx.commit();
        }
    }
}

