/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.BasketDeletedItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class BasketDeletedItemDao
extends DaoConfig<BasketDeletedItem> {
    @Override
    protected Class<BasketDeletedItem> classType() {
        return BasketDeletedItem.class;
    }

    public List<BasketDeletedItem> getUploadedItems() {
        List<BasketDeletedItem> deletedItems;
        block4: {
            deletedItems = new ArrayList<BasketDeletedItem>();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from BasketDeletedItem b WHERE b.is_synch = :is_synch");
                    q.setParameter("is_synch", (Object)true);
                    deletedItems = q.list();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return deletedItems;
    }

    public void addDeletedItem(BasketDeletedItem item) {
        block4: {
            ArrayList deletedItems = new ArrayList();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    session.save((Object)item);
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public void updateDeletedItem(BasketDeletedItem item) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    String hqlUpdate = "update BasketDeletedItem b set b.is_synch = :is_synch, b.type = :type where b.id = :id";
                    int updatedEntities = session.createQuery(hqlUpdate).setBoolean("is_synch", true).setInteger("id", item.getId().intValue()).executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public void deleteItem(BasketDeletedItem item) {
        block4: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    String hqlUpdate = "delete from  BasketDeletedItem b  where b.id = :id";
                    int updatedEntities = session.createQuery(hqlUpdate).setInteger("id", item.getId().intValue()).executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public List<BasketDeletedItem> findDeletedItemsByTimeRange(Date dateStart, Date dateEnd) {
        List<BasketDeletedItem> result;
        block4: {
            result = new ArrayList<BasketDeletedItem>();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query query = session.createQuery("from BasketDeletedItem b WHERE  b.dateDeleted <= :dateEnd AND b.dateDeleted >= :dateStart order by id desc");
                    query.setParameter("dateStart", (Object)dateStart);
                    query.setParameter("dateEnd", (Object)dateEnd);
                    result = query.list();
                    tx.commit();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return result;
    }
}

