/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.BankNotePOS;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class BankNotePOSDao
extends DaoConfig<BankNotePOS> {
    @Override
    protected Class<BankNotePOS> classType() {
        return BankNotePOS.class;
    }

    public List<BankNotePOS> getBankNotes(int currencyId) {
        List<BankNotePOS> bankNotes = new ArrayList<BankNotePOS>();
        if (sessionFactory != null) {
            Session session = null;
            Transaction tx = null;
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query query = session.createQuery("from BankNotePOS B WHERE B.currencyPOS.id = :currencyId");
                query.setParameter("currencyId", (Object)currencyId);
                bankNotes = query.getResultList();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", null, ex);
            }
        }
        return bankNotes;
    }

    public void saveBankNotePOS(BankNotePOS bankNotePOS) {
        if (sessionFactory != null) {
            Session session = null;
            Transaction tx = null;
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                session.save((Object)bankNotePOS);
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public void deleteBankNotePOS(BankNotePOS bankNotePOS) {
        if (sessionFactory != null) {
            Session session = null;
            Transaction tx = null;
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query q = session.createQuery("DELETE FROM BankNotePOS B WHERE B.id = :id");
                q.setParameter("id", (Object)bankNotePOS.getId());
                int result = q.executeUpdate();
                tx.commit();
                session.close();
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                if (session != null) {
                    session.close();
                }
                LogToFile.log("severe", null, ex);
            }
        }
    }
}

