/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.AllergeneSupplement;
import fr.protactile.procaisse.dao.entities.SupplementItemInfo;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class AllergeneSupplementDao
extends DaoConfig<AllergeneSupplement> {
    @Override
    protected Class<AllergeneSupplement> classType() {
        return AllergeneSupplement.class;
    }

    public List<AllergeneSupplement> getAllAllergeneSupplements() {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            List list = session.createQuery("from AllergeneSupplement", AllergeneSupplement.class).list();
            tx.commit();
            session.close();
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AllergeneSupplement> getAllergenesBySupplement(SupplementItemInfo supplement) {
        Session session = null;
        Transaction tx = null;
        List list = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query query = session.createQuery("from AllergeneSupplement a where a.supplementItem.id = :supplementId", AllergeneSupplement.class);
                query.setParameter("supplementId", (Object)supplement.getId());
                list = query.list();
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return list;
    }

    public void addAllergeneSupplement(AllergeneSupplement allergene) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)allergene);
            tx.commit();
            session.close();
        }
    }

    public void addAllergeneSupplement(int supplementId, String allergeneName) {
        SupplementItemInfo supplement = new SupplementItemInfo();
        supplement.setId(supplementId);
        AllergeneSupplement allergene = new AllergeneSupplement();
        allergene.setName(allergeneName);
        allergene.setSupplementItem(supplement);
        this.save(allergene);
    }

    public void deleteAllergeneSupplement(AllergeneSupplement allergene) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.delete((Object)allergene);
            tx.commit();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllergeneSupplement getAllergeneSupplement(int supplementId, String name) {
        Session session = null;
        Transaction tx = null;
        AllergeneSupplement result = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query query = session.createQuery("from AllergeneSupplement a where a.supplementItem.id = :supplementId and a.name = :name", AllergeneSupplement.class);
                query.setParameter("supplementId", (Object)supplementId);
                query.setParameter("name", (Object)name);
                result = (AllergeneSupplement)query.uniqueResult();
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllAllergeneSupplements() {
        if (sessionFactory != null) {
            Transaction tx = null;
            try (Session session = sessionFactory.openSession();){
                tx = session.beginTransaction();
                session.createQuery("DELETE FROM AllergeneSupplement").executeUpdate();
                tx.commit();
            }
        }
    }

    public void deleteAllAllergeneSupplementsForSupplement(int supplementId) {
        Session session = sessionFactory.getCurrentSession();
        Transaction tx = session.beginTransaction();
        session.createQuery("DELETE FROM AllergeneSupplement a WHERE a.supplementItem.id = :supplementId").setParameter("supplementId", (Object)supplementId).executeUpdate();
        tx.commit();
        session.close();
    }

    public List<AllergeneSupplement> getAllergeneSupplementsForSupplement(int supplementId) {
        Session session = sessionFactory.getCurrentSession();
        Transaction tx = session.beginTransaction();
        List allergenes = session.createQuery("FROM AllergeneSupplement a WHERE a.supplementItem.id = :supplementId", AllergeneSupplement.class).setParameter("supplementId", (Object)supplementId).getResultList();
        tx.commit();
        session.close();
        return allergenes;
    }

    public void deleteAllergeneSupplement(int supplementId, String allergeneName) {
        Session session = sessionFactory.getCurrentSession();
        Transaction tx = session.beginTransaction();
        session.createQuery("DELETE FROM AllergeneSupplement a WHERE a.supplementItem.id = :supplementId AND a.name = :name").setParameter("supplementId", (Object)supplementId).setParameter("name", (Object)allergeneName).executeUpdate();
        tx.commit();
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllergeneSupplement(AllergeneSupplement allergene) {
        List<AllergeneSupplement> existingList = this.getAllergenesBySupplement(allergene.getSupplementItem());
        if (!existingList.contains(allergene) && sessionFactory != null) {
            Transaction tx = null;
            try (Session session = sessionFactory.openSession();){
                tx = session.beginTransaction();
                session.save((Object)allergene);
                tx.commit();
            }
        }
    }

    public void updateAllergeneSupplement(AllergeneSupplement info, int supplementId) {
        AllergeneSupplement existing = this.getAllergeneSupplement(supplementId, info.getName());
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            if (existing == null) {
                this.addAllergeneSupplementItemInfo(supplementId, info);
            }
            tx.commit();
            session.close();
        }
    }

    public void addAllergeneSupplementItemInfo(int supplementId, AllergeneSupplement allergene) {
        SupplementItemInfo supplement = new SupplementItemInfo();
        supplement.setId(supplementId);
        allergene.setSupplementItem(supplement);
        this.save(allergene);
    }
}

