/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.Allergene;
import fr.protactile.procaisse.dao.entities.ProductInfo;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class AllergeneDao
extends DaoConfig<Allergene> {
    @Override
    protected Class<Allergene> classType() {
        return Allergene.class;
    }

    public List<Allergene> getAllAllergenes() {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("from Allergene", Allergene.class);
            List list = query.list();
            tx.commit();
            session.close();
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Allergene> getAllergenesByProduct(ProductInfo product) {
        Session session = null;
        Transaction tx = null;
        List list = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query query = session.createQuery("from Allergene a where a.product.id = :productId", Allergene.class);
                query.setParameter("productId", (Object)product.getId());
                list = query.list();
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return list;
    }

    public void addAllergene(Allergene allergene) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)allergene);
            tx.commit();
            session.close();
        }
    }

    public void addAllergene(int productId, String allergeneName) {
        ProductInfo productInfo = new ProductInfo();
        productInfo.setId(productId);
        Allergene allergene = new Allergene();
        allergene.setName(allergeneName);
        allergene.setProduct(productInfo);
        this.save(allergene);
    }

    public void deleteAllergene(Allergene allergene) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.delete((Object)allergene);
            tx.commit();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllergene(Allergene allergene) {
        List<Allergene> existingList = this.getAllergenesByProduct(allergene.getProduct());
        if (!existingList.contains(allergene) && sessionFactory != null) {
            Transaction tx = null;
            try (Session session = sessionFactory.openSession();){
                tx = session.beginTransaction();
                session.save((Object)allergene);
                tx.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllAllergenes() {
        System.out.println("********* deleteAllAllergenes *****");
        if (sessionFactory != null) {
            Transaction tx = null;
            try (Session session = sessionFactory.openSession();){
                tx = session.beginTransaction();
                String hql = "DELETE FROM Allergene";
                Query query = session.createQuery(hql);
                query.executeUpdate();
                tx.commit();
            }
        }
    }

    public void updateAllergene(Allergene info, int product) {
        Allergene existingInfo = this.getAllergeneProduct(product, info.getName());
        System.out.println("/////////////////////// existingInfo :" + existingInfo);
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            if (existingInfo == null) {
                this.addAllergeneInfo(product, info);
            }
            tx.commit();
            session.close();
        }
    }

    public void addAllergeneInfo(int product, Allergene mAllergene) {
        System.out.println("************ addAllergeneInfo with product " + product);
        ProductInfo productInfo = new ProductInfo();
        productInfo.setId(product);
        mAllergene.setProduct(productInfo);
        this.save(mAllergene);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Allergene getAllergeneProduct(int product, String name) {
        Session session = null;
        Transaction tx = null;
        Allergene result = null;
        if (sessionFactory != null) {
            try {
                session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query query = session.createQuery("from Allergene n where n.product.id = :product and n.name = :name", Allergene.class);
                query.setParameter("product", (Object)product);
                query.setParameter("name", (Object)name);
                result = (Allergene)query.uniqueResult();
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return result;
    }

    public void deleteAllAllergenesForProduct(int productId) {
        Session session = sessionFactory.getCurrentSession();
        Transaction tx = session.beginTransaction();
        String hql = "DELETE FROM Allergene a where a.product.id = :productId";
        session.createQuery(hql).setParameter("productId", (Object)productId).executeUpdate();
        tx.commit();
        session.close();
    }

    public List<Allergene> getAllergenesForProduct(int productId) {
        Session session = sessionFactory.getCurrentSession();
        Transaction tx = session.beginTransaction();
        String hql = "FROM Allergene a where a.product.id = :productId";
        List allergenes = session.createQuery(hql, Allergene.class).setParameter("productId", (Object)productId).getResultList();
        tx.commit();
        session.close();
        return allergenes;
    }

    public void deleteAllergene(int productId, String allergeneName) {
        Session session = sessionFactory.getCurrentSession();
        Transaction tx = session.beginTransaction();
        String hql = "DELETE FROM Allergene a where a.product.id = :productId AND a.name = :name";
        session.createQuery(hql).setParameter("productId", (Object)productId).setParameter("name", (Object)allergeneName).executeUpdate();
        tx.commit();
        session.close();
    }
}

