/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class AddressInfoDao
extends DaoConfig<AddressInfo> {
    @Override
    protected Class<AddressInfo> classType() {
        return AddressInfo.class;
    }

    public List<AddressInfo> findByCustomer(Integer id) {
        List<AddressInfo> result;
        block5: {
            result = new ArrayList<AddressInfo>();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    CustomerInfo customer = (CustomerInfo)session.get(CustomerInfo.class, (Serializable)id);
                    if (customer == null) {
                        tx.rollback();
                        return result;
                    }
                    Query q = session.createQuery("from AddressInfo a WHERE a.customer.id = :customer_id");
                    q.setParameter("customer_id", (Object)id);
                    result = q.getResultList();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block5;
                    session.close();
                }
            }
        }
        return result;
    }

    public AddressInfo findAddress(AddressInfo mAddressInfo) {
        block5: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from AddressInfo a WHERE a.address = :address AND a.city = :city AND a.zipcode = :zipcode AND a.batiment = :batiment AND a.entrycode = :entrycode AND a.etage = :etage AND a.appartement = :appartement AND a.interphone = :interphone ");
                    q.setParameter("address", (Object)mAddressInfo.getAddress());
                    q.setParameter("city", (Object)mAddressInfo.getCity());
                    q.setParameter("zipcode", (Object)mAddressInfo.getZipcode());
                    q.setParameter("batiment", (Object)mAddressInfo.getBatiment());
                    q.setParameter("entrycode", (Object)mAddressInfo.getEntrycode());
                    q.setParameter("etage", (Object)mAddressInfo.getEtage());
                    q.setParameter("appartement", (Object)mAddressInfo.getAppartement());
                    q.setParameter("interphone", (Object)mAddressInfo.getInterphone());
                    List result = q.list();
                    tx.commit();
                    session.close();
                    if (result != null && result.size() > 0) {
                        mAddressInfo.setId(((AddressInfo)result.get(0)).getId());
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block5;
                    session.close();
                }
            }
        }
        return mAddressInfo;
    }

    public List<AddressInfo> fetchNotSynchronizedAdress() {
        ArrayList<AddressInfo> result;
        block5: {
            result = new ArrayList<AddressInfo>();
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from AddressInfo a WHERE a.isSynchro = :isSynchro");
                    q.setParameter("isSynchro", (Object)false);
                    List unsynchronizedAddresses = q.list();
                    for (AddressInfo address : unsynchronizedAddresses) {
                        CustomerInfo customer = address.getCustomer();
                        if (customer == null) continue;
                        result.add(address);
                    }
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block5;
                    session.close();
                }
            }
        }
        return result;
    }

    public AddressInfo findAddress(AddressInfo mAddressInfo, Integer id) {
        block5: {
            Session session = null;
            Transaction tx = null;
            if (sessionFactory != null) {
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from AddressInfo a WHERE a.address = :address AND a.city = :city AND a.zipcode = :zipcode AND a.batiment = :batiment AND a.entrycode = :entrycode AND a.etage = :etage AND a.appartement = :appartement AND a.interphone = :interphone AND a.customer.id = :customer_id ");
                    q.setParameter("address", (Object)mAddressInfo.getAddress());
                    q.setParameter("city", (Object)mAddressInfo.getCity());
                    q.setParameter("zipcode", (Object)mAddressInfo.getZipcode());
                    q.setParameter("batiment", (Object)mAddressInfo.getBatiment());
                    q.setParameter("entrycode", (Object)mAddressInfo.getEntrycode());
                    q.setParameter("etage", (Object)mAddressInfo.getEtage());
                    q.setParameter("appartement", (Object)mAddressInfo.getAppartement());
                    q.setParameter("interphone", (Object)mAddressInfo.getInterphone());
                    q.setParameter("customer_id", (Object)id);
                    List result = q.list();
                    tx.commit();
                    session.close();
                    if (result != null && result.size() > 0) {
                        mAddressInfo.setId(((AddressInfo)result.get(0)).getId());
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block5;
                    session.close();
                }
            }
        }
        return mAddressInfo;
    }
}

