/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.entities;

import com.openbravo.format.Formats;
import com.openbravo.pos.util.NumericUtils;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="REDUCTIONS")
@XmlRootElement
public class ReductionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Size(max=255)
    @Column(name="NAME")
    private @Size(max=255) String name;
    @NotNull
    @Column(name="REDUCTION")
    private double reduction;
    @Size(max=255)
    @Column(name="TYPE")
    private @Size(max=255) String type;

    public ReductionInfo() {
    }

    public ReductionInfo(String name) {
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getReduction() {
        return this.reduction;
    }

    public void setReduction(double reduction) {
        this.reduction = reduction;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String printName() {
        return this.getLabelDiscount("\n");
    }

    public String getLabelDiscount(String touche) {
        StringBuilder text_discount = new StringBuilder();
        text_discount.append(this.name);
        text_discount.append(touche);
        text_discount.append("-");
        text_discount.append(NumericUtils.numberToString(this.reduction));
        text_discount.append(" ");
        text_discount.append(this.type.equals("pourcentage") ? "%" : Formats.getCurrency());
        return text_discount.toString();
    }

    public String getLabelDiscount() {
        return this.getLabelDiscount(" ");
    }

    public String getDiscountValue() {
        StringBuilder text_discount = new StringBuilder();
        text_discount.append(NumericUtils.numberToString(this.reduction));
        text_discount.append(" ");
        text_discount.append(this.type.equals("pourcentage") ? "%" : Formats.getCurrency());
        return text_discount.toString();
    }
}

