/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.entities;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.PertInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="PERTE_MARCHANDISE")
@XmlRootElement
public class PertEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Column(name="RAISON")
    @Size(max=1024)
    private @Size(max=1024) String raison;
    @Column(name="CAISSIER")
    @Size(max=255)
    private @Size(max=255) String caissier;
    @Column(name="DELETED", columnDefinition="boolean default false", nullable=false)
    private boolean deleted;
    @Column(name="CREATEDAT")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created_at;
    @Column(name="TOTAL")
    private double total;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="perteEntity", fetch=FetchType.LAZY)
    private List<PertInfo> pertInfoCollection;

    public PertEntity() {
        this.pertInfoCollection = new ArrayList<PertInfo>();
    }

    public PertEntity(Integer id, int number, String name_product, String name_category, String caissier, int nb_items, String raison, boolean deleted, Date created_at) {
        this.id = id;
        this.raison = raison;
        this.deleted = deleted;
        this.created_at = created_at;
        this.total = this.total;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getRaison() {
        return this.raison;
    }

    public String getCaissier() {
        return this.caissier;
    }

    public void setCaissier(String caissier) {
        this.caissier = caissier;
    }

    public void setRaison(String raison) {
        this.raison = raison;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Date getCreated_at() {
        return this.created_at;
    }

    public void setCreated_at(Date created_at) {
        this.created_at = created_at;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                PertEntity mPerteEntity = new PertEntity();
                mPerteEntity.setId(dr.getInt(1));
                mPerteEntity.setCaissier(dr.getString(2));
                mPerteEntity.setRaison(dr.getString(3));
                mPerteEntity.setCreated_at(dr.getTimestamp(4));
                mPerteEntity.setDeleted(dr.getBoolean(5));
                mPerteEntity.setTotal(dr.getDouble(6));
                return mPerteEntity;
            }
        };
    }

    public List<PertInfo> getPertInfoCollection() {
        return this.pertInfoCollection;
    }

    public void setPertInfoCollection(List<PertInfo> pertInfoCollection) {
        this.pertInfoCollection = pertInfoCollection;
    }
}

