/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.entities;

import com.openbravo.pos.util.LogToFile;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="NUTRIENT_DATA")
public class NutrientData
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Column(name="IMAGE")
    private String image;
    @Column(name="COLOR")
    private String color;
    @Column(name="NUTRIENT")
    private String nutrient;

    public NutrientData() {
    }

    public NutrientData(String image, String color, String nutrient) {
        this.image = image;
        this.color = color;
        this.nutrient = nutrient;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getNutrient() {
        return this.nutrient;
    }

    public void setNutrient(String nutrient) {
        this.nutrient = nutrient;
    }

    public void onBeforeSave() {
        try {
            if (this.nutrient == null || this.nutrient.trim().isEmpty()) {
                this.nutrient = "Unknown";
            }
            if (this.color == null || this.color.trim().isEmpty()) {
                this.color = "#000000";
            }
            if (this.image == null) {
                this.image = "";
            }
        }
        catch (Exception e) {
            LogToFile.log("NutrientData.onBeforeSave: " + e.getMessage());
        }
    }

    public String toString() {
        return "NutrientData{id=" + this.id + ", image=" + this.image + ", color=" + this.color + ", nutrient=" + this.nutrient + "}";
    }
}

