/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.entities;

import fr.protactile.procaisse.dao.entities.CustomerInfo;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="LOYALTYCARD")
@XmlRootElement
public class LoyaltyCardInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(max=255)
    @Column(name="CODE_CARTE")
    private @NotNull @Size(max=255) String code_carte;
    @Column(name="CREDIT")
    private Double credit;
    @Column(name="INITIALIZED_AT")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date initialized_at;
    @Column(name="NUMBER_USE")
    private Integer number_use;
    @JoinColumn(name="CUSTOMER", referencedColumnName="ID")
    @ManyToOne(optional=false)
    private CustomerInfo customer;

    public LoyaltyCardInfo() {
    }

    public LoyaltyCardInfo(Integer id) {
        this.id = id;
    }

    public LoyaltyCardInfo(Integer id, String code_carte, double credit) {
        this.id = id;
        this.code_carte = code_carte;
        this.credit = credit;
    }

    public LoyaltyCardInfo(String code_carte) {
        this.code_carte = code_carte;
        this.credit = 0.0;
    }

    public LoyaltyCardInfo(String code_carte, int idCustomer, double credit) {
        this.code_carte = code_carte;
        this.customer = new CustomerInfo(idCustomer);
        this.credit = credit;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public CustomerInfo getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerInfo c) {
        this.customer = c;
    }

    public String getCode_carte() {
        return this.code_carte;
    }

    public void setCode_carte(String code_carte) {
        this.code_carte = code_carte;
    }

    public Double getCredit() {
        return this.credit;
    }

    public void setCredit(Double credit) {
        this.credit = credit;
    }

    public Date getInitialized_at() {
        return this.initialized_at;
    }

    public void setInitialized_at(Date initialized_at) {
        this.initialized_at = initialized_at;
    }

    public Integer getNumber_use() {
        return this.number_use;
    }

    public void setNumber_use(Integer number_use) {
        this.number_use = number_use;
    }

    public void setIdCustomer(int id) {
        if (this.customer == null) {
            this.customer = new CustomerInfo(id);
        } else {
            this.customer.setId(id);
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LoyaltyCardInfo)) {
            return false;
        }
        LoyaltyCardInfo other = (LoyaltyCardInfo)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "fr.protactile.dao.entities.LoyaltyCardInfo[ id=" + this.id + " ]";
    }
}

