/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.entities;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.PaymentInfo;
import fr.protactile.procaisse.dao.entities.TicketInfo;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="DEBIT_CUSTOMER")
@XmlRootElement
public class DebitCustomerInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Size(max=256)
    @Column(name="TRANSFER_NUM")
    private @Size(max=256) String transferNumber;
    @Column(name="DATE_PAYMENT")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date datePayment;
    @Basic(optional=false)
    @NotNull
    @Column(name="AMOUNT")
    private Double amount;
    @Basic(optional=false)
    @NotNull
    @Column(name="PAID")
    private Boolean paid = false;
    @JoinColumn(name="CUSTOMER", referencedColumnName="ID")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private CustomerInfo customer;
    @JoinColumn(name="PAYMENT", referencedColumnName="ID")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private PaymentInfo payment;
    @JoinColumn(name="TICKET", referencedColumnName="ID")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private TicketInfo ticket;
    @Transient
    private Integer num_order;

    public DebitCustomerInfo() {
    }

    public DebitCustomerInfo(Integer id) {
        this.id = id;
    }

    public DebitCustomerInfo(Integer id, Double amount, Boolean paid) {
        this.id = id;
        this.amount = amount;
        this.paid = paid;
    }

    public DebitCustomerInfo(Double amount, Date datePayment, int num_order, Boolean paid, String num_transfer) {
        this.amount = amount;
        this.datePayment = datePayment;
        this.num_order = num_order;
        this.paid = paid;
        this.transferNumber = num_transfer;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTransferNumber() {
        return this.transferNumber;
    }

    public void setTransferNumber(String transferNum) {
        this.transferNumber = transferNum;
    }

    public Date getDatePayment() {
        return this.datePayment;
    }

    public void setDatePayment(Date datePayment) {
        this.datePayment = datePayment;
    }

    public Integer getNumOrder() {
        return this.num_order;
    }

    public void setNumOrder(Integer num_order) {
        this.num_order = num_order;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Boolean isPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public PaymentInfo getPayment() {
        return this.payment;
    }

    public void setPayment(PaymentInfo paymefnt) {
        this.payment = paymefnt;
    }

    public TicketInfo getTicket() {
        return this.ticket;
    }

    public void setTicket(TicketInfo ticket) {
        this.ticket = ticket;
        if (this.ticket != null && this.ticket.getNumeroOrder() != null) {
            this.setNumOrder(this.ticket.getNumeroOrder());
        } else {
            this.setNumOrder(0);
        }
    }

    public CustomerInfo getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerInfo customer) {
        this.customer = customer;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DebitCustomerInfo)) {
            return false;
        }
        DebitCustomerInfo other = (DebitCustomerInfo)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "fr.protactile.procaisse.dao.entities.DebitCustomerInfo[ id=" + this.id + " ]";
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                DebitCustomerInfo debit = new DebitCustomerInfo(dr.getDouble(2), dr.getTimestamp(3), dr.getInt(4), dr.getBoolean(5), dr.getString(6));
                debit.setId(dr.getInt(1));
                return debit;
            }
        };
    }
}

