/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.entities;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.util.RoundUtils;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.DebitCustomerInfo;
import fr.protactile.procaisse.dao.entities.LoyaltyCardInfo;
import fr.protactile.procaisse.dao.entities.TaxCustomerCategory;
import fr.protactile.procaisse.dao.entities.TicketInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="CUSTOMERS")
@XmlRootElement
public class CustomerInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Size(max=1024)
    @Column(name="TAXID")
    private @Size(max=1024) String taxid;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=1024)
    @Column(name="NAME")
    private @NotNull @Size(min=1, max=1024) String name;
    @Size(max=255)
    @Column(name="PHONE")
    private @Size(max=255) String phone;
    @Size(max=1024)
    @Column(name="CARD")
    private @Size(max=1024) String card;
    @Basic(optional=false)
    @NotNull
    @Column(name="MAXDEBT")
    private double maxdebt;
    @Size(max=1024)
    @Column(name="NOTES")
    private @Size(max=1024) String notes;
    @Column(name="CURDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date curdate;
    @Column(name="CURDEBT")
    private Double curdebt;
    @Size(max=20)
    @Column(name="PHONE2")
    private @Size(max=20) String phone2;
    @Size(max=255)
    @Column(name="EMAIL")
    private @Size(max=255) String email;
    @Column(name="COMPANY")
    private Integer company;
    @Column(name="DISCOUNT")
    private Double discount;
    @Size(max=255)
    @Column(name="RESPONSIBLE")
    private @Size(max=255) String responsible;
    @Size(max=255)
    @Column(name="COMPANYNAME")
    private @Size(max=255) String companyname;
    @Size(max=255)
    @Column(name="INTERLOCUTOR")
    private @Size(max=255) String interlocutor;
    @Size(max=255)
    @Column(name="FUNCTION_INT")
    private @Size(max=255) String function_interlocutor;
    @Size(max=255)
    @Column(name="RANGECOMPANY")
    private @Size(max=255) String range;
    @Size(max=255)
    @Column(name="TYPE")
    private @Size(max=255) String type;
    @Basic(optional=false)
    @NotNull
    @Column(name="VISIBLE")
    private Boolean visible;
    @Basic(optional=false)
    @NotNull
    @Column(name="REMOVED")
    private Boolean removed;
    @Column(name="TURNOVER")
    private Double turnover;
    @Column(name="NB_ORDERS")
    private Integer nb_orders;
    @Column(name="LAST_ORDER")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date last_order;
    @JoinColumn(name="TAXCATEGORY", referencedColumnName="ID")
    @ManyToOne
    private TaxCustomerCategory taxcategory;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer")
    private List<AddressInfo> adresseInfoCollection;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer", fetch=FetchType.LAZY)
    private List<DebitCustomerInfo> debitCustomerInfoList;
    @OneToMany(mappedBy="customer", fetch=FetchType.LAZY)
    private List<TicketInfo> ticketInfoList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer")
    private List<LoyaltyCardInfo> loyaltyCardCollection;
    @Size(max=255)
    @Column(name="PREFIX_PHONE")
    private @Size(max=255) String prefix_phone;
    @Column(name="SIRET")
    private String siret;
    @Column(name="CODE_NAF")
    private String code_NAF;
    @Column(name="NUM_TVA")
    private String num_tva;
    @Column(name="ISSYNCHROCLIENT")
    private boolean isSynchro;

    public CustomerInfo() {
        this.loyaltyCardCollection = new ArrayList<LoyaltyCardInfo>();
        this.isSynchro = false;
    }

    public CustomerInfo(Integer id) {
        this.id = id;
    }

    public CustomerInfo(Integer id, String name, double maxdebt, Boolean visible, Boolean removed) {
        this.id = id;
        this.name = name;
        this.maxdebt = maxdebt;
        this.visible = visible;
        this.removed = removed;
    }

    public CustomerInfo(String name, String phone, String phone2, String notes) {
        this.name = name;
        this.phone = phone;
        this.notes = notes;
        this.phone2 = phone2;
    }

    public CustomerInfo(String name, String phone, String phone2, String notes, String email) {
        this.name = name;
        this.phone = phone;
        this.notes = notes;
        this.phone2 = phone2;
        this.email = email;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTaxid() {
        return this.taxid;
    }

    public void setTaxid(String taxid) {
        this.taxid = taxid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCard() {
        return this.card;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public double getMaxdebt() {
        return this.maxdebt;
    }

    public void setMaxdebt(double maxdebt) {
        this.maxdebt = maxdebt;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Date getCurdate() {
        return this.curdate;
    }

    public void setCurdate(Date curdate) {
        this.curdate = curdate;
    }

    public Double getCurdebt() {
        return this.curdebt;
    }

    public void setCurdebt(Double curdebt) {
        this.curdebt = curdebt;
    }

    public String getPhone2() {
        return this.phone2;
    }

    public void setPhone2(String phone2) {
        this.phone2 = phone2;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getCompany() {
        return this.company;
    }

    public void setCompany(Integer company) {
        this.company = company;
    }

    public Double getDiscount() {
        return this.discount;
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public void setResponsible(String responsible) {
        this.responsible = responsible;
    }

    public String getCompanyname() {
        return this.companyname;
    }

    public void setCompanyname(String companyname) {
        this.companyname = companyname;
    }

    public String getInterlocutor() {
        return this.interlocutor;
    }

    public void setInterlocutor(String interlocutor) {
        this.interlocutor = interlocutor;
    }

    public String getFunction_interlocutor() {
        return this.function_interlocutor;
    }

    public void setFunction_interlocutor(String function_interlocutor) {
        this.function_interlocutor = function_interlocutor;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String rangecompany) {
        this.range = rangecompany;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TaxCustomerCategory getTaxcategory() {
        return this.taxcategory;
    }

    public void setTaxcategory(TaxCustomerCategory taxcategory) {
        this.taxcategory = taxcategory;
    }

    @XmlTransient
    public List<AddressInfo> getAdresseInfoCollection() {
        return this.adresseInfoCollection;
    }

    public void setAdresseInfoCollection(List<AddressInfo> adresseInfoCollection) {
        this.adresseInfoCollection = adresseInfoCollection;
    }

    @XmlTransient
    public List<LoyaltyCardInfo> getLoyaltyCardCollection() {
        return this.loyaltyCardCollection;
    }

    public void setLoyaltyCardCollection(List<LoyaltyCardInfo> loyaltyCardCollection) {
        this.loyaltyCardCollection = loyaltyCardCollection;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Boolean getRemoved() {
        return this.removed;
    }

    public void setRemoved(Boolean removed) {
        this.removed = removed;
    }

    public Boolean getIsSynchro() {
        return this.isSynchro;
    }

    public void setIsSynchro(Boolean isSynchro) {
        this.isSynchro = isSynchro;
    }

    public Double getTurnover() {
        return this.turnover;
    }

    public void setTurnover(Double turnover) {
        this.turnover = turnover;
    }

    public Integer getNb_orders() {
        return this.nb_orders;
    }

    public void setNb_orders(Integer nb_orders) {
        this.nb_orders = nb_orders;
    }

    public Date getLast_order() {
        return this.last_order;
    }

    public void setLast_order(Date last_order) {
        this.last_order = last_order;
    }

    public String getPrefix_phone() {
        return this.prefix_phone;
    }

    public void setPrefix_phone(String prefix_phone) {
        this.prefix_phone = prefix_phone;
    }

    public String getSiret() {
        return this.siret;
    }

    public void setSiret(String siret) {
        this.siret = siret;
    }

    public String getCode_NAF() {
        return this.code_NAF;
    }

    public void setCode_NAF(String code_NAF) {
        this.code_NAF = code_NAF;
    }

    public String getNum_tva() {
        return this.num_tva;
    }

    public void setNum_tva(String num_tva) {
        this.num_tva = num_tva;
    }

    @XmlTransient
    public List<DebitCustomerInfo> getDebitCustomerInfoList() {
        return this.debitCustomerInfoList;
    }

    public void setDebitCustomerInfoList(List<DebitCustomerInfo> debitCustomerInfoList) {
        this.debitCustomerInfoList = debitCustomerInfoList;
    }

    @XmlTransient
    public List<TicketInfo> getTicketInfoList() {
        return this.ticketInfoList;
    }

    public void setTicketInfoList(List<TicketInfo> ticketInfoList) {
        this.ticketInfoList = ticketInfoList;
    }

    public String getLineString() {
        StringBuilder builder = new StringBuilder("");
        builder.append(this.getName()).append(",").append(this.getNotes()).append(",").append(this.getPhone()).append(",").append(this.getPhone2());
        int indexed = 0;
        for (AddressInfo addresse : this.adresseInfoCollection) {
            if (indexed == 0) {
                builder.append(",").append(addresse.getSociete()).append(",").append(addresse.getCity()).append(",").append(addresse.getAddress()).append(",").append(addresse.getEtage()).append(",").append(addresse.getRemarque()).append(",").append(addresse.getAppartement()).append(",").append(addresse.getInterphone()).append(",").append("" + addresse.getLat()).append(",").append("" + addresse.getLon()).append(",").append(addresse.getZipcode()).append(",").append(addresse.getBatiment()).append(",").append(addresse.getEscalier());
            } else {
                builder.append("\n").append(", , , ,").append(addresse.getSociete()).append(",").append(addresse.getCity()).append(",").append(addresse.getAddress()).append(",").append(addresse.getEtage()).append(",").append(addresse.getRemarque()).append(",").append(addresse.getAppartement()).append(",").append(addresse.getInterphone()).append(",").append("" + addresse.getLat()).append(",").append("" + addresse.getLon()).append(",").append(addresse.getZipcode()).append(",").append(addresse.getBatiment()).append(",").append(addresse.getEscalier());
            }
            ++indexed;
        }
        return builder.toString();
    }

    public void updateCurDebt(Double amount, Date d) {
        this.curdebt = this.curdebt == null ? amount : this.curdebt + amount;
        this.curdate = new Date();
        if (RoundUtils.compare(this.curdebt, 0.0) > 0) {
            if (this.curdate == null) {
                this.curdate = d;
            }
        } else if (RoundUtils.compare(this.curdebt, 0.0) == 0) {
            this.curdebt = null;
            this.curdate = null;
        } else {
            this.curdate = null;
        }
    }

    public String getEnteteCSV() {
        return "nom complet,Remarque du client,tel,mobile,societe,Ville,adresse,etage,Remarque sur l'adresse,appartement ,interphone,latitude,longitude,Code postale,Code d'ent\u00e9e,Batiment,Escalier";
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CustomerInfo)) {
            return false;
        }
        CustomerInfo other = (CustomerInfo)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "CustomerInfo{id=" + this.id + ", taxid=" + this.taxid + ", name=" + this.name + ", phone=" + this.phone + ", card=" + this.card + ", maxdebt=" + this.maxdebt + ", notes=" + this.notes + ", visible=" + this.visible + ", curdate=" + this.curdate + ", curdebt=" + this.curdebt + ", removed=" + this.removed + ", phone2=" + this.phone2 + ", email=" + this.email + ", company=" + this.company + ", discount=" + this.discount + ", responsible=" + this.responsible + ", companyname=" + this.companyname + ", interlocutor=" + this.interlocutor + ", function_interlocutor=" + this.function_interlocutor + ", range=" + this.range + ", type=" + this.type + ", taxcategory=" + this.taxcategory + "}";
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                CustomerInfo customer = new CustomerInfo(dr.getInt(1));
                customer.setName(dr.getString(2));
                customer.setCard(dr.getString(3));
                customer.setNotes(dr.getString(4));
                customer.setMaxdebt(dr.getDouble(5));
                customer.setVisible(dr.getBoolean(6));
                customer.setCurdate(dr.getTimestamp(7));
                customer.setCurdebt(dr.getDouble(8));
                customer.setPhone(dr.getString(9));
                customer.setPhone2(dr.getString(10));
                customer.setEmail(dr.getString(11));
                customer.setCompany(dr.getInt(12));
                customer.setDiscount(dr.getDouble(13));
                customer.setResponsible(dr.getString(14));
                customer.setInterlocutor(dr.getString(15));
                customer.setFunction_interlocutor(dr.getString(16));
                customer.setRange(dr.getString(17));
                customer.setType(dr.getString(18));
                customer.setPrefix_phone(dr.getString(19));
                customer.setSiret(dr.getString(20));
                customer.setCode_NAF(dr.getString(21));
                customer.setNum_tva(dr.getString(22));
                customer.setIsSynchro(dr.getBoolean(23));
                return customer;
            }
        };
    }

    public String printPhone() {
        if (this.prefix_phone != null && !this.prefix_phone.trim().isEmpty() && !this.phone.startsWith(this.prefix_phone)) {
            String phone_text = this.phone;
            if (phone_text.length() == 10 && phone_text.startsWith("0")) {
                phone_text = phone_text.substring(1);
            }
            StringBuilder phoneWithPrefix = new StringBuilder();
            phoneWithPrefix.append(this.prefix_phone);
            phoneWithPrefix.append(phone_text);
            return phoneWithPrefix.toString();
        }
        return this.phone;
    }

    public Object clone() {
        CustomerInfo o = null;
        try {
            o = (CustomerInfo)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            cnse.printStackTrace(System.err);
        }
        return o;
    }
}

