/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.entities;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.IKeyed;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.UserInfo;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.PeopleInfo;
import fr.protactile.procaisse.dao.entities.TicketInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="CAISSE")
@XmlRootElement
@DynamicUpdate
public class CaisseInfo
implements Serializable,
IKeyed {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Column(name="FOND_CAISSE")
    private Double fondCaisse;
    @Size(max=255)
    @Column(name="TOKEN")
    private @Size(max=255) String token;
    @Basic(optional=false)
    @NotNull
    @Column(name="OUVERTE")
    private Boolean ouverte;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATEOPEN")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateOpen;
    @Column(name="DATECLOSE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateClose;
    @Column(name="FOND_CLOSE")
    private Double fondClose;
    @Size(max=100)
    @Column(name="USER_KEENIO_ID")
    private @Size(max=100) String userKeenioId;
    @Basic(optional=false)
    @NotNull
    @Column(name="DISABLED")
    private Boolean disabled;
    @JoinColumn(name="USER_CLOSE", referencedColumnName="ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private PeopleInfo userClose;
    @JoinColumn(name="USER_OPEN", referencedColumnName="ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private PeopleInfo userOpen;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="caisse")
    private List<TicketInfo> ticketInfoList;
    @Basic(optional=false)
    @NotNull
    @Column(name="blocked")
    private Boolean blocked;
    @Basic(optional=false)
    @NotNull
    @Column(name="active")
    private Boolean active;
    @Transient
    private String addressMac;
    @Transient
    private UserInfo m_user_open;
    @Transient
    private UserInfo m_user_close;

    public CaisseInfo() {
    }

    public CaisseInfo(Integer id) {
        this.id = id;
    }

    public CaisseInfo(Integer id, Double fondCaisse, Boolean ouverte, Date dateopen, Boolean disabled) {
        this.id = id;
        this.fondCaisse = fondCaisse;
        this.ouverte = ouverte;
        this.dateOpen = dateopen;
        this.disabled = disabled;
    }

    public CaisseInfo(Integer id, Double fond_caisse, Boolean ouverte, Date dateOpen, String token, Date dateClose, String user_open_id, String user_close_id, double fond_close) {
        this.id = id;
        this.fondCaisse = fond_caisse;
        this.ouverte = ouverte;
        this.dateOpen = dateOpen;
        this.addressMac = token;
        this.token = token;
        this.dateClose = dateClose;
        this.userOpen = new PeopleInfo(user_open_id);
        this.userClose = new PeopleInfo(user_close_id);
        this.fondClose = fond_close;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Double getFondCaisse() {
        return this.fondCaisse;
    }

    public void setFondCaisse(Double fondCaisse) {
        this.fondCaisse = fondCaisse;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean isOuverte() {
        return this.ouverte;
    }

    public void setOuverte(Boolean ouverte) {
        this.ouverte = ouverte;
    }

    public Date getDateOpen() {
        return this.dateOpen;
    }

    public void setDateOpen(Date dateopen) {
        this.dateOpen = dateopen;
    }

    public Date getDateClose() {
        return this.dateClose;
    }

    public void setDateClose(Date dateclose) {
        this.dateClose = dateclose;
    }

    public Double getFondClose() {
        return this.fondClose;
    }

    public void setFondClose(Double fondClose) {
        this.fondClose = fondClose;
    }

    public String getUserKeenioId() {
        return this.userKeenioId;
    }

    public void setUserKeenioId(String userKeenioId) {
        this.userKeenioId = userKeenioId;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public PeopleInfo getUserClose() {
        return this.userClose;
    }

    public void setUserClose(PeopleInfo userClose) {
        this.userClose = userClose;
    }

    public PeopleInfo getUserOpen() {
        return this.userOpen;
    }

    public void setUserOpen(PeopleInfo userOpen) {
        this.userOpen = userOpen;
    }

    public UserInfo getUser_open() {
        return this.m_user_open;
    }

    public void setUser_open(UserInfo user_open) {
        this.m_user_open = user_open;
        this.userOpen = user_open != null ? new PeopleInfo(user_open.getId()) : null;
    }

    public UserInfo getUser_close() {
        return this.m_user_close;
    }

    public void setUser_close(UserInfo user_close) {
        this.m_user_close = user_close;
        this.userClose = user_close != null ? new PeopleInfo(user_close.getId()) : null;
    }

    public String getUser_open_id() {
        if (this.userOpen != null) {
            return this.userOpen.getId();
        }
        return null;
    }

    public String getUser_close_id() {
        if (this.userClose != null) {
            return this.userClose.getId();
        }
        return null;
    }

    public String getAddressMac() {
        return this.token;
    }

    public void setAddressMac(String addressMac) {
        this.addressMac = addressMac;
    }

    @XmlTransient
    public List<TicketInfo> getTicketInfoList() {
        return this.ticketInfoList;
    }

    public void setTicketInfoList(List<TicketInfo> ticketInfoList) {
        this.ticketInfoList = ticketInfoList;
    }

    public Boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    @Override
    public Object getKey() {
        return this.id;
    }

    public String printFondCaisse() {
        return Formats.CURRENCY.formatValue(this.getFondCaisse());
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CaisseInfo)) {
            return false;
        }
        CaisseInfo other = (CaisseInfo)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "fr.protactile.procaisse.dao.entities.CaisseInfo[ id=" + this.id + " ]";
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                CaisseInfo mCaisseInfo = new CaisseInfo(dr.getInt(1), dr.getDouble(2), dr.getBoolean(3), dr.getTimestamp(4), dr.getString(5), dr.getTimestamp(6), dr.getString(7), dr.getString(8), dr.getDouble(9));
                return mCaisseInfo;
            }
        };
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }
}

