/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.entities;

import com.openbravo.pos.util.DateEncryptor;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="BlockingCheck")
@XmlRootElement
public class BlockingCheck
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private int id;
    @Column(name="BLOCKING_DATE_CRYPTED")
    private String blockingDateCrypted;
    @Column(name="BLOCKED")
    private boolean blocked;
    @Column(name="TO_BE_BLOCKED")
    private boolean toBeBlocked;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getBlockingDateCrypted() {
        return this.blockingDateCrypted;
    }

    public void setBlockingDateCrypted(String blockingDateCrypted) {
        this.blockingDateCrypted = blockingDateCrypted;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isToBeBlocked() {
        return this.toBeBlocked;
    }

    public void setToBeBlocked(boolean toBeBlocked) {
        this.toBeBlocked = toBeBlocked;
    }

    public String toString() {
        return "BlockingCheck{id=" + this.id + ", blockingDateCrypted=" + this.blockingDateCrypted + ", blocked=" + this.blocked + ", toBeBlocked=" + this.toBeBlocked + "}";
    }

    @XmlTransient
    public int getRemainsDays() {
        int remainsDays = 0;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date blockingDate = this.blockingDateCrypted != null && !this.blockingDateCrypted.isEmpty() ? dateFormat.parse(DateEncryptor.decryptDate(this.blockingDateCrypted)) : new Date();
            Date dateNow = new Date();
            dateNow.setHours(0);
            dateNow.setMinutes(0);
            dateNow.setSeconds(0);
            blockingDate.setHours(0);
            blockingDate.setMinutes(0);
            blockingDate.setSeconds(0);
            System.out.println("blockingDate : " + blockingDate);
            System.out.println("dateNow : " + dateNow);
            long diff = blockingDate.getTime() - dateNow.getTime();
            remainsDays = (int)(diff / 86400000L);
        }
        catch (Exception ex) {
            Logger.getLogger(BlockingCheck.class.getName()).log(Level.SEVERE, null, ex);
        }
        return remainsDays;
    }
}

