/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.entities;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.TicketInfo;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="ADRESSECLIENT")
@XmlRootElement
public class AddressInfo
implements Serializable {
    @OneToMany(mappedBy="address")
    private List<TicketInfo> ticketInfoList;
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="ADDRESS")
    private @NotNull @Size(min=1, max=255) String address;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="ZIPCODE")
    private @NotNull @Size(min=1, max=255) String zipcode;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="CITY")
    private @NotNull @Size(min=1, max=255) String city;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="ENTRYCODE")
    private @NotNull @Size(min=1, max=255) String entrycode;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="INTERPHONE")
    private @NotNull @Size(min=1, max=255) String interphone;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="BATIMENT")
    private @NotNull @Size(min=1, max=255) String batiment;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="ESCALIER")
    private @NotNull @Size(min=1, max=255) String escalier;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="ETAGE")
    private @NotNull @Size(min=1, max=255) String etage;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="APPARTEMENT")
    private @NotNull @Size(min=1, max=255) String appartement;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="SOCIETE")
    private @NotNull @Size(min=1, max=255) String societe;
    @Basic(optional=false)
    @NotNull
    @Column(name="LAT")
    private double lat;
    @Basic(optional=false)
    @NotNull
    @Column(name="LON")
    private double lon;
    @Size(max=255)
    @Column(name="REMARQUE")
    private @Size(max=255) String remarque;
    @JoinColumn(name="IDCUSTOMER", referencedColumnName="ID")
    @ManyToOne(optional=false)
    private CustomerInfo customer;
    @Column(name="ISSYNCHROADDRESS")
    private boolean isSynchro;

    public AddressInfo() {
        this.isSynchro = false;
    }

    public AddressInfo(Integer id) {
        this.id = id;
    }

    public AddressInfo(String address) {
        this.address = address;
    }

    public AddressInfo(Integer id, String address, String zipcode, String city, String entrycode, String interphone, String batiment, String escalier, String etage, String appartement, String societe, double lat, double lon) {
        this.id = id;
        this.address = address;
        this.zipcode = zipcode;
        this.city = city;
        this.entrycode = entrycode;
        this.interphone = interphone;
        this.batiment = batiment;
        this.escalier = escalier;
        this.etage = etage;
        this.appartement = appartement;
        this.societe = societe;
        this.lat = lat;
        this.lon = lon;
    }

    public AddressInfo(String address, String zipCode, String city, String entryCode, String interphone, String batiment, String escalier, String etage, String appartement, String societe, int idCustomer, double lat, double lon, String remarque) {
        this.address = address;
        this.zipcode = zipCode;
        this.city = city;
        this.entrycode = entryCode;
        this.interphone = interphone;
        this.batiment = batiment;
        this.escalier = escalier;
        this.etage = etage;
        this.appartement = appartement;
        this.societe = societe;
        this.remarque = remarque;
        this.customer = new CustomerInfo(idCustomer);
        this.lat = lat;
        this.lon = lon;
    }

    public AddressInfo(String address, String zipCode, String city, String entryCode, String interphone, String batiment, String etage, String appartement, String remarque) {
        this.address = address;
        this.zipcode = zipCode;
        this.city = city;
        this.entrycode = entryCode;
        this.interphone = interphone;
        this.batiment = batiment;
        this.etage = etage;
        this.appartement = appartement;
        this.remarque = remarque;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getEntrycode() {
        return this.entrycode;
    }

    public void setEntrycode(String entrycode) {
        this.entrycode = entrycode;
    }

    public String getInterphone() {
        return this.interphone;
    }

    public void setInterphone(String interphone) {
        this.interphone = interphone;
    }

    public String getBatiment() {
        return this.batiment;
    }

    public void setBatiment(String batiment) {
        this.batiment = batiment;
    }

    public String getEscalier() {
        return this.escalier;
    }

    public void setEscalier(String escalier) {
        this.escalier = escalier;
    }

    public String getEtage() {
        return this.etage;
    }

    public void setEtage(String etage) {
        this.etage = etage;
    }

    public String getAppartement() {
        return this.appartement;
    }

    public void setAppartement(String appartement) {
        this.appartement = appartement;
    }

    public String getSociete() {
        return this.societe;
    }

    public void setSociete(String societe) {
        this.societe = societe;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public String getRemarque() {
        return this.remarque;
    }

    public void setRemarque(String remarque) {
        this.remarque = remarque;
    }

    public CustomerInfo getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerInfo c) {
        this.customer = c;
    }

    public void onBeforeSave() {
        if (this.address == null) {
            this.address = "";
        }
        if (this.zipcode == null) {
            this.zipcode = "";
        }
        if (this.appartement == null) {
            this.appartement = "";
        }
        if (this.city == null) {
            this.city = "";
        }
        if (this.batiment == null) {
            this.batiment = "";
        }
        if (this.escalier == null) {
            this.escalier = "";
        }
        if (this.etage == null) {
            this.etage = "";
        }
        if (this.interphone == null) {
            this.interphone = "";
        }
        if (this.entrycode == null) {
            this.entrycode = "";
        }
        if (this.societe == null) {
            this.societe = "";
        }
    }

    public void setIdCustomer(int id) {
        if (this.customer == null) {
            this.customer = new CustomerInfo(id);
        } else {
            this.customer.setId(id);
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AddressInfo)) {
            return false;
        }
        AddressInfo other = (AddressInfo)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "AddressInfo{id=" + this.id + ", address=" + this.address + ", zipcode=" + this.zipcode + ", city=" + this.city + ", entrycode=" + this.entrycode + ", interphone=" + this.interphone + ", batiment=" + this.batiment + ", escalier=" + this.escalier + ", etage=" + this.etage + ", appartement=" + this.appartement + ", societe=" + this.societe + ", lat=" + this.lat + ", lon=" + this.lon + ", remarque=" + this.remarque + "}";
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                AddressInfo addr = new AddressInfo(dr.getString(2), dr.getString(3), dr.getString(4), dr.getString(5), dr.getString(6), dr.getString(7), dr.getString(8), dr.getString(9), dr.getString(10), dr.getString(11), dr.getInt(12), dr.getDouble(13), dr.getDouble(14), dr.getString(15));
                addr.setId(dr.getInt(1));
                return addr;
            }
        };
    }

    @XmlTransient
    public List<TicketInfo> getTicketInfoList() {
        return this.ticketInfoList;
    }

    public void setTicketInfoList(List<TicketInfo> ticketInfoList) {
        this.ticketInfoList = ticketInfoList;
    }

    public Boolean getIsSynchro() {
        return this.isSynchro;
    }

    public void setIsSynchro(Boolean isSynchro) {
        this.isSynchro = isSynchro;
    }
}

