/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.config;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateUtils {
    public static SessionFactory sessionFactory;
    private static final String DB_URL_PROPERTY = "hibernate.connection.url";
    private static final String DB_DRIVER_CLASS_NAME = "hibernate.connection.driver_class";
    public static final String DERBY_DRIVER_EMBEDDED = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DERBY_DRIVER_NETWORK = "org.apache.derby.jdbc.ClientDriver";

    public static void init(AppProperties props) {
        String url = props.getProperty("db.URL");
        String clazz = props.getProperty("db.driver");
        if (StringUtils.isNotEmpty(url) && StringUtils.isNotEmpty(clazz)) {
            HibernateUtils.configureDataSource(url, clazz);
        }
    }

    private static void configureDataSource(String dbUrl, String clazz) {
        Configuration config = new Configuration();
        config = config.configure();
        if (dbUrl != null && !dbUrl.isEmpty()) {
            config.setProperty(DB_URL_PROPERTY, dbUrl);
            config.setProperty(DB_DRIVER_CLASS_NAME, clazz);
        }
        try {
            sessionFactory = config.buildSessionFactory();
        }
        catch (Throwable ex) {
            ExceptionInInitializerError mError = new ExceptionInInitializerError(ex);
            LogToFile.log("severe", mError.getMessage(), (Exception)ex);
            throw mError;
        }
    }

    private static void build() {
        if (StringUtils.isNotEmpty(AppLocal.db_url) && StringUtils.isNotEmpty(AppLocal.DB_CLASSNAME)) {
            HibernateUtils.configureDataSource(AppLocal.db_url, AppLocal.DB_CLASSNAME);
        }
    }

    public static Session getSession() throws HibernateException {
        if (sessionFactory == null) {
            HibernateUtils.build();
        }
        return sessionFactory.openSession();
    }
}

