/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.config;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.HibernateUtils;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public abstract class DaoConfig<T> {
    protected static Session s = HibernateUtils.getSession();
    protected static SessionFactory sessionFactory = HibernateUtils.sessionFactory;

    protected abstract Class<T> classType();

    protected void openSession() {
        if (s != null && !s.isOpen()) {
            s = HibernateUtils.getSession();
        }
    }

    public Session getCurrentSession() {
        if (!s.isOpen()) {
            this.openSession();
        }
        return s;
    }

    public void close() {
        if (s != null) {
            s.close();
        }
    }

    public List<T> list() {
        if (!s.isOpen()) {
            this.openSession();
        }
        s.clear();
        Query query = s.createQuery("from " + this.classType().getName());
        return query.list();
    }

    public T find(Object _id) {
        if (!s.isOpen()) {
            this.openSession();
        }
        s.clear();
        return (T)s.find(this.classType(), _id);
    }

    public void save(Object o) {
        if (!s.isOpen()) {
            this.openSession();
        }
        if (o != null) {
            s.save(o);
        }
    }

    public void update(Object o) {
        if (!s.isOpen()) {
            this.openSession();
        }
        if (o != null) {
            s.clear();
            s.update(o);
        }
    }

    public void remove(Object o) {
        block4: {
            if (!s.isOpen()) {
                this.openSession();
            }
            if (o != null) {
                Transaction tx = null;
                try {
                    s.clear();
                    tx = s.beginTransaction();
                    s.remove(o);
                    tx.commit();
                }
                catch (Exception e) {
                    LogToFile.log("severe", e.getMessage(), e);
                    if (tx == null) break block4;
                    tx.rollback();
                }
            }
        }
    }

    public void removeById(Object _id) {
        T o = this.find(_id);
        if (o != null) {
            this.remove(o);
        }
    }

    public void persist(Object o) {
        if (!s.isOpen()) {
            this.openSession();
        }
        if (o != null) {
            s.persist(o);
        }
    }

    public T merge(Object o) {
        if (!s.isOpen()) {
            this.openSession();
        }
        if (o != null) {
            return (T)s.merge(o);
        }
        return null;
    }

    public void flush() {
        if (s != null) {
            s.flush();
        }
    }

    public void clear() {
        if (s != null) {
            s.clear();
        }
    }

    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }
}

