/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.cache;

import java.util.ArrayList;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.map.LRUMap;

public class StorageInMemoryCache<K, T> {
    private long timeToLive;
    private LRUMap crunchifyCacheMap;

    public StorageInMemoryCache(long crunchifyTimeToLive, final long crunchifyTimerInterval, int maxItems) {
        this.timeToLive = crunchifyTimeToLive * 1000L;
        this.crunchifyCacheMap = new LRUMap(maxItems);
        if (this.timeToLive > 0L && crunchifyTimerInterval > 0L) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(crunchifyTimerInterval * 1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        StorageInMemoryCache.this.cleanup();
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, T value) {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            this.crunchifyCacheMap.put(key, (Object)new StorageCacheObject(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(K key) {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            StorageCacheObject c = (StorageCacheObject)this.crunchifyCacheMap.get(key);
            if (c == null) {
                return null;
            }
            c.lastAccessed = System.currentTimeMillis();
            return c.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            return this.crunchifyCacheMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            this.crunchifyCacheMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            return this.crunchifyCacheMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        long now = System.currentTimeMillis();
        ArrayList<Object> deleteKey = null;
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            OrderedMapIterator orderedMapIterator = this.crunchifyCacheMap.mapIterator();
            deleteKey = new ArrayList<Object>(this.crunchifyCacheMap.size() / 2 + 1);
            Object key = null;
            StorageCacheObject c = null;
            while (orderedMapIterator.hasNext()) {
                key = orderedMapIterator.next();
                c = (StorageCacheObject)orderedMapIterator.getValue();
                if (c == null || now <= this.timeToLive + c.lastAccessed) continue;
                deleteKey.add(key);
            }
        }
        for (Object e : deleteKey) {
            LRUMap lRUMap2 = this.crunchifyCacheMap;
            synchronized (lRUMap2) {
                this.crunchifyCacheMap.remove(e);
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceClean() {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            this.crunchifyCacheMap.clear();
        }
    }

    protected class StorageCacheObject {
        public long lastAccessed = System.currentTimeMillis();
        public T value;

        protected StorageCacheObject(T value) {
            this.value = value;
        }

        public String toString() {
            return "StorageCacheObject{lastAccessed=" + this.lastAccessed + ", value=" + this.value + "}";
        }
    }
}

