/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.cache;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TaxInfo;
import fr.protactile.procaisse.cache.SharedMemoryCache;

public final class CacheFinder {
    public static ProductInfoExt findProductInfoById(SharedMemoryCache sharedMemoryCache, DataLogicSales dlSales, Integer productId) throws BasicException {
        ProductInfoExt productInfoExt = null;
        String keyCacheProduct = SharedMemoryCache.makeKey("PRODUCTINFO_", (Object)productId);
        if (sharedMemoryCache.containsKey(keyCacheProduct)) {
            productInfoExt = (ProductInfoExt)sharedMemoryCache.get(keyCacheProduct);
        } else {
            productInfoExt = dlSales.getProductInfoById(productId);
            sharedMemoryCache.put(keyCacheProduct, productInfoExt);
        }
        return productInfoExt;
    }

    public static CategoryInfo findCategoryInfoById(SharedMemoryCache sharedMemoryCache, DataLogicSales dlSales, Integer categoryId) throws BasicException {
        CategoryInfo categoryInfo = null;
        String keyCacheCategory = SharedMemoryCache.makeKey("CATEGORYINFO_", (Object)categoryId);
        if (sharedMemoryCache.containsKey(keyCacheCategory)) {
            categoryInfo = (CategoryInfo)sharedMemoryCache.get(keyCacheCategory);
        } else {
            categoryInfo = dlSales.getCategoryInfo(String.valueOf(categoryId));
            sharedMemoryCache.put(keyCacheCategory, categoryInfo);
        }
        return categoryInfo;
    }

    public static TaxInfo findTaxInfoById(SharedMemoryCache sharedMemoryCache, DataLogicSales dlSales, String taxId) throws BasicException {
        TaxInfo tax = null;
        String keyCacheTax = SharedMemoryCache.makeKey("TAXINFO_", (Object)taxId);
        if (sharedMemoryCache.containsKey(keyCacheTax)) {
            tax = (TaxInfo)sharedMemoryCache.get(keyCacheTax);
        } else {
            tax = dlSales.getTaxById(taxId);
            sharedMemoryCache.put(keyCacheTax, tax);
        }
        return tax;
    }

    public static SupplementItemInfo findOptionById(SharedMemoryCache sharedMemoryCache, DataLogicItems dlItems, Integer optionId) throws BasicException {
        SupplementItemInfo option = null;
        String keyCacheOption = SharedMemoryCache.makeKey("OPTIONINFO_", (Object)optionId);
        if (sharedMemoryCache.containsKey(keyCacheOption)) {
            option = (SupplementItemInfo)sharedMemoryCache.get(keyCacheOption);
        } else {
            option = dlItems.getSuppelementById(optionId);
            sharedMemoryCache.put(keyCacheOption, option);
        }
        return option;
    }

    public static SupplementProduct findSupplementProductById(SharedMemoryCache sharedMemoryCache, DataLogicItems dlItems, Integer groupOptionId) throws BasicException {
        SupplementProduct gourpOption = null;
        String keyCacheSupplementProduct = SharedMemoryCache.makeKey("SUPPLEMENTPRODUCTINFO_", (Object)groupOptionId);
        if (sharedMemoryCache.containsKey(keyCacheSupplementProduct)) {
            gourpOption = (SupplementProduct)sharedMemoryCache.get(keyCacheSupplementProduct);
        } else {
            gourpOption = dlItems.getSupplementByID(groupOptionId);
            sharedMemoryCache.put(keyCacheSupplementProduct, gourpOption);
        }
        return gourpOption;
    }
}

