/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.biborne_video_player;

import fr.protactile.procaisse.biborne_video_player.ScreenUtil;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class BiborneVideoPlayerController {
    private static final String HOST = "127.0.0.1";
    private static final int PORT = 9090;
    private static final String BIBORNE_VIDEO_PLAYER = "Biborne Video Player.exe";
    private static final int MAX_CONNECTION_ATTEMPTS = 10;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ScheduledExecutorService retryExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ExecutorService listenerExecutor = Executors.newSingleThreadExecutor();
    private final Consumer<String> messageHandler;
    private final Rectangle videoBounds;
    private volatile boolean isConnecting = false;
    private volatile boolean isShuttingDown = false;
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private boolean hasCheckedIfAlive;
    private volatile String command;
    private String videoFile;

    public BiborneVideoPlayerController() {
        this(ScreenUtil.getPrimaryScreenBounds(), null);
    }

    public BiborneVideoPlayerController(Rectangle videoBounds) {
        this(videoBounds, null);
    }

    public BiborneVideoPlayerController(Consumer<String> messageHandler) {
        this(ScreenUtil.getPrimaryScreenBounds(), messageHandler);
    }

    public BiborneVideoPlayerController(Rectangle videoBounds, Consumer<String> messageHandler) {
        this.videoBounds = videoBounds;
        this.messageHandler = messageHandler;
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    public void play(String filePath) {
        this.videoFile = filePath;
        this.sendCommandOverSocket("play " + filePath);
    }

    public void stop() {
        this.sendCommandOverSocket("stop");
    }

    public void restart() {
        this.sendCommandOverSocket("restart");
    }

    public void closeApp() {
        this.sendCommandOverSocket("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAliveCheck() {
        try {
            BiborneVideoPlayerController biborneVideoPlayerController = this;
            synchronized (biborneVideoPlayerController) {
                if (this.socket != null) {
                    this.socket.setSoTimeout(500);
                    if (this.writer != null) {
                        this.writer.write("alive?\n");
                        this.writer.flush();
                    }
                } else {
                    System.out.println("[BiborneVideoPlayerController] sendAliveCheck, socket is null, calling reconnect");
                    this.reconnect();
                }
            }
        }
        catch (IOException e) {
            System.err.println("[BiborneVideoPlayerController] Socket error while sending alive check: " + e.getMessage());
            this.reconnect();
        }
    }

    private void sendCommandOverSocket(String command) {
        if (this.isShuttingDown) {
            return;
        }
        System.out.println("[BiborneVideoPlayerController] sendCommandOverSocket, hasCheckedIfAlive:" + this.hasCheckedIfAlive);
        if (!this.hasCheckedIfAlive) {
            this.command = command;
            this.sendAliveCheck();
            return;
        }
        this.executor.submit(() -> {
            boolean commandSent = false;
            try {
                BiborneVideoPlayerController biborneVideoPlayerController = this;
                synchronized (biborneVideoPlayerController) {
                    System.out.println("[BiborneVideoPlayerController] sendCommandOverSocket, command: " + command + ", socket:" + this.socket);
                    if (this.socket != null && this.writer != null) {
                        this.writer.write(command + "\n");
                        this.writer.flush();
                        System.out.println("[BiborneVideoPlayerController] Command sent!");
                        commandSent = true;
                    }
                }
            }
            catch (IOException e) {
                System.err.println("[BiborneVideoPlayerController] Socket error while sending command: " + e.getMessage());
            }
            if (!commandSent && (command.startsWith("play") || command.startsWith("restart"))) {
                System.out.println("[BiborneVideoPlayerController] sendCommandOverSocket, !commandSent, reconnect");
                this.reconnect();
            }
        });
    }

    private synchronized boolean connect() {
        try {
            this.socket = new Socket(HOST, 9090);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            return true;
        }
        catch (IOException e) {
            System.err.println("[BiborneVideoPlayerController] connect error: " + e.getMessage());
            this.closeConnection();
            return false;
        }
    }

    private void connectWhenServerIsReady() {
        this.isConnecting = true;
        this.connectWhenServerIsReady(0);
    }

    private void connectWhenServerIsReady(int attempt) {
        if (attempt >= 10) {
            System.err.println("[BiborneVideoPlayerController] Failed to connect to external video player after 10 attempts.");
            this.isConnecting = false;
            return;
        }
        boolean isConnected = this.connect();
        if (isConnected) {
            this.isConnecting = false;
            System.out.println("[BiborneVideoPlayerController] Connected to external video player after " + (attempt + 1) + " attempt(s).");
            this.startListeningForMessages();
            return;
        }
        this.retryExecutor.schedule(() -> this.connectWhenServerIsReady(attempt + 1), 500L, TimeUnit.MILLISECONDS);
    }

    private void startListeningForMessages() {
        this.listenerExecutor.submit(() -> {
            try {
                String line;
                if (this.reader == null) {
                    System.err.println("[BiborneVideoPlayerController] Reader is null \u2014 cannot listen for messages.");
                    return;
                }
                while ((line = this.reader.readLine()) != null) {
                    String message = line.trim();
                    System.err.println("[BiborneVideoPlayerController] Message received: " + message);
                    if ("alive!".equals(message)) {
                        this.hasCheckedIfAlive = true;
                        this.socket.setSoTimeout(3000);
                        System.err.println("[BiborneVideoPlayerController] Good, sending command now");
                        this.sendCommandOverSocket(this.command);
                        continue;
                    }
                    this.hasCheckedIfAlive = false;
                    this.socket.setSoTimeout(0);
                    System.err.println("[BiborneVideoPlayerController] messageHandler.accept(message)");
                    if (this.messageHandler == null) continue;
                    this.messageHandler.accept(message);
                }
                System.err.println("[BiborneVideoPlayerController] Socket closed by remote host.");
            }
            catch (SocketTimeoutException e) {
                System.err.println("[BiborneVideoPlayerController] Read timeout. Closing socket:" + e.getMessage());
            }
            catch (IOException e) {
                System.err.println("[BiborneVideoPlayerController] Error reading from socket: " + e.getMessage());
            }
            finally {
                System.err.println("[BiborneVideoPlayerController] startListeningForMessages, close connection in finally");
                this.closeConnection();
                this.play(this.videoFile);
            }
        });
    }

    private synchronized void closeConnection() {
        System.out.println("[BiborneVideoPlayerController] closeConnection");
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writer = null;
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader = null;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
    }

    private void reconnect() {
        if (this.isShuttingDown) {
            return;
        }
        System.out.println("[BiborneVideoPlayerController] reconnect");
        this.hasCheckedIfAlive = false;
        if (!this.isConnecting) {
            this.closeConnection();
            this.killBiborneVideoPlayer();
            this.launchBiborneVideoPlayer(this.videoFile);
            this.connectWhenServerIsReady();
        }
    }

    private void killBiborneVideoPlayer() {
        try {
            System.out.println("[BiborneVideoPlayerController] Before killing Biborne Video Player");
            String killTaskCommand = "taskkill /F /IM \"Biborne Video Player.exe\"";
            Process process = Runtime.getRuntime().exec(killTaskCommand);
            process.waitFor();
            System.out.println("[BiborneVideoPlayerController] After killing Biborne Video Player");
        }
        catch (IOException | InterruptedException e) {
            System.err.println("[BiborneVideoPlayerController] Error killing existing video player process: " + e.getMessage());
        }
    }

    private void launchBiborneVideoPlayer(String videoFile) {
        try {
            System.out.println("[BiborneVideoPlayerController] Before launching Biborne Video Player");
            ProcessBuilder processBuilder = new ProcessBuilder(BIBORNE_VIDEO_PLAYER, "--server", "socket", "--port", String.valueOf(9090), "--video", videoFile, "--left", String.valueOf(this.videoBounds.x), "--top", String.valueOf(this.videoBounds.y), "--width", String.valueOf(this.videoBounds.width), "--height", String.valueOf(this.videoBounds.height), "--verbose");
            processBuilder.start();
            System.out.println("[BiborneVideoPlayerController] After launching Biborne Video Player");
        }
        catch (IOException e) {
            System.err.println("[BiborneVideoPlayerController] Error launching Biborne Video Player: " + e.getMessage());
        }
    }

    public void shutdown() {
        this.isShuttingDown = true;
        System.out.println("[BiborneVideoPlayerController] shutdown");
        this.closeConnection();
        this.executor.shutdown();
        this.retryExecutor.shutdown();
        this.listenerExecutor.shutdown();
        try {
            if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
            if (!this.retryExecutor.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.retryExecutor.shutdownNow();
            }
            if (!this.listenerExecutor.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.listenerExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            this.retryExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

