/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.norm.beans;

import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.NumericUtils;
import java.util.Date;

public class JustificatifPayment {
    private int id;
    private int num_doc;
    private Date timestampGDH;
    private double total;
    private String ticket;
    private String signature;
    private int ref_ticket;
    private boolean round_amount;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getNum_doc() {
        return this.num_doc;
    }

    public void setNum_doc(int num_doc) {
        this.num_doc = num_doc;
    }

    public Date getTimestampGDH() {
        return this.timestampGDH;
    }

    public void setTimestampGDH(Date timestampGDH) {
        this.timestampGDH = timestampGDH;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public int getRef_ticket() {
        return this.ref_ticket;
    }

    public void setRef_ticket(int ref_ticket) {
        this.ref_ticket = ref_ticket;
    }

    public static SerializerRead getSerializerRead() {
        return dr -> {
            JustificatifPayment mJustificatifPayment = new JustificatifPayment();
            mJustificatifPayment.id = dr.getInt(1);
            mJustificatifPayment.num_doc = dr.getInt(2);
            mJustificatifPayment.ticket = dr.getString(3);
            mJustificatifPayment.timestampGDH = dr.getTimestamp(4);
            mJustificatifPayment.total = dr.getDouble(5);
            mJustificatifPayment.signature = dr.getString(6);
            mJustificatifPayment.ref_ticket = dr.getInt(7);
            mJustificatifPayment.round_amount = dr.getBoolean(8);
            return mJustificatifPayment;
        };
    }

    public String getEntete() {
        return "id, total, date, num_doc, signature, ref_ticket, round_amount";
    }

    public String toString() {
        return this.id + "," + this.total + "," + DateUtils.SDF_FULL_DATE_TIME.format(this.timestampGDH) + "," + this.num_doc + "," + this.signature + "," + this.ref_ticket + "," + this.round_amount;
    }

    public String getEmprintWithoutSignature() {
        StringBuilder justificatifPaymentEmprinte = new StringBuilder();
        justificatifPaymentEmprinte.append(this.id);
        justificatifPaymentEmprinte.append(",").append((long)this.getAmount(this.total));
        justificatifPaymentEmprinte.append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(this.timestampGDH));
        if (this.ref_ticket != 0) {
            justificatifPaymentEmprinte.append(",").append(this.ref_ticket);
        } else {
            justificatifPaymentEmprinte.append(",").append(this.num_doc);
        }
        return justificatifPaymentEmprinte.toString();
    }

    public String getMsgIntegrityError() {
        return "Justificatif paiement { " + this.toString() + " }";
    }

    private double getAmount(double amount_value) {
        return this.round_amount ? NumericUtils.round(NumericUtils.round(amount_value) * 100.0) : NumericUtils.round(amount_value) * 100.0;
    }
}

