/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.norm.beans;

import com.openbravo.data.loader.SerializerRead;
import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.SignatureUtils;
import com.openbravo.pos.util.Signed;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GrandTotalPeriode
extends Signed {
    private String id;
    private double cumul;
    private double cumulPerpetual;
    private double tva5;
    private double tva10;
    private double tva20;
    private String signature;
    private String typePeriode;
    private Date timestampGDH;
    private double cumulPerpetualReel;
    private double cash_total;
    private double cb_total;
    private double tr_total;
    private double debit_total;
    private double credit_employee_total;
    private double loyalty_card;
    private double cashdro_total;
    private double cash_glory_total;
    private double virement_total;
    private double cheque_total;
    private double avoir_decaisse_total;
    private double avoir_encaisse_total;
    private double tva_5_5_ht;
    private double tva_10_ht;
    private double tva_20_ht;
    private int number_orders;
    private double number_products_sold;
    private double turnover_canceled;
    private double total_orders_at_spot;
    private double total_orders_take_away;
    private double total_orders_delivery;
    private double total_orders_uber;
    private double total_orders_delivero;
    private int number_cb;
    private int number_tr;
    private double total_discount;
    private double total_discount_lines;
    private boolean insert_ficancial_infos;
    private double total_orders_just_eat;
    private double tva0;
    private double tva_0_ht;
    private double total_orders_drive;
    private double tva_7_7;
    private double tva_2_5;
    private double tva_2_1;
    private double tva_8_5;
    private double tva_7_7_ht;
    private double tva_2_5_ht;
    private double tva_2_1_ht;
    private double tva_8_5_ht;
    private double twint_total;
    private double total_orders_smood;
    private double cheque_vacances_total;
    private boolean before_perpetual_reset;
    private List<GrandTotalPeriode> grandTotauxJournalier;
    private boolean isSynchronized;
    private boolean round_amount;
    private boolean is_ZSynchro;
    private SignatureUtils signatureUtils;
    private double turnover_platform;
    private int number_orders_platform;
    private double cash_logy_total;
    private double total_orders_dishop;
    private double stripe_total;
    private double total_orders_deliveroo;
    private double tva_6;
    private double tva_12;
    private double tva_21;
    private double tva_6_ht;
    private double tva_12_ht;
    private double tva_21_ht;
    private double turnover_ubereat;
    private double tva_8_1;
    private double tva_2_6;
    private double tva_8_1_ht;
    private double tva_2_6_ht;
    private double tps;
    private double tvq;
    private double credit_card_total;
    private double debit_card_total;
    private double total_ht_taxable;
    private double total_ht_no_taxable;
    private List<GroupedTax> gtpTaxes;
    private double tva_5_5_ubereats;
    private double tva_10_ubereats;
    private double total_ht_orders_at_spot;
    private double total_ht_orders_take_away;
    private double total_ht_orders_delivery;
    private double total_ht_orders_drive;
    private double number_orders_at_spot;
    private double number_orders_take_away;
    private double number_orders_delivery;
    private double number_orders_drive;
    private double carte_tr_total;
    private double bank_transfer_total;
    private int number_carte_tr;

    public String getTypePeriode() {
        return this.typePeriode;
    }

    public void setTypePeriode(String typePeriode) {
        this.typePeriode = typePeriode;
    }

    public Date getTimestampGDH() {
        return this.timestampGDH;
    }

    public void setTimestampGDH(Date timestampGDH) {
        this.timestampGDH = timestampGDH;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public GrandTotalPeriode(String id, double cumul, double cumulPerpetual, double tva5, double tva10, double tva20, String signature, String typePeriode, Date timestampGDH, double cumulPerpetualReel) {
        this.id = id;
        this.cumul = cumul;
        this.cumulPerpetual = cumulPerpetual;
        this.tva5 = tva5;
        this.tva10 = tva10;
        this.tva20 = tva20;
        this.signature = signature;
        this.typePeriode = typePeriode;
        this.timestampGDH = timestampGDH;
        this.cumulPerpetualReel = cumulPerpetualReel;
        this.signatureUtils = new SignatureUtils();
    }

    public GrandTotalPeriode() {
        this.signatureUtils = new SignatureUtils();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getCumul() {
        return this.cumul;
    }

    public void setCumul(double cumul) {
        this.cumul = cumul;
    }

    public double getCumulPerpetual() {
        return this.cumulPerpetual;
    }

    public void setCumulPerpetual(double cumulPerpetual) {
        this.cumulPerpetual = cumulPerpetual;
    }

    public double getTva5() {
        return this.tva5;
    }

    public void setTva5(double tva5) {
        this.tva5 = tva5;
    }

    public double getTva10() {
        return this.tva10;
    }

    public void setTva10(double tva10) {
        this.tva10 = tva10;
    }

    public double getTva20() {
        return this.tva20;
    }

    public void setTva20(double tva20) {
        this.tva20 = tva20;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.id);
        builder.append(",");
        builder.append(this.getFullTypePeriode());
        builder.append(",");
        builder.append(this.cumul);
        builder.append(",");
        builder.append(this.cumulPerpetual);
        builder.append(",");
        builder.append(this.tva5);
        builder.append(",");
        builder.append(this.tva10);
        builder.append(",");
        builder.append(this.tva20);
        builder.append(",");
        builder.append(DateUtils.SDF_DATE_SIGNATURE.format(this.timestampGDH));
        builder.append(",");
        builder.append(this.signature);
        builder.append(",");
        builder.append(this.tva0);
        builder.append(",");
        builder.append(this.tva_7_7);
        builder.append(",");
        builder.append(this.tva_2_5);
        builder.append(",");
        builder.append(this.tva_2_1);
        builder.append(",");
        builder.append(this.tva_8_5);
        builder.append(",");
        builder.append(this.cumulPerpetualReel);
        builder.append(",");
        builder.append(this.round_amount);
        builder.append(",");
        builder.append(this.tva_6);
        builder.append(",");
        builder.append(this.tva_12);
        builder.append(",");
        builder.append(this.tva_21);
        builder.append(",");
        builder.append(this.tva_8_1);
        builder.append(",");
        builder.append(this.tva_2_6);
        return builder.toString();
    }

    public String getFullTypePeriode() {
        if (this.typePeriode.equals("j")) {
            return "Journali\u00e8re";
        }
        if (this.typePeriode.equals("m")) {
            return "Mensuel";
        }
        return "Annuel";
    }

    public static SerializerRead getSerializerRead() {
        return dr -> {
            GrandTotalPeriode mGrandTotalPeriode = new GrandTotalPeriode();
            mGrandTotalPeriode.id = dr.getString(1);
            mGrandTotalPeriode.cumul = dr.getDouble(2);
            mGrandTotalPeriode.cumulPerpetual = dr.getDouble(3);
            mGrandTotalPeriode.tva5 = dr.getDouble(4);
            mGrandTotalPeriode.tva10 = dr.getDouble(5);
            mGrandTotalPeriode.tva20 = dr.getDouble(6);
            mGrandTotalPeriode.signature = dr.getString(7);
            mGrandTotalPeriode.typePeriode = dr.getString(8);
            mGrandTotalPeriode.timestampGDH = dr.getTimestamp(9);
            mGrandTotalPeriode.cumulPerpetualReel = dr.getDouble(10);
            mGrandTotalPeriode.cash_total = dr.getDouble(11);
            mGrandTotalPeriode.cb_total = dr.getDouble(12);
            mGrandTotalPeriode.tr_total = dr.getDouble(13);
            mGrandTotalPeriode.debit_total = dr.getDouble(14);
            mGrandTotalPeriode.credit_employee_total = dr.getDouble(15);
            mGrandTotalPeriode.loyalty_card = dr.getDouble(16);
            mGrandTotalPeriode.cashdro_total = dr.getDouble(17);
            mGrandTotalPeriode.cash_glory_total = dr.getDouble(18);
            mGrandTotalPeriode.virement_total = dr.getDouble(19);
            mGrandTotalPeriode.cheque_total = dr.getDouble(20);
            mGrandTotalPeriode.avoir_decaisse_total = dr.getDouble(21);
            mGrandTotalPeriode.avoir_encaisse_total = dr.getDouble(22);
            mGrandTotalPeriode.tva_5_5_ht = dr.getDouble(23);
            mGrandTotalPeriode.tva_10_ht = dr.getDouble(24);
            mGrandTotalPeriode.tva_20_ht = dr.getDouble(25);
            mGrandTotalPeriode.number_orders = dr.getInt(26);
            mGrandTotalPeriode.number_products_sold = dr.getDouble(27);
            mGrandTotalPeriode.turnover_canceled = dr.getDouble(28);
            mGrandTotalPeriode.total_orders_at_spot = dr.getDouble(29);
            mGrandTotalPeriode.total_orders_take_away = dr.getDouble(30);
            mGrandTotalPeriode.total_orders_delivery = dr.getDouble(31);
            mGrandTotalPeriode.total_orders_uber = dr.getDouble(32);
            mGrandTotalPeriode.total_orders_delivero = dr.getDouble(33);
            mGrandTotalPeriode.number_cb = dr.getInt(34);
            mGrandTotalPeriode.number_tr = dr.getInt(35);
            mGrandTotalPeriode.total_discount = dr.getDouble(36);
            mGrandTotalPeriode.total_discount_lines = dr.getDouble(37);
            mGrandTotalPeriode.insert_ficancial_infos = dr.getBoolean(38);
            mGrandTotalPeriode.total_orders_just_eat = dr.getDouble(39);
            mGrandTotalPeriode.tva0 = dr.getDouble(40);
            mGrandTotalPeriode.tva_0_ht = dr.getDouble(41);
            mGrandTotalPeriode.total_orders_drive = dr.getDouble(42);
            mGrandTotalPeriode.tva_7_7 = dr.getDouble(43);
            mGrandTotalPeriode.tva_2_5 = dr.getDouble(44);
            mGrandTotalPeriode.tva_2_1 = dr.getDouble(45);
            mGrandTotalPeriode.tva_8_5 = dr.getDouble(46);
            mGrandTotalPeriode.tva_7_7_ht = dr.getDouble(47);
            mGrandTotalPeriode.tva_2_5_ht = dr.getDouble(48);
            mGrandTotalPeriode.tva_2_1_ht = dr.getDouble(49);
            mGrandTotalPeriode.tva_8_5_ht = dr.getDouble(50);
            mGrandTotalPeriode.twint_total = dr.getDouble(51);
            mGrandTotalPeriode.total_orders_smood = dr.getDouble(52);
            mGrandTotalPeriode.cheque_vacances_total = dr.getDouble(53);
            mGrandTotalPeriode.before_perpetual_reset = dr.getBoolean(54);
            mGrandTotalPeriode.isSynchronized = dr.getBoolean(55);
            mGrandTotalPeriode.round_amount = dr.getBoolean(56);
            mGrandTotalPeriode.turnover_platform = dr.getDouble(57);
            mGrandTotalPeriode.number_orders_platform = dr.getInt(58);
            mGrandTotalPeriode.total_orders_deliveroo = dr.getDouble(59);
            mGrandTotalPeriode.tva_6 = dr.getDouble(60);
            mGrandTotalPeriode.tva_12 = dr.getDouble(61);
            mGrandTotalPeriode.tva_21 = dr.getDouble(62);
            mGrandTotalPeriode.tva_6_ht = dr.getDouble(63);
            mGrandTotalPeriode.tva_12_ht = dr.getDouble(64);
            mGrandTotalPeriode.tva_21_ht = dr.getDouble(65);
            mGrandTotalPeriode.turnover_ubereat = dr.getDouble(66);
            mGrandTotalPeriode.total_orders_dishop = dr.getDouble(67);
            mGrandTotalPeriode.stripe_total = dr.getDouble(68);
            mGrandTotalPeriode.cash_logy_total = dr.getDouble(69);
            mGrandTotalPeriode.tva_8_1 = dr.getDouble(70);
            mGrandTotalPeriode.tva_2_6 = dr.getDouble(71);
            mGrandTotalPeriode.tva_8_1_ht = dr.getDouble(72);
            mGrandTotalPeriode.tva_2_6_ht = dr.getDouble(73);
            mGrandTotalPeriode.tps = dr.getDouble(74);
            mGrandTotalPeriode.tvq = dr.getDouble(75);
            mGrandTotalPeriode.credit_card_total = dr.getDouble(76);
            mGrandTotalPeriode.debit_card_total = dr.getDouble(77);
            mGrandTotalPeriode.total_ht_taxable = dr.getDouble(78);
            mGrandTotalPeriode.total_ht_no_taxable = dr.getDouble(79);
            mGrandTotalPeriode.total_ht_orders_at_spot = dr.getDouble(80);
            mGrandTotalPeriode.total_ht_orders_take_away = dr.getDouble(81);
            mGrandTotalPeriode.total_ht_orders_delivery = dr.getDouble(82);
            mGrandTotalPeriode.total_ht_orders_drive = dr.getDouble(83);
            mGrandTotalPeriode.number_orders_at_spot = dr.getDouble(84);
            mGrandTotalPeriode.number_orders_take_away = dr.getDouble(85);
            mGrandTotalPeriode.number_orders_delivery = dr.getDouble(86);
            mGrandTotalPeriode.number_orders_drive = dr.getDouble(87);
            mGrandTotalPeriode.carte_tr_total = dr.getDouble(88);
            mGrandTotalPeriode.bank_transfer_total = dr.getDouble(89);
            mGrandTotalPeriode.number_carte_tr = dr.getInt(90);
            return mGrandTotalPeriode;
        };
    }

    public static String getEntete() {
        return "id,TypePeriode,cumul,cumulPerpetual,tva5,tva10,tva20,timestampGDH,signature,tva0,tva_7_7,tva_2_5,tva_2_1,tva_8_5,cumulPerpetualReel,round_amount,tva_6,tva_12,tva_21,tva_8_1,tva_2_6";
    }

    @Override
    public String getEmprinteWithoutPreviousSignature() {
        StringBuilder builderEmprinteGrandPeriode = new StringBuilder();
        this.signatureUtils.addTvaToSignature(builderEmprinteGrandPeriode, this.tva5, this.tva10, this.tva20, this.tva0, this.tva_7_7, this.tva_2_5, this.tva_2_1, this.tva_8_5, this.tva_6, this.tva_12, this.tva_21, this.tva_8_1, this.tva_2_6, this.round_amount);
        builderEmprinteGrandPeriode.append(",").append((long)this.getAmount(this.cumul)).append(",").append((long)this.getAmount(this.cumulPerpetualReel)).append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(this.timestampGDH)).append(",").append(this.id);
        return builderEmprinteGrandPeriode.toString();
    }

    @Override
    public String getIdAndTable() {
        return "GRAND_TOTAL_PERIODE identifie par " + this.getId();
    }

    public String displayTypePeriode() {
        switch (this.typePeriode) {
            case "j": {
                return "Cloture journali\u00e8re";
            }
            case "m": {
                return "Cloture mensuel";
            }
            case "a": {
                return "Cloture d'exercice";
            }
        }
        return "";
    }

    public String displayPeriodeName() {
        switch (this.typePeriode) {
            case "j": {
                return "Le " + this.id.substring(6) + "-" + this.id.substring(4, 6) + "-" + this.id.substring(0, 4);
            }
            case "m": {
                return "Le mois " + this.id.substring(4, 6) + "-" + this.id.substring(0, 4);
            }
            case "a": {
                return "L'ann\u00e9e " + this.id.substring(0, 4);
            }
        }
        return "";
    }

    public int getYear() {
        return Integer.valueOf(this.id.substring(0, 4));
    }

    public int getMonth() {
        return Integer.valueOf(this.id.substring(4, 6));
    }

    public int getDay() {
        return Integer.valueOf(this.id.substring(6));
    }

    public double getCumulPerpetualReel() {
        return this.cumulPerpetualReel;
    }

    public void setCumulPerpetualReel(double cumulPerpetualReel) {
        this.cumulPerpetualReel = cumulPerpetualReel;
    }

    public double getCash_total() {
        return this.cash_total;
    }

    public void setCash_total(double cash_total) {
        this.cash_total = cash_total;
    }

    public double getCb_total() {
        return this.cb_total;
    }

    public void setCb_total(double cb_total) {
        this.cb_total = cb_total;
    }

    public double getTr_total() {
        return this.tr_total;
    }

    public void setTr_total(double tr_total) {
        this.tr_total = tr_total;
    }

    public double getDebit_total() {
        return this.debit_total;
    }

    public void setDebit_total(double debit_total) {
        this.debit_total = debit_total;
    }

    public double getCredit_employee_total() {
        return this.credit_employee_total;
    }

    public void setCredit_employee_total(double credit_employee_total) {
        this.credit_employee_total = credit_employee_total;
    }

    public double getLoyalty_card() {
        return this.loyalty_card;
    }

    public void setLoyalty_card(double loyalty_card) {
        this.loyalty_card = loyalty_card;
    }

    public double getCashdro_total() {
        return this.cashdro_total;
    }

    public void setCashdro_total(double cashdro_total) {
        this.cashdro_total = cashdro_total;
    }

    public double getCash_glory_total() {
        return this.cash_glory_total;
    }

    public void setCash_glory_total(double cash_glory_total) {
        this.cash_glory_total = cash_glory_total;
    }

    public double getVirement_total() {
        return this.virement_total;
    }

    public void setVirement_total(double virement_total) {
        this.virement_total = virement_total;
    }

    public double getCheque_total() {
        return this.cheque_total;
    }

    public void setCheque_total(double cheque_total) {
        this.cheque_total = cheque_total;
    }

    public double getAvoir_decaisse_total() {
        return this.avoir_decaisse_total;
    }

    public void setAvoir_decaisse_total(double avoir_decaisse_total) {
        this.avoir_decaisse_total = avoir_decaisse_total;
    }

    public double getAvoir_encaisse_total() {
        return this.avoir_encaisse_total;
    }

    public void setAvoir_encaisse_total(double avoir_encaisse_total) {
        this.avoir_encaisse_total = avoir_encaisse_total;
    }

    public double getTva_5_5_ht() {
        return this.tva_5_5_ht;
    }

    public void setTva_5_5_ht(double tva_5_5_ht) {
        this.tva_5_5_ht = tva_5_5_ht;
    }

    public double getTva_10_ht() {
        return this.tva_10_ht;
    }

    public void setTva_10_ht(double tva_10_ht) {
        this.tva_10_ht = tva_10_ht;
    }

    public double getTva_20_ht() {
        return this.tva_20_ht;
    }

    public void setTva_20_ht(double tva_20_ht) {
        this.tva_20_ht = tva_20_ht;
    }

    public int getNumber_orders() {
        return this.number_orders;
    }

    public void setNumber_orders(int number_orders) {
        this.number_orders = number_orders;
    }

    public double getNumber_products_sold() {
        return this.number_products_sold;
    }

    public void setNumber_products_sold(double number_products_sold) {
        this.number_products_sold = number_products_sold;
    }

    public double getTurnover_canceled() {
        return this.turnover_canceled;
    }

    public void setTurnover_canceled(double turnover_canceled) {
        this.turnover_canceled = turnover_canceled;
    }

    public double getTotal_orders_at_spot() {
        return this.total_orders_at_spot;
    }

    public void setTotal_orders_at_spot(double total_orders_at_spot) {
        this.total_orders_at_spot = total_orders_at_spot;
    }

    public double getTotal_orders_take_away() {
        return this.total_orders_take_away;
    }

    public void setTotal_orders_take_away(double total_orders_take_away) {
        this.total_orders_take_away = total_orders_take_away;
    }

    public double getTotal_orders_delivery() {
        return this.total_orders_delivery;
    }

    public void setTotal_orders_delivery(double total_orders_delivery) {
        this.total_orders_delivery = total_orders_delivery;
    }

    public double getTotal_orders_uber() {
        return this.total_orders_uber;
    }

    public void setTotal_orders_uber(double total_orders_uber) {
        this.total_orders_uber = total_orders_uber;
    }

    public double getTotal_orders_delivero() {
        return this.total_orders_delivero;
    }

    public void setTotal_orders_delivero(double total_orders_delivero) {
        this.total_orders_delivero = total_orders_delivero;
    }

    public int getNumber_cb() {
        return this.number_cb;
    }

    public void setNumber_cb(int number_cb) {
        this.number_cb = number_cb;
    }

    public int getNumber_tr() {
        return this.number_tr;
    }

    public void setNumber_tr(int number_tr) {
        this.number_tr = number_tr;
    }

    public double getTotal_discount() {
        return this.total_discount;
    }

    public void setTotal_discount(double total_discount) {
        this.total_discount = total_discount;
    }

    public double getTotal_discount_lines() {
        return this.total_discount_lines;
    }

    public void setTotal_discount_lines(double total_discount_lines) {
        this.total_discount_lines = total_discount_lines;
    }

    public boolean isInsert_ficancial_infos() {
        return this.insert_ficancial_infos;
    }

    public void setInsert_ficancial_infos(boolean insert_ficancial_infos) {
        this.insert_ficancial_infos = insert_ficancial_infos;
    }

    public double getTotal_orders_just_eat() {
        return this.total_orders_just_eat;
    }

    public void setTotal_orders_just_eat(double total_orders_just_eat) {
        this.total_orders_just_eat = total_orders_just_eat;
    }

    public List<PaymentLine> getPayments() {
        ArrayList<PaymentLine> all_payments = new ArrayList<PaymentLine>();
        if (this.cash_total != 0.0) {
            all_payments.add(new PaymentLine("Espece", this.cash_total, 1));
        }
        if (this.cb_total != 0.0) {
            all_payments.add(new PaymentLine("CB", this.cb_total, this.number_cb));
        }
        if (this.carte_tr_total != 0.0) {
            all_payments.add(new PaymentLine("Carte Ticket Resto", this.carte_tr_total, this.number_carte_tr));
        }
        if (this.tr_total != 0.0) {
            all_payments.add(new PaymentLine("Ticket Resto", this.tr_total, this.number_tr));
        }
        if (this.debit_total != 0.0) {
            all_payments.add(new PaymentLine("Debit", this.debit_total, 1));
        }
        if (this.credit_employee_total != 0.0) {
            all_payments.add(new PaymentLine("Cr\u00e9dit Employ\u00e9", this.credit_employee_total, 1));
        }
        if (this.loyalty_card != 0.0) {
            all_payments.add(new PaymentLine("Carte Fid\u00e9lit\u00e9", this.loyalty_card, 1));
        }
        if (this.cashdro_total != 0.0) {
            all_payments.add(new PaymentLine("Cashdro", this.cashdro_total, 1));
        }
        if (this.cash_glory_total != 0.0) {
            all_payments.add(new PaymentLine("cashGlory", this.cash_glory_total, 1));
        }
        if (this.virement_total != 0.0) {
            all_payments.add(new PaymentLine("Virement", this.virement_total, 1));
        }
        if (this.cheque_total != 0.0) {
            all_payments.add(new PaymentLine("cheque", this.cheque_total, 1));
        }
        if (this.avoir_decaisse_total != 0.0) {
            all_payments.add(new PaymentLine("Avoir", this.avoir_decaisse_total, 1));
        }
        if (this.avoir_encaisse_total != 0.0) {
            all_payments.add(new PaymentLine("Avoir", this.avoir_encaisse_total, 1));
        }
        if (this.twint_total != 0.0) {
            all_payments.add(new PaymentLine("Twint", this.twint_total, 1));
        }
        if (this.cheque_vacances_total != 0.0) {
            all_payments.add(new PaymentLine("Ch\u00e8que vacances", this.cheque_vacances_total, 1));
        }
        if (this.cash_logy_total != 0.0) {
            all_payments.add(new PaymentLine("Cashlogy", this.cash_logy_total, 1));
        }
        if (this.stripe_total != 0.0) {
            all_payments.add(new PaymentLine("stripe", this.stripe_total, 1));
        }
        if (this.credit_card_total != 0.0) {
            all_payments.add(new PaymentLine("carte credit", this.credit_card_total, 1));
        }
        if (this.debit_card_total != 0.0) {
            all_payments.add(new PaymentLine("carte debit", this.debit_card_total, 1));
        }
        if (this.bank_transfer_total != 0.0) {
            all_payments.add(new PaymentLine("Virement bancaire", this.bank_transfer_total, 1));
        }
        return all_payments;
    }

    public List<TaxeLine> getTaxes() {
        ArrayList<TaxeLine> all_taxes = new ArrayList<TaxeLine>();
        if (this.tva_5_5_ht != 0.0) {
            all_taxes.add(new TaxeLine("001", "5.5%", 0.055, this.tva5, this.tva5 / 1.055, this.tva5 - this.tva5 / 1.055));
        }
        if (this.tva_10_ht != 0.0) {
            all_taxes.add(new TaxeLine("002", "10%", 0.1, this.tva10, this.tva10 / 1.1, this.tva10 - this.tva10 / 1.1));
        }
        if (this.tva_20_ht != 0.0) {
            all_taxes.add(new TaxeLine("003", "20%", 0.2, this.tva20, this.tva20 / 1.2, this.tva20 - this.tva20 / 1.2));
        }
        if (this.tva_0_ht != 0.0) {
            all_taxes.add(new TaxeLine("004", "0%", 0.0, this.tva0, this.tva0, 0.0));
        }
        if (this.tva_7_7_ht != 0.0) {
            all_taxes.add(new TaxeLine("005", "7.7%", 0.077, this.tva_7_7, this.tva_7_7 / 1.077, this.tva_7_7 - this.tva_7_7 / 1.077));
        }
        if (this.tva_2_5_ht != 0.0) {
            all_taxes.add(new TaxeLine("006", "2.5%", 0.025, this.tva_2_5, this.tva_2_5 / 1.025, this.tva_2_5 - this.tva_2_5 / 1.025));
        }
        if (this.tva_2_1_ht != 0.0) {
            all_taxes.add(new TaxeLine("007", "2.1%", 0.021, this.tva_2_1, this.tva_2_1 / 1.021, this.tva_2_1 - this.tva_2_1 / 1.021));
        }
        if (this.tva_8_5_ht != 0.0) {
            all_taxes.add(new TaxeLine("008", "8.5%", 0.085, this.tva_8_5, this.tva_8_5 / 1.085, this.tva_8_5 - this.tva_8_5 / 1.085));
        }
        if (this.tva_6_ht != 0.0) {
            all_taxes.add(new TaxeLine("009", "6%", 0.06, this.tva_6, this.tva_6 / 1.06, this.tva_6 - this.tva_6 / 1.06));
        }
        if (this.tva_12_ht != 0.0) {
            all_taxes.add(new TaxeLine("010", "12%", 0.12, this.tva_12, this.tva_12 / 1.12, this.tva_12 - this.tva_12 / 1.12));
        }
        if (this.tva_21_ht != 0.0) {
            all_taxes.add(new TaxeLine("011", "21%", 0.21, this.tva_21, this.tva_21 / 1.21, this.tva_21 - this.tva_21 / 1.21));
        }
        if (this.tva_8_1_ht != 0.0) {
            all_taxes.add(new TaxeLine("012", "8.1%", 0.081, this.tva_8_1, this.tva_8_1 / 1.081, this.tva_8_1 - this.tva_8_1 / 1.081));
        }
        if (this.tva_2_6_ht != 0.0) {
            all_taxes.add(new TaxeLine("013", "2.6%", 0.026, this.tva_2_6, this.tva_2_6 / 1.026, this.tva_2_6 - this.tva_2_6 / 1.026));
        }
        return all_taxes;
    }

    public List<RankTypeOrder> getTypeOrders() {
        ArrayList<RankTypeOrder> typeOrders = new ArrayList<RankTypeOrder>();
        if (this.total_orders_at_spot != 0.0) {
            typeOrders.add(new RankTypeOrder("Sur Place", this.total_orders_at_spot, 1.0));
        }
        if (this.total_orders_take_away != 0.0) {
            typeOrders.add(new RankTypeOrder("A Emporter", this.total_orders_take_away, 1.0));
        }
        if (this.total_orders_delivery != 0.0) {
            typeOrders.add(new RankTypeOrder("En Livraison", this.total_orders_delivery, 1.0));
        }
        if (this.total_orders_drive != 0.0) {
            typeOrders.add(new RankTypeOrder("Drive", this.total_orders_drive, 1.0));
        }
        if (this.total_orders_dishop != 0.0) {
            typeOrders.add(new RankTypeOrder("Dishop", this.total_orders_dishop, 1.0));
        }
        return typeOrders;
    }

    public double getTva0() {
        return this.tva0;
    }

    public void setTva0(double tva0) {
        this.tva0 = tva0;
    }

    public double getTva_0_ht() {
        return this.tva_0_ht;
    }

    public void setTva_0_ht(double tva_0_ht) {
        this.tva_0_ht = tva_0_ht;
    }

    public double getTva_7_7() {
        return this.tva_7_7;
    }

    public void setTva_7_7(double tva_7_7) {
        this.tva_7_7 = tva_7_7;
    }

    public double getTva_2_5() {
        return this.tva_2_5;
    }

    public void setTva_2_5(double tva_2_5) {
        this.tva_2_5 = tva_2_5;
    }

    public double getTva_2_1() {
        return this.tva_2_1;
    }

    public void setTva_2_1(double tva_2_1) {
        this.tva_2_1 = tva_2_1;
    }

    public double getTva_8_5() {
        return this.tva_8_5;
    }

    public void setTva_8_5(double tva_8_5) {
        this.tva_8_5 = tva_8_5;
    }

    public double getTva_7_7_ht() {
        return this.tva_7_7_ht;
    }

    public void setTva_7_7_ht(double tva_7_7_ht) {
        this.tva_7_7_ht = tva_7_7_ht;
    }

    public double getTva_2_5_ht() {
        return this.tva_2_5_ht;
    }

    public void setTva_2_5_ht(double tva_2_5_ht) {
        this.tva_2_5_ht = tva_2_5_ht;
    }

    public double getTva_2_1_ht() {
        return this.tva_2_1_ht;
    }

    public void setTva_2_1_ht(double tva_2_1_ht) {
        this.tva_2_1_ht = tva_2_1_ht;
    }

    public double getTva_8_5_ht() {
        return this.tva_8_5_ht;
    }

    public void setTva_8_5_ht(double tva_8_5_ht) {
        this.tva_8_5_ht = tva_8_5_ht;
    }

    public double getTotal_orders_drive() {
        return this.total_orders_drive;
    }

    public void setTotal_orders_drive(double total_orders_drive) {
        this.total_orders_drive = total_orders_drive;
    }

    public double getTwint_total() {
        return this.twint_total;
    }

    public void setTwint_total(double twint_total) {
        this.twint_total = twint_total;
    }

    public double getTotal_orders_smood() {
        return this.total_orders_smood;
    }

    public void setTotal_orders_smood(double total_orders_smood) {
        this.total_orders_smood = total_orders_smood;
    }

    public double getCheque_vacances_total() {
        return this.cheque_vacances_total;
    }

    public void setCheque_vacances_total(double cheque_vacances_total) {
        this.cheque_vacances_total = cheque_vacances_total;
    }

    public boolean isBefore_perpetual_reset() {
        return this.before_perpetual_reset;
    }

    public void setBefore_perpetual_reset(boolean before_perpetual_reset) {
        this.before_perpetual_reset = before_perpetual_reset;
    }

    public List<GrandTotalPeriode> getGrandTotauxJournalier() {
        return this.grandTotauxJournalier;
    }

    public void setGrandTotauxJournalier(List<GrandTotalPeriode> grandTotauxJournalier) {
        this.grandTotauxJournalier = grandTotauxJournalier;
    }

    public List<PaymentLine> getPayments(Date start) {
        String idPeriod = DateUtils.SDF_ID_DAY_PERIOD.format(start);
        for (GrandTotalPeriode grandTotalPeriode : this.grandTotauxJournalier) {
            if (!grandTotalPeriode.getId().equals(idPeriod)) continue;
            return grandTotalPeriode.getPayments();
        }
        return null;
    }

    public List<TaxeLine> getTaxes(Date start) {
        String idPeriod = DateUtils.SDF_ID_DAY_PERIOD.format(start);
        for (GrandTotalPeriode grandTotalPeriode : this.grandTotauxJournalier) {
            if (!grandTotalPeriode.getId().equals(idPeriod)) continue;
            return grandTotalPeriode.getTaxes();
        }
        return null;
    }

    public double getCumul(Date start) {
        String idPeriod = DateUtils.SDF_ID_DAY_PERIOD.format(start);
        for (GrandTotalPeriode grandTotalPeriode : this.grandTotauxJournalier) {
            if (!grandTotalPeriode.getId().equals(idPeriod)) continue;
            return grandTotalPeriode.getCumul();
        }
        return 0.0;
    }

    public boolean isIsSynchronized() {
        return this.isSynchronized;
    }

    public void setIsSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    private double getAmount(double amount_value) {
        return this.round_amount ? NumericUtils.round(NumericUtils.round(amount_value) * 100.0) : NumericUtils.round(amount_value) * 100.0;
    }

    public int getNbOrders(Date start) {
        String idPeriod = DateUtils.SDF_ID_DAY_PERIOD.format(start);
        for (GrandTotalPeriode grandTotalPeriode : this.grandTotauxJournalier) {
            if (!grandTotalPeriode.getId().equals(idPeriod)) continue;
            return grandTotalPeriode.getNumber_orders();
        }
        return 0;
    }

    public double getTurnover_platform() {
        return this.turnover_platform;
    }

    public void setTurnover_platform(double turnover_platform) {
        this.turnover_platform = turnover_platform;
    }

    public int getNumber_orders_platform() {
        return this.number_orders_platform;
    }

    public void setNumber_orders_platform(int number_orders_platform) {
        this.number_orders_platform = number_orders_platform;
    }

    public double getCash_logy_total() {
        return this.cash_logy_total;
    }

    public void setCash_logy_total(double cash_logy) {
        this.cash_logy_total = cash_logy;
    }

    public double getTotal_orders_dishop() {
        return this.total_orders_dishop;
    }

    public void setTotal_orders_dishop(double total_orders_dishop) {
        this.total_orders_dishop = total_orders_dishop;
    }

    public double getStripe_total() {
        return this.stripe_total;
    }

    public void setStripe_total(double stripe_total) {
        this.stripe_total = stripe_total;
    }

    public double getTotal_orders_deliveroo() {
        return this.total_orders_deliveroo;
    }

    public void setTotal_orders_deliveroo(double total_orders_deliveroo) {
        this.total_orders_deliveroo = total_orders_deliveroo;
    }

    public double getTva_6() {
        return this.tva_6;
    }

    public void setTva_6(double tva_6) {
        this.tva_6 = tva_6;
    }

    public double getTva_12() {
        return this.tva_12;
    }

    public void setTva_12(double tva_12) {
        this.tva_12 = tva_12;
    }

    public double getTva_6_ht() {
        return this.tva_6_ht;
    }

    public void setTva_6_ht(double tva_6_ht) {
        this.tva_6_ht = tva_6_ht;
    }

    public double getTva_12_ht() {
        return this.tva_12_ht;
    }

    public void setTva_12_ht(double tva_12_ht) {
        this.tva_12_ht = tva_12_ht;
    }

    public double getTva_21() {
        return this.tva_21;
    }

    public void setTva_21(double tva_21) {
        this.tva_21 = tva_21;
    }

    public double getTva_21_ht() {
        return this.tva_21_ht;
    }

    public void setTva_21_ht(double tva_21_ht) {
        this.tva_21_ht = tva_21_ht;
    }

    public double getTps() {
        return this.tps;
    }

    public void setTps(double tps) {
        this.tps = tps;
    }

    public double getTvq() {
        return this.tvq;
    }

    public void setTvq(double tvq) {
        this.tvq = tvq;
    }

    public double getCredit_card_total() {
        return this.credit_card_total;
    }

    public void setCredit_card_total(double credit_card_total) {
        this.credit_card_total = credit_card_total;
    }

    public double getDebit_card_total() {
        return this.debit_card_total;
    }

    public void setDebit_card_total(double debit_card_total) {
        this.debit_card_total = debit_card_total;
    }

    public double getTotal_ht_taxable() {
        return this.total_ht_taxable;
    }

    public void setTotal_ht_taxable(double total_ht_taxable) {
        this.total_ht_taxable = total_ht_taxable;
    }

    public double getTotal_ht_no_taxable() {
        return this.total_ht_no_taxable;
    }

    public void setTotal_ht_no_taxable(double total_ht_no_taxable) {
        this.total_ht_no_taxable = total_ht_no_taxable;
    }

    public List<GroupedTax> getGtpTaxes() {
        return this.gtpTaxes;
    }

    public void setGtpTaxes(List<GroupedTax> gtpTaxes) {
        this.gtpTaxes = gtpTaxes;
    }

    public String getMsgIntegrityError() {
        return "GTP{ " + this.toString() + " }";
    }

    public double getTurnover_ubereat() {
        return this.turnover_ubereat;
    }

    public void setTurnover_ubereat(double turnover_ubereat) {
        this.turnover_ubereat = turnover_ubereat;
    }

    public double getTva_8_1() {
        return this.tva_8_1;
    }

    public void setTva_8_1(double tva_8_1) {
        this.tva_8_1 = tva_8_1;
    }

    public double getTva_2_6() {
        return this.tva_2_6;
    }

    public void setTva_2_6(double tva_2_6) {
        this.tva_2_6 = tva_2_6;
    }

    public double getTva_8_1_ht() {
        return this.tva_8_1_ht;
    }

    public void setTva_8_1_ht(double tva_8_1_ht) {
        this.tva_8_1_ht = tva_8_1_ht;
    }

    public double getTva_2_6_ht() {
        return this.tva_2_6_ht;
    }

    public void setTva_2_6_ht(double tva_2_6_ht) {
        this.tva_2_6_ht = tva_2_6_ht;
    }

    public double getTva_5_5_ubereats() {
        return this.tva_5_5_ubereats;
    }

    public void setTva_5_5_ubereats(double tva_5_5_ubereats) {
        this.tva_5_5_ubereats = tva_5_5_ubereats;
    }

    public double getTva_10_ubereats() {
        return this.tva_10_ubereats;
    }

    public void setTva_10_ubereats(double tva_10_ubereats) {
        this.tva_10_ubereats = tva_10_ubereats;
    }

    public List<RankTypeOrder> getTypePlatformOrders() {
        double total_deliveroo = this.total_orders_deliveroo + this.total_orders_delivero;
        ArrayList<RankTypeOrder> typeOrders = new ArrayList<RankTypeOrder>();
        if (this.total_orders_uber != 0.0) {
            typeOrders.add(new RankTypeOrder("Uber Eats", this.total_orders_uber, 1.0));
        }
        if (total_deliveroo != 0.0) {
            typeOrders.add(new RankTypeOrder("Deliveroo", total_deliveroo, 1.0));
        }
        if (this.total_orders_just_eat != 0.0) {
            typeOrders.add(new RankTypeOrder("Just Eat", this.total_orders_just_eat, 1.0));
        }
        if (this.total_orders_smood != 0.0) {
            typeOrders.add(new RankTypeOrder("Smood", this.total_orders_smood, 1.0));
        }
        return typeOrders;
    }

    public double getTotal_ht_orders_at_spot() {
        return this.total_ht_orders_at_spot;
    }

    public void setTotal_ht_orders_at_spot(double total_ht_orders_at_spot) {
        this.total_ht_orders_at_spot = total_ht_orders_at_spot;
    }

    public double getTotal_ht_orders_take_away() {
        return this.total_ht_orders_take_away;
    }

    public void setTotal_ht_orders_take_away(double total_ht_orders_take_away) {
        this.total_ht_orders_take_away = total_ht_orders_take_away;
    }

    public double getTotal_ht_orders_delivery() {
        return this.total_ht_orders_delivery;
    }

    public void setTotal_ht_orders_delivery(double total_ht_orders_delivery) {
        this.total_ht_orders_delivery = total_ht_orders_delivery;
    }

    public double getTotal_ht_orders_drive() {
        return this.total_ht_orders_drive;
    }

    public void setTotal_ht_orders_drive(double total_ht_orders_drive) {
        this.total_ht_orders_drive = total_ht_orders_drive;
    }

    public double getNumber_orders_at_spot() {
        return this.number_orders_at_spot;
    }

    public void setNumber_orders_at_spot(double number_orders_at_spot) {
        this.number_orders_at_spot = number_orders_at_spot;
    }

    public double getNumber_orders_take_away() {
        return this.number_orders_take_away;
    }

    public void setNumber_orders_take_away(double number_orders_take_away) {
        this.number_orders_take_away = number_orders_take_away;
    }

    public double getNumber_orders_delivery() {
        return this.number_orders_delivery;
    }

    public void setNumber_orders_delivery(double number_orders_delivery) {
        this.number_orders_delivery = number_orders_delivery;
    }

    public double getNumber_orders_drive() {
        return this.number_orders_drive;
    }

    public void setNumber_orders_drive(double number_orders_drive) {
        this.number_orders_drive = number_orders_drive;
    }

    public double getCarte_tr_total() {
        return this.carte_tr_total;
    }

    public void setCarte_tr_total(double carte_tr_total) {
        this.carte_tr_total = carte_tr_total;
    }

    public double getBank_transfer_total() {
        return this.bank_transfer_total;
    }

    public void setBank_transfer_total(double bank_transfer_total) {
        this.bank_transfer_total = bank_transfer_total;
    }

    public int getNumber_carte_tr() {
        return this.number_carte_tr;
    }

    public void setNumber_carte_tr(int number_carte_tr) {
        this.number_carte_tr = number_carte_tr;
    }

    public double getTaxeByName(String name) {
        if (this.gtpTaxes != null) {
            for (GroupedTax gtpTaxe : this.gtpTaxes) {
                if (gtpTaxe.getName() == null || !gtpTaxe.getName().equalsIgnoreCase(name)) continue;
                return gtpTaxe.getTotal_tax();
            }
        }
        return 0.0;
    }
}

