/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.norm.beans;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.SignatureUtils;
import com.openbravo.pos.util.Signed;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.GrandTotalTicket;
import fr.protactile.norm.beans.LineFacture;
import fr.protactile.norm.beans.RecapGeneralFacture;
import fr.protactile.norm.beans.RecapTaxFacture;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Facture
extends Signed {
    private long id;
    private String company;
    private String name_contact;
    private String address;
    private String zip_code;
    private String city;
    private String country;
    private String siret;
    private String code_NAF;
    private String num_tva;
    private String ticket;
    private double total;
    private double tva5;
    private double tva10;
    private double tva20;
    private Date dateFacture;
    private boolean cancel;
    private int nb_print;
    private boolean physical_person;
    private String signature;
    private long numDoc;
    private GrandTotalTicket grandTotalTicket;
    private double tva0;
    private double tva_7_7;
    private double tva_2_5;
    private double tva_2_1;
    private double tva_8_5;
    private String type_operation;
    public static String CANCEL = "ANNULATION";
    private String version_soft;
    private String name_soft;
    private int id_customer;
    private String company_sender;
    private String address_sender;
    private String zip_code_sender;
    private String city_sender;
    private String country_sender;
    private String siret_sender;
    private String code_NAF_sender;
    private String num_tva_sender;
    private String forme_juridique_sender;
    private String capital_social_sender;
    private String RCS_sender;
    private String greffe_sender;
    private String metier_sender;
    private String code_operator;
    private String name_operator;
    private String code_caisse;
    private int ref_ticket;
    private boolean info_sender_included;
    private boolean use_type_in_signature;
    private boolean round_amount;
    private SignatureUtils signatureUtils;
    private double tva_6;
    private double tva_12;
    private double tva_21;
    private List<LineFacture> lines;
    private List<RecapTaxFacture> recapTaxes;
    private RecapGeneralFacture recapGeneralFacture;
    private double tva_8_1;
    private double tva_2_6;
    private String facture_type;
    private String reglement_tva_sender;
    private int canceled_facture_id;

    public long getNumDoc() {
        return this.numDoc;
    }

    public void setNumDoc(long numDoc) {
        this.numDoc = numDoc;
    }

    public Facture(long id, String company, String name_contact, String address, String zip_code, String city, String country, String siret, String code_NAF, String num_tva, String signature, long numDoc, double totale) {
        this.id = id;
        this.company = company;
        this.name_contact = name_contact;
        this.address = address;
        this.zip_code = zip_code;
        this.city = city;
        this.country = country;
        this.siret = siret;
        this.code_NAF = code_NAF;
        this.num_tva = num_tva;
        this.signature = signature;
        this.numDoc = numDoc;
        this.total = totale;
        this.signatureUtils = new SignatureUtils();
        this.lines = new ArrayList<LineFacture>();
        this.recapTaxes = new ArrayList<RecapTaxFacture>();
    }

    public Facture(long id, String company, String name_contact, String address, String zip_code, String city, String country, String siret, String code_NAF, String num_tva, String signature, long numDoc, double totale, String type_operation) {
        this.id = id;
        this.company = company;
        this.name_contact = name_contact;
        this.address = address;
        this.zip_code = zip_code;
        this.city = city;
        this.country = country;
        this.siret = siret;
        this.code_NAF = code_NAF;
        this.num_tva = num_tva;
        this.signature = signature;
        this.numDoc = numDoc;
        this.total = totale;
        this.type_operation = type_operation;
        this.signatureUtils = new SignatureUtils();
        this.lines = new ArrayList<LineFacture>();
        this.recapTaxes = new ArrayList<RecapTaxFacture>();
    }

    public Facture() {
        this.signatureUtils = new SignatureUtils();
        this.lines = new ArrayList<LineFacture>();
        this.recapTaxes = new ArrayList<RecapTaxFacture>();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getCompany() {
        return this.company != null && !this.company.isEmpty() ? this.company : "";
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getName_contact() {
        return this.name_contact != null && !this.name_contact.isEmpty() ? this.name_contact : "";
    }

    public void setName_contact(String name_contact) {
        this.name_contact = name_contact;
    }

    public String getAddress() {
        return this.address != null && !this.address.isEmpty() ? this.address : "";
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZip_code() {
        return this.zip_code != null && !this.zip_code.isEmpty() ? this.zip_code : "";
    }

    public void setZip_code(String zip_code) {
        this.zip_code = zip_code;
    }

    public String getCity() {
        return this.city != null && !this.city.isEmpty() ? this.city : "";
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country != null && !this.country.isEmpty() ? this.country : "";
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getSiret() {
        return this.siret != null && !this.siret.isEmpty() ? this.siret : "";
    }

    public void setSiret(String siret) {
        this.siret = siret;
    }

    public String getCode_NAF() {
        return this.code_NAF != null && !this.code_NAF.isEmpty() ? this.code_NAF : "";
    }

    public void setCode_NAF(String code_NAF) {
        this.code_NAF = code_NAF;
    }

    public String getNum_tva() {
        return this.num_tva != null && !this.num_tva.isEmpty() ? this.num_tva : "";
    }

    public void setNum_tva(String num_tva) {
        this.num_tva = num_tva;
    }

    public String getTicket() {
        return this.ticket != null && !this.ticket.isEmpty() ? this.ticket : "";
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public Date getDateFacture() {
        return this.dateFacture;
    }

    public void setDateFacture(Date dateFacture) {
        this.dateFacture = dateFacture;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public int getNb_print() {
        return this.nb_print;
    }

    public void setNb_print(int nb_print) {
        this.nb_print = nb_print;
    }

    public boolean isPhysical_person() {
        return this.physical_person;
    }

    public void setPhysical_person(boolean physical_person) {
        this.physical_person = physical_person;
    }

    public String getType_operation() {
        return this.type_operation;
    }

    public void setType_operation(String type_operation) {
        this.type_operation = type_operation;
    }

    public String getCompany_sender() {
        return this.company_sender;
    }

    public void setCompany_sender(String company_sender) {
        this.company_sender = company_sender;
    }

    public String getAddress_sender() {
        return this.address_sender;
    }

    public void setAddress_sender(String address_sender) {
        this.address_sender = address_sender;
    }

    public String getZip_code_sender() {
        return this.zip_code_sender;
    }

    public void setZip_code_sender(String zip_code_sender) {
        this.zip_code_sender = zip_code_sender;
    }

    public String getCity_sender() {
        return this.city_sender;
    }

    public void setCity_sender(String city_sender) {
        this.city_sender = city_sender;
    }

    public String getCountry_sender() {
        return this.country_sender;
    }

    public void setCountry_sender(String country_sender) {
        this.country_sender = country_sender;
    }

    public String getSiret_sender() {
        return this.siret_sender;
    }

    public void setSiret_sender(String siret_sender) {
        this.siret_sender = siret_sender;
    }

    public String getCode_NAF_sender() {
        return this.code_NAF_sender;
    }

    public void setCode_NAF_sender(String code_NAF_sender) {
        this.code_NAF_sender = code_NAF_sender;
    }

    public String getNum_tva_sender() {
        return this.num_tva_sender;
    }

    public void setNum_tva_sender(String num_tva_sender) {
        this.num_tva_sender = num_tva_sender;
    }

    public String getForme_juridique_sender() {
        return this.forme_juridique_sender;
    }

    public void setForme_juridique_sender(String forme_juridique_sender) {
        this.forme_juridique_sender = forme_juridique_sender;
    }

    public String getCapital_social_sender() {
        return this.capital_social_sender;
    }

    public void setCapital_social_sender(String capital_social_sender) {
        this.capital_social_sender = capital_social_sender;
    }

    public String getRCS_sender() {
        return this.RCS_sender;
    }

    public void setRCS_sender(String RCS_sender) {
        this.RCS_sender = RCS_sender;
    }

    public String getGreffe_sender() {
        return this.greffe_sender;
    }

    public void setGreffe_sender(String greffe_sender) {
        this.greffe_sender = greffe_sender;
    }

    public String getMetier_sender() {
        return this.metier_sender;
    }

    public void setMetier_sender(String metier_sender) {
        this.metier_sender = metier_sender;
    }

    public String getCode_operator() {
        return this.code_operator;
    }

    public void setCode_operator(String code_operator) {
        this.code_operator = code_operator;
    }

    public String getName_operator() {
        return this.name_operator;
    }

    public void setName_operator(String name_operator) {
        this.name_operator = name_operator;
    }

    public String getCode_caisse() {
        return this.code_caisse;
    }

    public void setCode_caisse(String code_caisse) {
        this.code_caisse = code_caisse;
    }

    public int getRef_ticket() {
        return this.ref_ticket;
    }

    public void setRef_ticket(int ref_ticket) {
        this.ref_ticket = ref_ticket;
    }

    public boolean isInfo_sender_included() {
        return this.info_sender_included;
    }

    public void setInfo_sender_included(boolean info_sender_included) {
        this.info_sender_included = info_sender_included;
    }

    public boolean isUse_type_in_signature() {
        return this.use_type_in_signature;
    }

    public void setUse_type_in_signature(boolean use_type_in_signature) {
        this.use_type_in_signature = use_type_in_signature;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                Facture facture = new Facture();
                facture.id = dr.getInt(1).intValue();
                facture.company = dr.getString(2);
                facture.name_contact = dr.getString(3);
                facture.address = dr.getString(4);
                facture.zip_code = dr.getString(5);
                facture.city = dr.getString(6);
                facture.country = dr.getString(7);
                facture.siret = dr.getString(8);
                facture.code_NAF = dr.getString(9);
                facture.num_tva = dr.getString(10);
                facture.ticket = dr.getString(11);
                facture.physical_person = dr.getBoolean(12);
                facture.cancel = dr.getBoolean(13);
                facture.nb_print = dr.getInt(14);
                facture.signature = dr.getString(15);
                facture.dateFacture = dr.getTimestamp(16);
                facture.numDoc = dr.getInt(17).intValue();
                facture.total = dr.getDouble(18);
                return facture;
            }
        };
    }

    public static SerializerRead getSerializerReadWtithTvas() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                Facture facture = new Facture();
                facture.id = dr.getInt(1).intValue();
                facture.company = dr.getString(2);
                facture.name_contact = dr.getString(3);
                facture.address = dr.getString(4);
                facture.zip_code = dr.getString(5);
                facture.city = dr.getString(6);
                facture.country = dr.getString(7);
                facture.siret = dr.getString(8);
                facture.code_NAF = dr.getString(9);
                facture.num_tva = dr.getString(10);
                facture.ticket = dr.getString(11);
                facture.physical_person = dr.getBoolean(12);
                facture.cancel = dr.getBoolean(13);
                facture.nb_print = dr.getInt(14);
                facture.signature = dr.getString(15);
                facture.dateFacture = dr.getTimestamp(16);
                facture.numDoc = dr.getInt(17).intValue();
                facture.total = dr.getDouble(18);
                facture.tva5 = dr.getDouble(19);
                facture.tva10 = dr.getDouble(20);
                facture.tva20 = dr.getDouble(21);
                facture.tva0 = dr.getDouble(22);
                facture.tva_7_7 = dr.getDouble(23);
                facture.tva_2_5 = dr.getDouble(24);
                facture.tva_2_1 = dr.getDouble(25);
                facture.tva_8_5 = dr.getDouble(26);
                facture.type_operation = dr.getString(27);
                facture.version_soft = dr.getString(28);
                facture.name_soft = dr.getString(29);
                facture.id_customer = dr.getInt(30);
                facture.company_sender = dr.getString(31);
                facture.address_sender = dr.getString(32);
                facture.zip_code_sender = dr.getString(33);
                facture.city_sender = dr.getString(34);
                facture.country_sender = dr.getString(35);
                facture.siret_sender = dr.getString(36);
                facture.code_NAF_sender = dr.getString(37);
                facture.num_tva_sender = dr.getString(38);
                facture.forme_juridique_sender = dr.getString(39);
                facture.capital_social_sender = dr.getString(40);
                facture.RCS_sender = dr.getString(41);
                facture.greffe_sender = dr.getString(42);
                facture.metier_sender = dr.getString(43);
                facture.code_operator = dr.getString(44);
                facture.name_operator = dr.getString(45);
                facture.code_caisse = dr.getString(46);
                facture.ref_ticket = dr.getInt(47);
                facture.info_sender_included = dr.getBoolean(48);
                facture.use_type_in_signature = dr.getBoolean(49);
                facture.round_amount = dr.getBoolean(50);
                facture.tva_6 = dr.getDouble(51);
                facture.tva_12 = dr.getDouble(52);
                facture.tva_21 = dr.getDouble(53);
                facture.tva_8_1 = dr.getDouble(54);
                facture.tva_2_6 = dr.getDouble(55);
                facture.facture_type = dr.getString(56);
                facture.reglement_tva_sender = dr.getString(57);
                facture.canceled_facture_id = dr.getInt(58);
                return facture;
            }
        };
    }

    public String getEntete() {
        return "id, company, name_contact, address, zip_code, city, country, siret, code_NAF, num_tva, ticket, total, dateFacture, Annulee , nb_print, physical_person, signature, numDoc, version_soft, name_soft, num_client, company_sender, adresse_sender, zip_code_sender, city_sender, country_sender, siret_sender, code_NAF_sender, num_tva_sender, forme_juridique_sender, capital_social_sender, RCS_sender, greffe_sender, metier_sender, code_operator, name_operator, code_caisse, ref_ticket, type_operation, use_type_in_signature, round_amount, facture_type, reglement_tva_sender";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("" + this.id);
        builder.append(",");
        builder.append(this.company);
        builder.append(",");
        builder.append(this.name_contact);
        builder.append(",");
        builder.append(this.address);
        builder.append(",");
        builder.append(this.zip_code);
        builder.append(",");
        builder.append(this.city);
        builder.append(",");
        builder.append(this.country);
        builder.append(",");
        builder.append(this.siret);
        builder.append(",");
        builder.append(this.code_NAF);
        builder.append(",");
        builder.append(this.num_tva);
        builder.append(",");
        builder.append(this.ticket);
        builder.append(",");
        builder.append(this.total);
        builder.append(",");
        builder.append(DateUtils.SDF_FULL_DATE_TIME.format(this.dateFacture));
        builder.append(",");
        builder.append(this.cancel);
        builder.append(",");
        builder.append(this.nb_print);
        builder.append(",");
        builder.append(this.physical_person);
        builder.append(",");
        builder.append(this.signature);
        builder.append(",");
        builder.append(this.numDoc);
        builder.append(",");
        builder.append(this.version_soft);
        builder.append(",");
        builder.append(this.name_soft);
        builder.append(",");
        builder.append(this.id_customer);
        builder.append(",");
        builder.append(this.company_sender);
        builder.append(",");
        builder.append(this.address_sender);
        builder.append(",");
        builder.append(this.zip_code_sender);
        builder.append(",");
        builder.append(this.city_sender);
        builder.append(",");
        builder.append(this.country_sender);
        builder.append(",");
        builder.append(this.siret_sender);
        builder.append(",");
        builder.append(this.code_NAF_sender);
        builder.append(",");
        builder.append(this.num_tva_sender);
        builder.append(",");
        builder.append(this.forme_juridique_sender);
        builder.append(",");
        builder.append(this.capital_social_sender);
        builder.append(",");
        builder.append(this.RCS_sender);
        builder.append(",");
        builder.append(this.greffe_sender);
        builder.append(",");
        builder.append(this.metier_sender);
        builder.append(",");
        builder.append(this.code_operator);
        builder.append(",");
        builder.append(this.name_operator);
        builder.append(",");
        builder.append(this.code_caisse);
        builder.append(",");
        builder.append(this.ref_ticket);
        builder.append(",");
        builder.append(this.type_operation);
        builder.append(",");
        builder.append(this.use_type_in_signature);
        builder.append(",");
        builder.append(this.round_amount);
        builder.append(",");
        builder.append(this.facture_type);
        builder.append(",");
        builder.append(this.reglement_tva_sender);
        return builder.toString();
    }

    @Override
    public String getSignature() {
        return this.signature != null && !this.signature.isEmpty() ? this.signature : "";
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getVersion_soft() {
        return this.version_soft;
    }

    public void setVersion_soft(String version_soft) {
        this.version_soft = version_soft;
    }

    public String getName_soft() {
        return this.name_soft;
    }

    public void setName_soft(String name_soft) {
        this.name_soft = name_soft;
    }

    public int getId_customer() {
        return this.id_customer;
    }

    public void setId_customer(int id_customer) {
        this.id_customer = id_customer;
    }

    @Override
    public String getEmprinteWithoutPreviousSignature() {
        int multiply = this.type_operation != null && this.type_operation.equalsIgnoreCase("FACTURE") ? 1 : -1;
        StringBuilder ticketEmprinte = new StringBuilder();
        this.signatureUtils.addTvaToSignature(ticketEmprinte, this.tva5, this.tva10, this.tva20, this.tva0, this.tva_7_7, this.tva_2_5, this.tva_2_1, this.tva_8_5, this.tva_6, this.tva_12, this.tva_21, this.tva_8_1, this.tva_2_6, multiply, this.round_amount);
        ticketEmprinte.append(",").append((long)((double)multiply * this.getAmount(this.total)));
        ticketEmprinte.append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(this.dateFacture));
        ticketEmprinte.append(",").append(this.getId());
        if (this.use_type_in_signature) {
            ticketEmprinte.append(",").append(this.getType_operation().replace(",", "<"));
        }
        if (this.isPhysical_person()) {
            ticketEmprinte.append(",P_").append(this.getName_contact().replace(',', '<'));
            ticketEmprinte.append(",").append(this.getZip_code().replace(",", "<"));
            ticketEmprinte.append(",");
        } else {
            ticketEmprinte.append(",M_").append(this.getCompany().replace(',', '<'));
            ticketEmprinte.append(",").append(this.getZip_code().replace(",", "<"));
            ticketEmprinte.append(",").append(this.getNum_tva().replace(',', '<'));
        }
        return ticketEmprinte.toString();
    }

    @Override
    public String getIdAndTable() {
        return "";
    }

    public String getMsgIntegrityError() {
        return "Facture{ " + this.toString() + " }";
    }

    public void setInfo(EnteteInfo entete) {
        this.setCompany_sender(entete.getCompany());
        this.setAddress_sender(entete.getAddress());
        this.setZip_code_sender(entete.getZipCode());
        this.setCity_sender(entete.getCity());
        this.setCountry_sender(entete.getCountry());
        this.setSiret_sender(entete.getSiret());
        this.setCode_NAF_sender(entete.getCodeNAF());
        this.setNum_tva_sender(entete.getTvaIntra());
        this.setCode_operator(entete.getIdUser());
        this.setRef_ticket(Integer.parseInt(entete.getId()));
    }

    private double getAmount(double amount_value) {
        return this.round_amount ? NumericUtils.round(NumericUtils.round(amount_value) * 100.0) : NumericUtils.round(amount_value) * 100.0;
    }

    public List<LineFacture> getLines() {
        return this.lines;
    }

    public void setLines(List<LineFacture> lines) {
        this.lines = lines;
    }

    public List<RecapTaxFacture> getRecapTaxes() {
        return this.recapTaxes;
    }

    public void setRecapTaxes(List<RecapTaxFacture> recapTaxes) {
        this.recapTaxes = recapTaxes;
    }

    public RecapGeneralFacture getRecapGeneralFacture() {
        return this.recapGeneralFacture;
    }

    public void setRecapGeneralFacture(RecapGeneralFacture recapGeneralFacture) {
        this.recapGeneralFacture = recapGeneralFacture;
    }

    public String getFacture_type() {
        return this.facture_type;
    }

    public void setFacture_type(String facture_type) {
        this.facture_type = facture_type;
    }

    public String getReglement_tva_sender() {
        return this.reglement_tva_sender;
    }

    public void setReglement_tva_sender(String reglement_tva_sender) {
        this.reglement_tva_sender = reglement_tva_sender;
    }

    public int getCanceled_facture_id() {
        return this.canceled_facture_id;
    }

    public void setCanceled_facture_id(int canceled_facture_id) {
        this.canceled_facture_id = canceled_facture_id;
    }
}

