/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.norm.beans;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.SignatureUtils;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.norm.beans.GrandTotalTicket;
import fr.protactile.norm.beans.RecapTaxNote;
import java.util.Date;
import java.util.List;

public class EnteteInfo {
    private String id;
    private String numDoc;
    private String versionSoft;
    private int nbPrint;
    private String company;
    private String address;
    private String zipCode;
    private String city;
    private String country;
    private String siret;
    private String codeNAF;
    private String tvaIntra;
    private String typeOperation;
    private int nb_lines;
    private Date timestampGDH;
    private String ticket;
    private String header;
    private String footr;
    private String statutTicket;
    private String signature;
    private GrandTotalTicket grandTotalTicket;
    private double tva5;
    private double tva10;
    private double tva20;
    private double total;
    private double tva0;
    private double tva_7_7;
    private double tva_2_5;
    private double tva_2_1;
    private double tva_8_5;
    private String code_caisse;
    private String name_soft;
    private String idUser;
    private boolean use_id_in_signature;
    private boolean round_amount;
    private SignatureUtils signatureUtils;
    private double tva_6;
    private double tva_12;
    private double tva_21;
    private List<RecapTaxNote> taxes;
    private boolean has_recap_tax;
    private double tva_8_1;
    private double tva_2_6;
    private String restitution_type;
    private int nb_send_e_ticket;
    private String name_operator;

    public EnteteInfo(String id, String numDoc, String versionSoft, int nbPrint, String company, String address, String zipCode, String city, String country, String siret, String codeNAF, String tvaIntra, Date timestampGDH, String typeOperation, int nb_lines, String ticket, String header, String footer, String statutTicket, String sgnature, String code_caisse, String name_soft, String idUser, boolean use_id_in_signature, boolean round_amount, String restitution_type, int nb_send_e_ticket, String name_operator) {
        this.id = id;
        this.numDoc = numDoc;
        this.versionSoft = versionSoft;
        this.nbPrint = nbPrint;
        this.company = company;
        this.address = address;
        this.zipCode = zipCode;
        this.city = city;
        this.country = country;
        this.siret = siret;
        this.codeNAF = codeNAF;
        this.tvaIntra = tvaIntra;
        this.typeOperation = typeOperation;
        this.nb_lines = nb_lines;
        this.timestampGDH = timestampGDH;
        this.ticket = ticket;
        this.header = header;
        this.footr = footer;
        this.signature = sgnature;
        this.statutTicket = statutTicket;
        this.code_caisse = code_caisse;
        this.name_soft = name_soft;
        this.idUser = idUser;
        this.use_id_in_signature = use_id_in_signature;
        this.round_amount = round_amount;
        this.restitution_type = restitution_type;
        this.nb_send_e_ticket = nb_send_e_ticket;
        this.name_operator = name_operator;
        this.signatureUtils = new SignatureUtils();
    }

    public EnteteInfo(String id, String numDoc, String versionSoft, int nbPrint, String company, String address, String zipCode, String city, String country, String siret, String codeNAF, String tvaIntra, Date timestampGDH, String typeOperation, int nb_lines, String ticket, String header, String footer, String statutTicket, String sgnature, double total, double tva5, double tva10, double tva20, double tva0, double tva_7_7, double tva_2_5, double tva_2_1, double tva_8_5, String code_caisse, String name_soft, String idUser, boolean round_amount, double tva_6, double tva_12, double tva_21, double tva_8_1, double tva_2_6, boolean has_recap_tax, String name_operator) {
        this.id = id;
        this.numDoc = numDoc;
        this.versionSoft = versionSoft;
        this.nbPrint = nbPrint;
        this.company = company;
        this.address = address;
        this.zipCode = zipCode;
        this.city = city;
        this.country = country;
        this.siret = siret;
        this.codeNAF = codeNAF;
        this.tvaIntra = tvaIntra;
        this.typeOperation = typeOperation;
        this.nb_lines = nb_lines;
        this.timestampGDH = timestampGDH;
        this.ticket = ticket;
        this.header = header;
        this.footr = footer;
        this.signature = sgnature;
        this.statutTicket = statutTicket;
        this.total = total;
        this.tva5 = tva5;
        this.tva10 = tva10;
        this.tva20 = tva20;
        this.tva0 = tva0;
        this.tva_7_7 = tva_7_7;
        this.tva_2_5 = tva_2_5;
        this.tva_2_1 = tva_2_1;
        this.tva_8_5 = tva_8_5;
        this.code_caisse = code_caisse;
        this.name_soft = name_soft;
        this.idUser = idUser;
        this.round_amount = round_amount;
        this.signatureUtils = new SignatureUtils();
        this.tva_6 = tva_6;
        this.tva_12 = tva_12;
        this.tva_21 = tva_21;
        this.tva_8_1 = tva_8_1;
        this.tva_2_6 = tva_2_6;
        this.has_recap_tax = has_recap_tax;
        this.name_operator = name_operator;
    }

    public EnteteInfo(String id, String numDoc, String versionSoft, int nbPrint, String company, String address, String zipCode, String city, String country, String siret, String codeNAF, String tvaIntra, Date timestampGDH, String typeOperation, int nb_lines, String ticket, String header, String footer, String statutTicket, String sgnature, String code_caisse, String name_soft, String idUser, boolean use_id_in_signature, boolean round_amount, String restitution_type, int nb_send_e_ticket, String name_operator, GrandTotalTicket grandTotalTicket) {
        this.id = id;
        this.numDoc = numDoc;
        this.versionSoft = versionSoft;
        this.nbPrint = nbPrint;
        this.company = company;
        this.address = address;
        this.zipCode = zipCode;
        this.city = city;
        this.country = country;
        this.siret = siret;
        this.codeNAF = codeNAF;
        this.tvaIntra = tvaIntra;
        this.typeOperation = typeOperation;
        this.nb_lines = nb_lines;
        this.timestampGDH = timestampGDH;
        this.ticket = ticket;
        this.header = header;
        this.footr = footer;
        this.signature = sgnature;
        this.statutTicket = statutTicket;
        this.code_caisse = code_caisse;
        this.name_soft = name_soft;
        this.idUser = idUser;
        this.use_id_in_signature = use_id_in_signature;
        this.grandTotalTicket = grandTotalTicket;
        this.round_amount = round_amount;
        this.restitution_type = restitution_type;
        this.nb_send_e_ticket = nb_send_e_ticket;
        this.signatureUtils = new SignatureUtils();
        this.name_operator = name_operator;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNumDoc() {
        return this.numDoc;
    }

    public void setNumDoc(String numDoc) {
        this.numDoc = numDoc;
    }

    public String getVersionSoft() {
        if (this.versionSoft == null) {
            return "10.0.1.27";
        }
        return this.versionSoft;
    }

    public void setVersionSoft(String versionSoft) {
        this.versionSoft = versionSoft;
    }

    public int getNbPrint() {
        return this.nbPrint;
    }

    public void setNbPrint(int nbPrint) {
        this.nbPrint = nbPrint;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getSiret() {
        return this.siret;
    }

    public void setSiret(String siret) {
        this.siret = siret;
    }

    public String getCodeNAF() {
        return this.codeNAF;
    }

    public void setCodeNAF(String codeNAF) {
        this.codeNAF = codeNAF;
    }

    public String getTvaIntra() {
        return this.tvaIntra;
    }

    public void setTvaIntra(String tvaIntra) {
        this.tvaIntra = tvaIntra;
    }

    public int getNb_lines() {
        return this.nb_lines;
    }

    public void setNb_lines(int nb_lines) {
        this.nb_lines = nb_lines;
    }

    public Date getTimestampGDH() {
        return this.timestampGDH;
    }

    public void setTimestampGDH(Date timestampGDH) {
        this.timestampGDH = timestampGDH;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getTypeOperation() {
        return this.typeOperation;
    }

    public void setTypeOperation(String typeOperation) {
        this.typeOperation = typeOperation;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getFootr() {
        return this.footr;
    }

    public void setFootr(String footr) {
        this.footr = footr;
    }

    public String getIdUser() {
        return this.idUser;
    }

    public void setIdUser(String idUser) {
        this.idUser = idUser;
    }

    public String getCode_caisse() {
        return this.code_caisse;
    }

    public void setCode_caisse(String code_caisse) {
        this.code_caisse = code_caisse;
    }

    public String getName_soft() {
        return this.name_soft;
    }

    public void setName_soft(String name_soft) {
        this.name_soft = name_soft;
    }

    public boolean isUse_id_in_signature() {
        return this.use_id_in_signature;
    }

    public void setUse_id_in_signature(boolean use_id_in_signature) {
        this.use_id_in_signature = use_id_in_signature;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new EnteteInfo(dr.getString(1), dr.getString(2), dr.getString(3), dr.getInt(4), dr.getString(5), dr.getString(6), dr.getString(7), dr.getString(8), dr.getString(9), dr.getString(10), dr.getString(11), dr.getString(12), dr.getTimestamp(13), dr.getString(14), dr.getInt(15), dr.getString(16), dr.getString(17), dr.getString(18), dr.getString(19), dr.getString(20), dr.getString(21), dr.getString(22), dr.getString(23), dr.getBoolean(24), dr.getBoolean(25), dr.getString(26), dr.getInt(27), dr.getString(28));
            }
        };
    }

    public static SerializerRead getSerializerReadWithGrandTotal() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new EnteteInfo(dr.getString(1), dr.getString(2), dr.getString(3), dr.getInt(4), dr.getString(5), dr.getString(6), dr.getString(7), dr.getString(8), dr.getString(9), dr.getString(10), dr.getString(11), dr.getString(12), dr.getTimestamp(13), dr.getString(14), dr.getInt(15), dr.getString(16), dr.getString(17), dr.getString(18), dr.getString(19), dr.getString(20), dr.getString(38), dr.getString(39), dr.getString(40), dr.getBoolean(42), dr.getBoolean(44), dr.getString(51), dr.getInt(52), dr.getString(53), new GrandTotalTicket(dr.getString(21), dr.getString(22), dr.getTimestamp(23), dr.getDouble(24), dr.getDouble(25), dr.getString(26), dr.getDouble(27), dr.getDouble(28), dr.getDouble(29), dr.getString(30), dr.getDouble(31), dr.getDouble(32), dr.getDouble(33), dr.getDouble(34), dr.getDouble(35), dr.getDouble(36), dr.getBoolean(37), dr.getInt(41), dr.getBoolean(43), dr.getBoolean(45), dr.getDouble(46), dr.getDouble(47), dr.getDouble(48), dr.getDouble(49), dr.getDouble(50)));
            }
        };
    }

    public static SerializerRead getSerializerReadNotes() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new EnteteInfo(dr.getString(1), dr.getString(2), dr.getString(3), dr.getInt(4), dr.getString(5), dr.getString(6), dr.getString(7), dr.getString(8), dr.getString(9), dr.getString(10), dr.getString(11), dr.getString(12), dr.getTimestamp(13), dr.getString(14), dr.getInt(15), dr.getString(16), dr.getString(17), dr.getString(18), dr.getString(19), dr.getString(20), dr.getDouble(21), dr.getDouble(22), dr.getDouble(23), dr.getDouble(24), dr.getDouble(25), dr.getDouble(26), dr.getDouble(27), dr.getDouble(28), dr.getDouble(29), dr.getString(30), dr.getString(31), dr.getString(32), dr.getBoolean(33), dr.getDouble(34), dr.getDouble(35), dr.getDouble(36), dr.getDouble(37), dr.getDouble(38), dr.getBoolean(39), dr.getString(40));
            }
        };
    }

    public String getStatutTicket() {
        return this.statutTicket;
    }

    public void setStatutTicket(String statutTicket) {
        this.statutTicket = statutTicket;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public GrandTotalTicket getGrandTotalTicket() {
        return this.grandTotalTicket;
    }

    public String getEmprinteWithoutPreviousSignature() {
        double tva5 = this.grandTotalTicket.getTva5();
        double tva10 = this.grandTotalTicket.getTva10();
        double tva20 = this.grandTotalTicket.getTva20();
        double tva0 = this.grandTotalTicket.getTva0();
        double tva_7_7 = this.grandTotalTicket.getTva_7_7();
        double tva_2_5 = this.grandTotalTicket.getTva_2_5();
        double tva_2_1 = this.grandTotalTicket.getTva_2_1();
        double tva_8_5 = this.grandTotalTicket.getTva_8_5();
        double tva_6 = this.grandTotalTicket.getTva_6();
        double tva_12 = this.grandTotalTicket.getTva_12();
        double tva_21 = this.grandTotalTicket.getTva_21();
        double tva_8_1 = this.grandTotalTicket.getTva_8_1();
        double tva_2_6 = this.grandTotalTicket.getTva_2_6();
        StringBuilder ticketEmprinte = new StringBuilder();
        this.addTVAtoSignature(ticketEmprinte, tva5, tva10, tva20, tva0, tva_7_7, tva_2_5, tva_2_1, tva_8_5, tva_6, tva_12, tva_21, tva_8_1, tva_2_6);
        ticketEmprinte.append(",").append((long)this.getAmount(this.grandTotalTicket.getCumul()));
        ticketEmprinte.append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(this.getTimestampGDH()));
        if (this.use_id_in_signature) {
            ticketEmprinte.append(",").append(this.id);
        } else {
            ticketEmprinte.append(",").append(this.numDoc);
        }
        ticketEmprinte.append(",").append(this.typeOperation);
        return ticketEmprinte.toString();
    }

    public String getObjectAsString() {
        return "Ticket{id=" + this.id + ", numDoc=" + this.numDoc + ", versionSoft=" + this.versionSoft + ", nbPrint=" + this.nbPrint + ", company=" + this.company + ", address=" + this.address + ", zipCode=" + this.zipCode + ", city=" + this.city + ", country=" + this.country + ", siret=" + this.siret + ", codeNAF=" + this.codeNAF + ", tvaIntra=" + this.tvaIntra + ", typeOperation=" + this.typeOperation + ", nb_lines=" + this.nb_lines + ", timestampGDH=" + this.timestampGDH + ", ticket=" + this.ticket + ", header=" + this.header + ", footr=" + this.footr + ", statutTicket=" + this.statutTicket + ", signature=" + this.signature + ", grandTotalTicket=" + this.grandTotalTicket + "}";
    }

    public String getObjectNoteAsString() {
        return "Note{id=" + this.id + ", numDoc=" + this.numDoc + ", versionSoft=" + this.versionSoft + ", nbPrint=" + this.nbPrint + ", company=" + this.company + ", address=" + this.address + ", zipCode=" + this.zipCode + ", city=" + this.city + ", country=" + this.country + ", siret=" + this.siret + ", codeNAF=" + this.codeNAF + ", tvaIntra=" + this.tvaIntra + ", typeOperation=" + this.typeOperation + ", nb_lines=" + this.nb_lines + ", timestampGDH=" + this.timestampGDH + ", ticket=" + this.ticket + ", header=" + this.header + ", footr=" + this.footr + ", statutTicket=" + this.statutTicket + ", signature=" + this.signature + ", grandTotalTicket=" + this.grandTotalTicket + "}";
    }

    public String getMsgIntegrityError() {
        return "Ticket { id: " + this.id + ", numDoc:" + this.numDoc + ", versionSoft :" + this.versionSoft + ", nbPrint :" + this.nbPrint + ", company :" + this.company + ", siret :" + this.siret + ", tvaIntra :" + this.tvaIntra + ", typeOperation :" + this.typeOperation + ", nb_lines : " + this.nb_lines + ", Horodatage=" + this.timestampGDH + ", ID_TICKET=" + this.ticket + ", statutTicket=" + this.statutTicket + ", signature=" + this.signature + ", grandTotalTicket_ID :" + this.grandTotalTicket != null ? this.grandTotalTicket.getId() : "}";
    }

    public String toString() {
        return this.id + "," + this.numDoc + "," + this.versionSoft + "," + this.nbPrint + "," + this.company + "," + this.address + "," + this.zipCode + "," + this.city + "," + this.country + "," + this.siret + "," + this.codeNAF + "," + this.tvaIntra + "," + this.typeOperation + "," + this.nb_lines + "," + DateUtils.SDF_FULL_DATE_TIME.format(this.timestampGDH) + "," + this.ticket + "," + this.header + "," + this.footr + "," + this.statutTicket + "," + this.signature + "," + this.code_caisse + "," + this.name_soft + "," + this.use_id_in_signature + "," + this.round_amount + "," + this.restitution_type + "," + this.nb_send_e_ticket + "," + this.idUser + "," + this.name_operator;
    }

    public static String getEntete() {
        return "id, numDoc, versionSoft, nbPrint, company, address, zipCode, city, country, siret, codeNAF, tvaIntra, typeOperation, nb_lines, timestampGDH, ticket, header, footr, statutTicket, signature, code_caisse, nom_logiciel, use_id_in_signature, round_amount,restitution_type,nb_send_e_ticket,code_operator, name_operator";
    }

    public String getEmprinteNoteWithoutPreviousSignature() {
        StringBuilder ticketEmprinte = new StringBuilder();
        this.addTVAtoSignature(ticketEmprinte, this.tva5, this.tva10, this.tva20, this.tva0, this.tva_7_7, this.tva_2_5, this.tva_2_1, this.tva_8_5, this.tva_6, this.tva_12, this.tva_21, this.tva_8_1, this.tva_2_6);
        ticketEmprinte.append(",").append((long)this.getAmount(this.total));
        ticketEmprinte.append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(this.getTimestampGDH()));
        ticketEmprinte.append(",").append(this.id);
        ticketEmprinte.append(",").append(this.typeOperation);
        return ticketEmprinte.toString();
    }

    private void addTVAtoSignature(StringBuilder ticketEmprinte, double tva5, double tva10, double tva20, double tva0, double tva_7_7, double tva_2_5, double tva_2_1, double tva_8_5, double tva_6, double tva_12, double tva_21, double tva_8_1, double tva_2_6) {
        this.signatureUtils.addTvaToSignature(ticketEmprinte, tva5, tva10, tva20, tva0, tva_7_7, tva_2_5, tva_2_1, tva_8_5, tva_6, tva_12, tva_21, tva_8_1, tva_2_6, this.round_amount);
    }

    private double getAmount(double amount_value) {
        return this.round_amount ? NumericUtils.round(NumericUtils.round(amount_value) * 100.0) : NumericUtils.round(amount_value) * 100.0;
    }

    public static String getEnteteNote() {
        return "id, numDoc, versionSoft, nbPrint, company, address, zipCode, city, country, siret, codeNAF, tvaIntra, typeOperation, nb_lines, timestampGDH, ticket, header, footr, statutTicket, signature, code_caisse, nom_logiciel, use_id_in_signature, total, tva5, tva10, tva20, tva0, tva_7_7, tva_2_5, tva_2_1, tva_8_5, round_amount, tva_6, tva_12, tva_21, tva_8_1, tva_2_6, code_operator, name_operator";
    }

    public String toStringNote() {
        return this.id + "," + this.numDoc + "," + this.versionSoft + "," + this.nbPrint + "," + this.company + "," + this.address + "," + this.zipCode + "," + this.city + "," + this.country + "," + this.siret + "," + this.codeNAF + "," + this.tvaIntra + "," + this.typeOperation + "," + this.nb_lines + "," + DateUtils.SDF_FULL_DATE_TIME.format(this.timestampGDH) + "," + this.ticket + "," + this.header + "," + this.footr + "," + this.statutTicket + "," + this.signature + "," + this.code_caisse + "," + this.name_soft + "," + this.use_id_in_signature + "," + this.total + "," + this.tva5 + "," + this.tva10 + "," + this.tva20 + "," + this.tva0 + "," + this.tva_7_7 + "," + this.tva_2_5 + "," + this.tva_2_1 + "," + this.tva_8_5 + "," + this.round_amount + "," + this.tva_6 + "," + this.tva_12 + "," + this.tva_21 + "," + this.tva_8_1 + "," + this.tva_2_6 + "," + this.idUser + "," + this.name_operator;
    }

    public boolean isHas_recap_tax() {
        return this.has_recap_tax;
    }

    public void setHas_recap_tax(boolean has_recap_tax) {
        this.has_recap_tax = has_recap_tax;
    }

    public void setRecapTaxNote(List<RecapTaxNote> taxes) {
        this.taxes = taxes;
        for (RecapTaxNote taxe : taxes) {
            if (taxe.getRateTax() == 0.055) {
                this.tva5 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() == 0.1) {
                this.tva10 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() == 0.2) {
                this.tva20 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() == 0.0) {
                this.tva0 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() == 0.077) {
                this.tva_7_7 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() == 0.025) {
                this.tva_2_5 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() == 0.021) {
                this.tva_2_1 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() == 0.085) {
                this.tva_8_5 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() == 0.06) {
                this.tva_6 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() == 0.12) {
                this.tva_12 = taxe.getTatlTTC();
                continue;
            }
            if (taxe.getRateTax() != 0.21) continue;
            this.tva_21 = taxe.getTatlTTC();
        }
    }

    public String getRestitution_type() {
        return this.restitution_type;
    }

    public void setRestitution_type(String restitution_type) {
        this.restitution_type = restitution_type;
    }

    public int getNb_send_e_ticket() {
        return this.nb_send_e_ticket;
    }

    public void setNb_send_e_ticket(int nb_send_e_ticket) {
        this.nb_send_e_ticket = nb_send_e_ticket;
    }

    public boolean IsTicketRestituted() {
        return this.nbPrint > 0 && (this.restitution_type == null || this.restitution_type.equalsIgnoreCase("impression papier")) || this.nb_send_e_ticket > 0 && this.restitution_type != null && this.restitution_type.equalsIgnoreCase("e-ticket");
    }
}

