/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.norm.beans;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.NumericUtils;
import com.procaisse.db.metadata.DataRead;
import java.util.Date;

public class ArchivPeriode {
    private String id;
    private double cumul;
    private double cumulPerpetual;
    private double tva5;
    private double tva10;
    private double tva20;
    private String signature;
    private String typePeriode;
    private Date timestampGDH;
    private String chemin;
    private double tva0;
    private double tva_7_7;
    private double tva_2_5;
    private double tva_2_1;
    private double tva_8_5;
    private boolean round_amount;
    private double tva_6;
    private double tva_12;
    private double tva_21;
    private double tva_8_1;
    private double tva_2_6;

    public String getTypePeriode() {
        return this.typePeriode;
    }

    public void setTypePeriode(String typePeriode) {
        this.typePeriode = typePeriode;
    }

    public Date getTimestampGDH() {
        return this.timestampGDH;
    }

    public void setTimestampGDH(Date timestampGDH) {
        this.timestampGDH = timestampGDH;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public ArchivPeriode(String id, double cumul, double cumulPerpetual, double tva5, double tva10, double tva20, String signature, String typePeriode, Date timestampGDH, String chemin, double tva0, double tva_7_7, double tva_2_5, double tva_2_1, double tva_8_5, boolean round_amount, double tva_6, double tva_12, double tva_21, double tva_8_1, double tva_2_6) {
        this.id = id;
        this.cumul = cumul;
        this.cumulPerpetual = cumulPerpetual;
        this.tva5 = tva5;
        this.tva10 = tva10;
        this.tva20 = tva20;
        this.signature = signature;
        this.typePeriode = typePeriode;
        this.timestampGDH = timestampGDH;
        this.chemin = chemin;
        this.tva0 = tva0;
        this.tva_7_7 = tva_7_7;
        this.tva_2_5 = tva_2_5;
        this.tva_2_1 = tva_2_1;
        this.tva_8_5 = tva_8_5;
        this.round_amount = round_amount;
        this.tva_6 = tva_6;
        this.tva_12 = tva_12;
        this.tva_21 = tva_21;
        this.tva_8_1 = tva_8_1;
        this.tva_2_6 = tva_2_6;
    }

    public ArchivPeriode() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getCumul() {
        return this.cumul;
    }

    public void setCumul(double cumul) {
        this.cumul = cumul;
    }

    public double getCumulPerpetual() {
        return this.cumulPerpetual;
    }

    public void setCumulPerpetual(double cumulPerpetual) {
        this.cumulPerpetual = cumulPerpetual;
    }

    public double getTva5() {
        return this.tva5;
    }

    public void setTva5(double tva5) {
        this.tva5 = tva5;
    }

    public double getTva10() {
        return this.tva10;
    }

    public void setTva10(double tva10) {
        this.tva10 = tva10;
    }

    public double getTva20() {
        return this.tva20;
    }

    public void setTva20(double tva20) {
        this.tva20 = tva20;
    }

    public double getTva0() {
        return this.tva0;
    }

    public void setTva0(double tva0) {
        this.tva0 = tva0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.id);
        builder.append(",");
        builder.append(this.cumul);
        builder.append(",");
        builder.append(this.cumulPerpetual);
        builder.append(",");
        builder.append(this.tva5);
        builder.append(",");
        builder.append(this.tva10);
        builder.append(",");
        builder.append(this.tva20);
        builder.append(",");
        builder.append(this.typePeriode);
        builder.append(",");
        builder.append(this.chemin);
        builder.append(",");
        builder.append(this.signature);
        builder.append(",");
        builder.append(this.timestampGDH);
        builder.append(",");
        builder.append(this.tva0);
        builder.append(",");
        builder.append(this.tva_7_7);
        builder.append(",");
        builder.append(this.tva_2_5);
        builder.append(",");
        builder.append(this.tva_2_1);
        builder.append(",");
        builder.append(this.tva_6);
        builder.append(",");
        builder.append(this.tva_12);
        builder.append(",");
        builder.append(this.tva_21);
        builder.append(",");
        builder.append(this.tva_8_5);
        builder.append(",");
        builder.append(this.tva_2_6);
        return builder.toString();
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new ArchivPeriode(dr.getString(1), dr.getDouble(2), dr.getDouble(3), dr.getDouble(4), dr.getDouble(5), dr.getDouble(6), dr.getString(7), dr.getString(8), dr.getTimestamp(9), dr.getString(10), dr.getDouble(11), dr.getDouble(12), dr.getDouble(13), dr.getDouble(14), dr.getDouble(15), dr.getBoolean(16), dr.getDouble(17), dr.getDouble(18), dr.getDouble(19), dr.getDouble(20), dr.getDouble(21));
            }
        };
    }

    public String getEmprinteWithoutPreviousSignature() {
        StringBuilder builderEmprinteArchivPeriode = new StringBuilder();
        String spliter = "";
        if (this.tva5 != 0.0) {
            builderEmprinteArchivPeriode.append("0550:").append((long)this.getAmount(this.tva5));
            spliter = "|";
        }
        if (this.tva10 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("1000:").append((long)this.getAmount(this.tva10));
            spliter = "|";
        }
        if (this.tva20 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("2000:").append((long)this.getAmount(this.tva20));
            spliter = "|";
        }
        if (this.tva0 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("0000:").append((long)this.getAmount(this.tva0));
            spliter = "|";
        }
        if (this.tva_7_7 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("0770:").append((long)this.getAmount(this.tva_7_7));
            spliter = "|";
        }
        if (this.tva_2_5 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("0250:").append((long)this.getAmount(this.tva_2_5));
            spliter = "|";
        }
        if (this.tva_2_1 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("0210:").append((long)this.getAmount(this.tva_2_1));
            spliter = "|";
        }
        if (this.tva_8_5 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("0850:").append((long)this.getAmount(this.tva_8_5));
            spliter = "|";
        }
        if (this.tva_6 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("0600:").append((long)this.getAmount(this.tva_6));
            spliter = "|";
        }
        if (this.tva_12 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("1200:").append((long)this.getAmount(this.tva_12));
            spliter = "|";
        }
        if (this.tva_21 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("2100:").append((long)this.getAmount(this.tva_21));
        }
        if (this.tva_8_1 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("0810:").append((long)this.getAmount(this.tva_8_1));
        }
        if (this.tva_2_6 != 0.0) {
            builderEmprinteArchivPeriode.append(spliter).append("0260:").append((long)this.getAmount(this.tva_2_6));
        }
        builderEmprinteArchivPeriode.append(",").append((long)this.getAmount(this.cumul)).append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(this.timestampGDH)).append(",").append("archivage");
        return builderEmprinteArchivPeriode.toString();
    }

    public String getMsgIntegrityError() {
        return "Archive { " + this.toString() + " }";
    }

    private double getAmount(double amount_value) {
        return this.round_amount ? NumericUtils.round(NumericUtils.round(amount_value) * 100.0) : NumericUtils.round(amount_value) * 100.0;
    }

    public double getTva_7_7() {
        return this.tva_7_7;
    }

    public void setTva_7_7(double tva_7_7) {
        this.tva_7_7 = tva_7_7;
    }

    public double getTva_2_5() {
        return this.tva_2_5;
    }

    public void setTva_2_5(double tva_2_5) {
        this.tva_2_5 = tva_2_5;
    }

    public double getTva_2_1() {
        return this.tva_2_1;
    }

    public void setTva_2_1(double tva_2_1) {
        this.tva_2_1 = tva_2_1;
    }

    public double getTva_8_5() {
        return this.tva_8_5;
    }

    public void setTva_8_5(double tva_8_5) {
        this.tva_8_5 = tva_8_5;
    }

    public double getTva_6() {
        return this.tva_6;
    }

    public void setTva_6(double tva_6) {
        this.tva_6 = tva_6;
    }

    public double getTva_12() {
        return this.tva_12;
    }

    public void setTva_12(double tva_12) {
        this.tva_12 = tva_12;
    }

    public double getTva_21() {
        return this.tva_21;
    }

    public void setTva_21(double tva_21) {
        this.tva_21 = tva_21;
    }

    public double getTva_8_1() {
        return this.tva_8_1;
    }

    public void setTva_8_1(double tva_8_1) {
        this.tva_8_1 = tva_8_1;
    }

    public double getTva_2_6() {
        return this.tva_2_6;
    }

    public void setTva_2_6(double tva_2_6) {
        this.tva_2_6 = tva_2_6;
    }
}

