/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.services;

import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.RecapSharedSales;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.kitchen.dao.entities.Itemsticket;
import fr.protactile.kitchen.dao.entities.Optionsticket;
import fr.protactile.kitchen.dao.entities.Payments;
import fr.protactile.kitchen.dao.entities.Ticketlines;
import fr.protactile.kitchen.dao.entities.Tickets;
import fr.protactile.kitchen.dao.impl.ItemTicketDao;
import fr.protactile.kitchen.dao.impl.OptionTicketDao;
import fr.protactile.kitchen.dao.impl.PaymentsDao;
import fr.protactile.kitchen.dao.impl.TicketDao;
import fr.protactile.kitchen.dao.impl.TicketLinesDao;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class TicketSharedService {
    private static TicketSharedService m_instance;
    private TicketDao ticketDao = new TicketDao();
    private TicketLinesDao ticketLineDao = new TicketLinesDao();
    private OptionTicketDao optionTicketDao = new OptionTicketDao();
    private ItemTicketDao itemTicketDao = new ItemTicketDao();
    private int length_barcode = 14;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private PaymentsDao mPaymentsDao = new PaymentsDao();

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    private TicketSharedService() {
    }

    public static TicketSharedService getInstance() {
        try {
            if (m_instance == null) {
                m_instance = new TicketSharedService();
            }
            return m_instance;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int sendOrder(Tickets order, int NumberCall) {
        return this.sendOrder(order, NumberCall, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendOrder(Tickets order, int NumberCall, boolean refresh_suivi_orders) {
        int id_order = -1;
        if (this.ticketDao.getCurrentSession() != null) {
            this.ticketDao.openSession();
            Transaction tx = null;
            try {
                tx = this.ticketDao.getCurrentSession().beginTransaction();
                if (order.getPaymentsCollection() != null) {
                    order.getPaymentsCollection().clear();
                }
                ArrayList<Ticketlines> ticketLines = new ArrayList<Ticketlines>();
                if (order.getTicketlinesCollection() != null) {
                    for (Ticketlines line : order.getTicketlinesCollection()) {
                        ticketLines.add((Ticketlines)line.clone());
                    }
                    order.getTicketlinesCollection().clear();
                }
                order.setError_print_kitchen(AppLocal.ERROR_PRINT_KITCHEN && AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Borne"));
                order.setUpdatedAt(new Date());
                order.setCanceled(false);
                this.ticketDao.save(order);
                this.buildBarCode(order);
                this.ticketDao.merge(order);
                for (Ticketlines line : ticketLines) {
                    ArrayList<Optionsticket> options = new ArrayList<Optionsticket>();
                    if (line.getOptionsticketCollection() != null) {
                        for (Optionsticket option : line.getOptionsticketCollection()) {
                            options.add((Optionsticket)option.clone());
                        }
                        line.getOptionsticketCollection().clear();
                    }
                    ArrayList<Itemsticket> items = new ArrayList<Itemsticket>();
                    if (line.getItemsticketCollection() != null) {
                        for (Itemsticket item : line.getItemsticketCollection()) {
                            items.add((Itemsticket)item.clone());
                        }
                        line.getItemsticketCollection().clear();
                    }
                    line.setIdTicket(order);
                    this.ticketLineDao.save(line);
                    for (Optionsticket option : options) {
                        option.setIdLine(line);
                        this.optionTicketDao.save(option);
                    }
                    for (Itemsticket item : items) {
                        item.setIdLine(line);
                        this.itemTicketDao.save(item);
                    }
                }
                id_order = order.getId();
                tx.commit();
            }
            catch (Exception e) {
                LogToFile.log("severe", e.getMessage(), e);
                if (tx != null) {
                    tx.rollback();
                }
                if (NumberCall == 0) {
                    int n = id_order;
                    return n;
                }
                int n = this.sendOrder(order, --NumberCall);
                return n;
            }
            finally {
                this.ticketDao.close();
                if (refresh_suivi_orders) {
                    Platform.runLater(() -> this.support.firePropertyChange("orders", null, null));
                }
            }
        }
        return id_order;
    }

    public Tickets getOrderByBarCode(String barCode) {
        try {
            Tickets ticket = this.ticketDao.getOrderByBarCode(barCode);
            if (ticket != null) {
                for (Ticketlines line : ticket.getTicketlinesCollection()) {
                    line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
                }
                return ticket;
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
            return null;
        }
        return null;
    }

    public Tickets getOrderById(int id) {
        try {
            Tickets ticket = this.ticketDao.getOrderById(id);
            if (ticket != null) {
                for (Ticketlines line : ticket.getTicketlinesCollection()) {
                    line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
                }
                return ticket;
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
            return null;
        }
        return null;
    }

    private void buildBarCode(Tickets order) {
        String text_id_order = String.valueOf(order.getId());
        long currentTimeStamp = System.currentTimeMillis();
        String text_timeStamp = String.valueOf(currentTimeStamp);
        int number_digit = this.length_barcode - text_id_order.length();
        Object second_text = null;
        if (number_digit < text_timeStamp.length()) {
            second_text = text_timeStamp.substring(0, number_digit);
        } else {
            int diff = number_digit - text_timeStamp.length();
            second_text = text_timeStamp;
            for (int i = 0; i < diff; ++i) {
                second_text = (String)second_text + "0";
            }
        }
        String barcode = text_id_order + (String)second_text;
        order.setBarcode(barcode);
    }

    public List<Tickets> getOrders(String source_order, Date date_start, Date date_end) {
        return this.getOrders(source_order, null, date_start, date_end);
    }

    public List<Tickets> getOrders(String type_order) {
        return this.getOrders(type_order, null, null, null);
    }

    public List<Tickets> getOrders(String type_order, String type_payment, Date date_start, Date date_end) {
        List<Tickets> orders = new ArrayList<Tickets>();
        try {
            switch (type_order) {
                case "borne_cb_order": {
                    orders = this.ticketDao.getOrders("borne", type_payment, date_start, date_end);
                    break;
                }
                case "borne_order": {
                    orders = this.ticketDao.getOrders("borne", date_start, date_end);
                    break;
                }
                case "tabletto": {
                    orders = this.ticketDao.getOrders("Tabletto");
                }
            }
            if (orders != null) {
                for (Tickets order : orders) {
                    System.out.println("++++++++++++++order_base" + order.getOrder_id_base());
                    System.out.println("++++++++++++++getKeenio_base" + order.getKeenio_base());
                    for (Ticketlines line : order.getTicketlinesCollection()) {
                        line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return orders;
    }

    public void saveOrder(int id_order) {
        try {
            this.ticketDao.saveOrder(id_order);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void deleteOrderTabletto() {
        if (this.ticketDao.getCurrentSession() != null) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -3);
            System.out.println("cal time : " + cal.getTime());
            this.optionTicketDao.deleteOldSupplement(cal.getTime());
            this.itemTicketDao.deleteOldItems(cal.getTime());
            this.ticketLineDao.deleteOldLines(cal.getTime());
            this.ticketDao.deleteOldOrders(cal.getTime());
        }
    }

    public void deleteAllOrderTableltto() {
        this.optionTicketDao.deleteAllSupplement();
        this.itemTicketDao.deleteAllItems();
        this.ticketLineDao.deleteOAllLines();
        this.ticketDao.deleteAllOrders();
    }

    public List<Tickets> getOrdersByDevice(String name_device) {
        List<Tickets> orders = this.ticketDao.getOrdersByDevice(name_device);
        if (orders != null) {
            for (Tickets order : orders) {
                for (Ticketlines line : order.getTicketlinesCollection()) {
                    line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
                }
            }
        }
        return orders;
    }

    public void updateOrder(Tickets order) {
        try {
            this.updateOrder(order, false);
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrder(Tickets order, boolean refresh_order) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.ticketDao.getSessionFactory().getCurrentSession();
            tx = session.beginTransaction();
            Tickets old_order = (Tickets)session.find(Tickets.class, (Object)order.getId());
            session.clear();
            if (old_order != null && !old_order.getPaid()) {
                if (order.getTicketlinesCollection() != null) {
                    for (Ticketlines line : order.getTicketlinesCollection()) {
                        line.setIdTicket(order);
                        for (Optionsticket optionsticket : line.getOptionsticketCollection()) {
                            optionsticket.setIdLine(line);
                        }
                        for (Itemsticket itemsticket : line.getItemsticketCollection()) {
                            itemsticket.setIdLine(line);
                        }
                    }
                }
                order.setNum_order_kitchen(old_order.getNum_order_kitchen());
                order.setId_order_kitchen(old_order.getId_order_kitchen());
                order.setHostName(old_order.getHostName());
                order.setUser(old_order.getUser());
                order.setSourceOrder(old_order.getSourceOrder());
                order.setUpdatedAt(new Date());
                order.setBarcode(old_order.getBarcode());
                order.setCreated(old_order.getCreated());
                int id_customer_avomark = order.getAvomarkCustomer();
                order.setAvomarkCustomer(id_customer_avomark != 0 ? id_customer_avomark : old_order.getAvomarkCustomer());
                session.clear();
                session.merge((Object)order);
            }
            tx.commit();
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
            if (tx != null) {
                tx.rollback();
            }
            tx.rollback();
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (refresh_order) {
                Platform.runLater(() -> this.support.firePropertyChange("orders", null, null));
            }
        }
    }

    public void cancelOrder(int idOrder, String reason_cancel, boolean check_paid) {
        if (reason_cancel != null) {
            this.ticketDao.cancelOrder(idOrder, reason_cancel, check_paid);
        } else {
            this.ticketDao.cancelOrder(idOrder, check_paid);
        }
    }

    public void encaisserOrder(int id_order) {
        try {
            this.ticketDao.encaisserOrder(id_order, AppLocal.source_order);
            this.ticketLineDao.paidAllTicketLine(id_order);
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public Date lastUpdateAt() {
        return this.ticketDao.getLastUpdatedOrderDate();
    }

    public List<Tickets> getOrdersCanceledByDevice(String name_device) {
        List<Tickets> orders = this.ticketDao.getOrdersCanceledByDevice(name_device);
        for (Tickets order : orders) {
            for (Ticketlines line : order.getTicketlinesCollection()) {
                line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
            }
        }
        return orders;
    }

    public List<Tickets> getOrdersToVerifyByDevice(String name_device) {
        List<Tickets> orders = this.ticketDao.getOrdersToVerifyByDevice(name_device);
        for (Tickets order : orders) {
            for (Ticketlines line : order.getTicketlinesCollection()) {
                line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
            }
        }
        return orders;
    }

    public void verifyOrder(List<Tickets> tickets) {
        for (Tickets ticket : tickets) {
            this.ticketDao.verifyOrder(ticket.getId());
        }
    }

    public void paidTicketLine(int id_line, double unit_paid) {
        this.ticketLineDao.paidTicketLine(id_line, unit_paid);
    }

    public void validPrintOrder(int id_order) {
        this.ticketDao.validPrintOrder(id_order);
    }

    public List<Tickets> getOrderPrintError() {
        List<Tickets> orders = null;
        try {
            orders = this.ticketDao.getOrderPrintError();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return orders;
    }

    public void saveOrders(List<Integer> ids_order) {
        ids_order.forEach(id_order -> this.ticketDao.saveOrder((int)id_order));
    }

    public void cancelOrderWithRefresh(int idOrder, String reason_cancel) {
        this.cancelOrder(idOrder, reason_cancel);
        Platform.runLater(() -> this.support.firePropertyChange("orders", null, null));
    }

    public List<Tickets> getPendingOrders() {
        return this.ticketDao.getPendingOrders();
    }

    public void paidSharedOrder(int id_order, String hostName) {
        this.ticketDao.paidSharedOrder(id_order, hostName);
    }

    public void changeTable(int id_order, int num_table) {
        this.ticketDao.changeTable(id_order, num_table);
    }

    public List<Tickets> getOrders(String source_order, String host_name) {
        ArrayList<Tickets> orders = new ArrayList();
        try {
            orders = this.ticketDao.getOrdersByHostName(source_order, host_name);
            if (orders != null) {
                for (Tickets order : orders) {
                    for (Ticketlines line : order.getTicketlinesCollection()) {
                        line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return orders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPayments(Tickets order, List<Payments> payments) {
        if (this.mPaymentsDao.getCurrentSession() != null) {
            this.mPaymentsDao.openSession();
            Transaction tx = null;
            try {
                tx = this.mPaymentsDao.getCurrentSession().beginTransaction();
                for (Payments payment : payments) {
                    payment.setIdTicket(order);
                    this.mPaymentsDao.save(payment);
                }
                tx.commit();
            }
            catch (Exception e) {
                LogToFile.log("severe", e.getMessage(), e);
                if (tx != null) {
                    tx.rollback();
                }
            }
            finally {
                this.mPaymentsDao.close();
            }
        }
    }

    public void deletePayments(Tickets order) {
        try {
            this.mPaymentsDao.deletePayments(order.getId());
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public Object[] getTicketZ(Date date_open, Date dateClose) {
        Object[] results = new Object[11];
        int nb_CB = 0;
        int nb_TR = 0;
        Double caNet = this.ticketDao.getCA(date_open, dateClose);
        List<PaymentLine> payments = this.mPaymentsDao.loadPayment(date_open, dateClose);
        for (PaymentLine payment : payments) {
            if (payment.getM_PaymentType().equalsIgnoreCase("CB")) {
                nb_CB = payment.getNombre();
            }
            if (!payment.getM_PaymentType().equalsIgnoreCase("Ticket Resto")) continue;
            nb_TR = payment.getNombre();
        }
        Double caCanceled = this.ticketDao.getCACanceled(date_open, dateClose);
        Long m_iSales = this.ticketDao.getNbOrder(date_open, dateClose);
        List<UserCaisseInfo> users = this.ticketDao.getUsers(date_open, dateClose);
        List<RankTypeOrder> typeOrders = this.ticketDao.getTypesOrders(date_open, dateClose);
        HashMap<String, Double> turnoverByHostName = this.ticketDao.getCAByHostName(date_open, dateClose);
        Double totalDiscountPercentage = this.ticketDao.getTotalDiscountOrderOfType(date_open, dateClose, "pourcentage");
        Double totalDiscountAmount = this.ticketDao.getTotalDiscountOrderOfType(date_open, dateClose, "somme");
        Double totalDiscountOnLines = this.ticketDao.getTotalDiscountOnTicketLines(date_open, dateClose);
        double totalDiscount = (totalDiscountPercentage != null ? totalDiscountPercentage : 0.0) + (totalDiscountAmount != null ? totalDiscountAmount : 0.0);
        results[0] = caNet != null ? caNet : 0.0;
        results[1] = payments;
        results[2] = caCanceled != null ? caCanceled : 0.0;
        results[3] = m_iSales != null ? m_iSales : 0L;
        results[4] = users;
        results[5] = typeOrders;
        results[6] = nb_CB;
        results[7] = nb_TR;
        results[8] = turnoverByHostName;
        results[9] = totalDiscount;
        results[10] = totalDiscountOnLines != null ? totalDiscountOnLines : 0.0;
        return results;
    }

    public double getNumberProductOrderd(Integer id_product, Date date_start) {
        Double numberProductOrdered = this.ticketDao.getNumberProductOrderd(id_product, date_start);
        return numberProductOrdered != null ? numberProductOrdered : 0.0;
    }

    public void deleteOrders(List<Integer> ids_tickets_to_delete) {
        if (this.ticketDao.getCurrentSession() != null) {
            for (Integer idTicket : ids_tickets_to_delete) {
                this.optionTicketDao.deleteSupplements(idTicket);
                this.itemTicketDao.deleteItems(idTicket);
                this.ticketLineDao.deleteLines(idTicket);
                this.ticketDao.deleteOrders(idTicket);
            }
        }
    }

    public List<Tickets> getExteriorOrders(String typeOrder, Date date_start, Date date_end) {
        ArrayList<Tickets> orders = new ArrayList();
        try {
            orders = this.ticketDao.getExteriorOrders(typeOrder, date_start, date_end);
            if (orders != null) {
                for (Tickets order : orders) {
                    for (Ticketlines line : order.getTicketlinesCollection()) {
                        line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return orders;
    }

    public List<Tickets> getAllOrders(Date date_start, Date date_end) {
        List<Object> orders = new ArrayList();
        orders = this.ticketDao.getAllOrders(date_start, date_end);
        if (orders != null) {
            for (Tickets tickets : orders) {
                for (Ticketlines line : tickets.getTicketlinesCollection()) {
                    line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
                }
                tickets.setPaymentsCollection(this.mPaymentsDao.getTicketPaymentS(tickets.getId()));
            }
        }
        return orders;
    }

    public List<RecapSharedSales> getRecapSharedSales(int month, int year) {
        ArrayList<RecapSharedSales> recapsSharedSaleses = new ArrayList<RecapSharedSales>();
        Date dateStart = new Date();
        dateStart.setMinutes(0);
        dateStart.setMinutes(0);
        dateStart.setHours(6);
        dateStart.setDate(1);
        dateStart.setMonth(month - 1);
        dateStart.setYear(year - 1900);
        Date dateEnd = new Date();
        dateEnd.setMinutes(59);
        dateEnd.setHours(5);
        dateEnd.setDate(dateStart.getDate() + 1);
        dateEnd.setMonth(month - 1);
        dateEnd.setYear(year - 1900);
        Calendar calendarStart = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        Date dateNow = new Date();
        for (int i = 0; i < 31 && dateStart.getMonth() == month - 1 && !dateStart.after(dateNow); ++i) {
            Double turnover = this.ticketDao.getCA(dateStart, dateEnd);
            List<PaymentLine> payments = this.mPaymentsDao.loadPayment(dateStart, dateEnd);
            Double caCanceled = this.ticketDao.getCACanceled(dateStart, dateEnd);
            Long m_iSales = this.ticketDao.getNbOrder(dateStart, dateEnd);
            List<UserCaisseInfo> users = this.ticketDao.getUsers(dateStart, dateEnd);
            List<RankTypeOrder> typeOrders = this.ticketDao.getTypesOrders(dateStart, dateEnd);
            HashMap<String, Double> turnoverByHostName = this.ticketDao.getCAByHostName(dateStart, dateEnd);
            Double totalDiscountPercentage = this.ticketDao.getTotalDiscountOrderOfType(dateStart, dateEnd, "pourcentage");
            Double totalDiscountAmount = this.ticketDao.getTotalDiscountOrderOfType(dateStart, dateEnd, "somme");
            Double totalDiscountOnLines = this.ticketDao.getTotalDiscountOnTicketLines(dateStart, dateEnd);
            RecapSharedSales recapSharedSales = new RecapSharedSales();
            recapSharedSales.setM_iSales(m_iSales != null ? m_iSales : 0L);
            recapSharedSales.setCaCanceled(caCanceled != null ? caCanceled : 0.0);
            recapSharedSales.setPayments(payments);
            recapSharedSales.setTotalDiscountAmount(totalDiscountAmount != null ? totalDiscountAmount : 0.0);
            recapSharedSales.setTotalDiscountPercentage(totalDiscountPercentage != null ? totalDiscountPercentage : 0.0);
            recapSharedSales.setTotalDiscountOnLines(totalDiscountOnLines != null ? totalDiscountOnLines : 0.0);
            recapSharedSales.setTurnover(turnover != null ? turnover : 0.0);
            recapSharedSales.setTurnoverByHostName(turnoverByHostName);
            recapSharedSales.setUsers(users);
            recapSharedSales.setTypeOrders(typeOrders);
            recapSharedSales.setDateStart(dateStart);
            recapSharedSales.setDateEnd(dateEnd);
            recapsSharedSaleses.add(recapSharedSales);
            calendarStart.setTime(dateStart);
            calendarStart.add(5, 1);
            dateStart = calendarStart.getTime();
            calendarEnd.setTime(dateEnd);
            calendarEnd.add(5, 1);
            calendarEnd.getTime();
            dateEnd = calendarEnd.getTime();
        }
        return recapsSharedSaleses;
    }

    public void setInfoKitchenOrder(int id_order, int id_order_kitchen, int num_order_kitchen) {
        this.ticketDao.setInfoKitchenOrder(id_order, id_order_kitchen, num_order_kitchen);
    }

    public List<RecapSharedSales> getRecapSharedSales(int year) {
        ArrayList<RecapSharedSales> recapsSharedSaleses = new ArrayList<RecapSharedSales>();
        Date dateStart = new Date();
        dateStart.setMinutes(0);
        dateStart.setMinutes(0);
        dateStart.setHours(6);
        dateStart.setDate(1);
        dateStart.setMonth(0);
        dateStart.setYear(year - 1900);
        Date dateEnd = new Date();
        dateEnd.setMinutes(59);
        dateEnd.setHours(5);
        dateEnd.setDate(1);
        dateEnd.setMonth(1);
        dateEnd.setYear(year - 1900);
        Calendar calendarStart = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        Date dateNow = new Date();
        for (int i = 0; i < 12 && dateStart.getYear() + 1900 == year && !dateStart.after(dateNow); ++i) {
            Double turnover = this.ticketDao.getCA(dateStart, dateEnd);
            List<PaymentLine> payments = this.mPaymentsDao.loadPayment(dateStart, dateEnd);
            Double caCanceled = this.ticketDao.getCACanceled(dateStart, dateEnd);
            Long m_iSales = this.ticketDao.getNbOrder(dateStart, dateEnd);
            List<UserCaisseInfo> users = this.ticketDao.getUsers(dateStart, dateEnd);
            List<RankTypeOrder> typeOrders = this.ticketDao.getTypesOrders(dateStart, dateEnd);
            HashMap<String, Double> turnoverByHostName = this.ticketDao.getCAByHostName(dateStart, dateEnd);
            Double totalDiscountPercentage = this.ticketDao.getTotalDiscountOrderOfType(dateStart, dateEnd, "pourcentage");
            Double totalDiscountAmount = this.ticketDao.getTotalDiscountOrderOfType(dateStart, dateEnd, "somme");
            Double totalDiscountOnLines = this.ticketDao.getTotalDiscountOnTicketLines(dateStart, dateEnd);
            RecapSharedSales recapSharedSales = new RecapSharedSales();
            recapSharedSales.setM_iSales(m_iSales != null ? m_iSales : 0L);
            recapSharedSales.setCaCanceled(caCanceled != null ? caCanceled : 0.0);
            recapSharedSales.setPayments(payments);
            recapSharedSales.setTotalDiscountAmount(totalDiscountAmount != null ? totalDiscountAmount : 0.0);
            recapSharedSales.setTotalDiscountPercentage(totalDiscountPercentage != null ? totalDiscountPercentage : 0.0);
            recapSharedSales.setTotalDiscountOnLines(totalDiscountOnLines != null ? totalDiscountOnLines : 0.0);
            recapSharedSales.setTurnover(turnover != null ? turnover : 0.0);
            recapSharedSales.setTurnoverByHostName(turnoverByHostName);
            recapSharedSales.setUsers(users);
            recapSharedSales.setTypeOrders(typeOrders);
            recapSharedSales.setDateStart(dateStart);
            recapSharedSales.setDateEnd(dateEnd);
            recapsSharedSaleses.add(recapSharedSales);
            calendarStart.setTime(dateStart);
            calendarStart.add(2, 1);
            dateStart = calendarStart.getTime();
            calendarEnd.setTime(dateEnd);
            calendarEnd.add(2, 1);
            calendarEnd.getTime();
            dateEnd = calendarEnd.getTime();
        }
        return recapsSharedSaleses;
    }

    public void cancelOrder(int idOrder, String reason_cancel) {
        this.cancelOrder(idOrder, reason_cancel, false);
    }

    public String getCodeLivreur(String id_ticket_source) {
        try {
            Tickets ticket = this.ticketDao.getOrderByIdsurce(id_ticket_source);
            if (ticket != null) {
                for (Ticketlines line : ticket.getTicketlinesCollection()) {
                    line.setItemsticketCollection(this.itemTicketDao.getItems(line.getId()));
                }
                return ticket.getCode_livreur();
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
            return null;
        }
        return null;
    }

    public Tickets getSharedOrder(int id) {
        Tickets order = this.ticketDao.getSharedOrder(id);
        return order;
    }

    public boolean isSharedPaid(int id) {
        Tickets order = this.getSharedOrder(id);
        return order != null;
    }

    public void cancelOrder(String id_source_ticket) {
        this.ticketDao.cancelOrder(id_source_ticket);
    }

    public int getIdCustomerAvomark(String id_source_ticket) {
        System.out.println("**********id_source_ticket" + id_source_ticket);
        Tickets ticket = this.ticketDao.getOrderByIdsurce(id_source_ticket);
        return ticket.getAvomarkCustomer();
    }
}

