/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.services;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.kitchen.dao.entities.Items;
import fr.protactile.kitchen.dao.entities.LinesOrder;
import fr.protactile.kitchen.dao.entities.OrderNum;
import fr.protactile.kitchen.dao.entities.Orders;
import fr.protactile.kitchen.dao.entities.ScreenItemNew;
import fr.protactile.kitchen.dao.entities.ScreenLineNew;
import fr.protactile.kitchen.dao.entities.ScreenSupplement;
import fr.protactile.kitchen.dao.entities.Supplements;
import fr.protactile.kitchen.dao.entities.TagLine;
import fr.protactile.kitchen.dao.impl.ItemDao;
import fr.protactile.kitchen.dao.impl.LineOrderDao;
import fr.protactile.kitchen.dao.impl.OrderDao;
import fr.protactile.kitchen.dao.impl.OrderNumDao;
import fr.protactile.kitchen.dao.impl.ScreenDao;
import fr.protactile.kitchen.dao.impl.ScreenItemDao;
import fr.protactile.kitchen.dao.impl.ScreenLineDao;
import fr.protactile.kitchen.dao.impl.ScreenSupplementDao;
import fr.protactile.kitchen.dao.impl.SupplementDao;
import fr.protactile.kitchen.dao.impl.TagLineDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class OrderService {
    private static OrderService m_instance;
    private OrderDao orderDao = new OrderDao();
    private LineOrderDao lineOrderDao = new LineOrderDao();
    private SupplementDao supplementDao = new SupplementDao();
    private ScreenDao screenDao;
    private ScreenSupplementDao screenSupplementDao;
    private ItemDao itemDao = new ItemDao();
    private ScreenLineDao screenLineDao;
    private OrderNumDao orderNumDao;
    private ScreenItemDao screenItemDao;
    private TagLineDao mTagLineDao;
    private final String ADD_NEW_ITEMS = "add new items";
    private final String FINISHED = "finished";

    private OrderService() {
        this.screenDao = new ScreenDao();
        this.screenSupplementDao = new ScreenSupplementDao();
        this.screenLineDao = new ScreenLineDao();
        this.orderNumDao = new OrderNumDao();
        this.screenItemDao = new ScreenItemDao();
        this.mTagLineDao = new TagLineDao();
    }

    public static OrderService getInstance() {
        if (m_instance == null) {
            m_instance = new OrderService();
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrder(Orders order) {
        this.orderDao.openSession();
        Transaction tx = this.orderDao.getCurrentSession().beginTransaction();
        try {
            if (order.getNumOrderKitchen() == -1) {
                order.setNumOrderKitchen(this.getLastNumOrder());
            }
            ArrayList<LinesOrder> lines = new ArrayList<LinesOrder>();
            if (order.getLinesOrderCollection() != null) {
                for (LinesOrder line : order.getLinesOrderCollection()) {
                    lines.add((LinesOrder)line.clone());
                }
                order.getLinesOrderCollection().clear();
            }
            System.out.println("++++++++++++ save order kitchen");
            this.orderDao.save(order);
            for (LinesOrder line : lines) {
                ArrayList<ScreenLineNew> screenLines = new ArrayList<ScreenLineNew>();
                if (line.getScreenLineCollection() != null) {
                    for (ScreenLineNew screenLineNew : line.getScreenLineCollection()) {
                        screenLines.add((ScreenLineNew)screenLineNew.clone());
                    }
                    line.getScreenLineCollection().clear();
                }
                ArrayList<Supplements> supplements = new ArrayList<Supplements>();
                if (line.getSupplementsCollection() != null) {
                    for (Object supplement : line.getSupplementsCollection()) {
                        supplements.add((Supplements)((Supplements)supplement).clone());
                    }
                    line.getSupplementsCollection().clear();
                }
                ArrayList<Items> arrayList = new ArrayList<Items>();
                if (line.getItemsCollection() != null) {
                    Object supplement;
                    supplement = line.getItemsCollection().iterator();
                    while (supplement.hasNext()) {
                        Items item = (Items)supplement.next();
                        arrayList.add((Items)item.clone());
                    }
                    line.getItemsCollection().clear();
                }
                ArrayList<TagLine> tagsLine = new ArrayList<TagLine>();
                if (line.getTagLineCollection() != null) {
                    for (TagLine tagLine : line.getTagLineCollection()) {
                        tagsLine.add((TagLine)tagLine.clone());
                    }
                    line.getTagLineCollection().clear();
                }
                line.setIdOrder(order);
                this.lineOrderDao.save(line);
                for (ScreenLineNew screenLine : screenLines) {
                    screenLine.setIdLine(line);
                    this.screenLineDao.save(screenLine);
                }
                for (Supplements supplement : supplements) {
                    supplement.setIdLine(line);
                    ArrayList<ScreenSupplement> screens = new ArrayList<ScreenSupplement>();
                    if (supplement.getScreenSupplementCollection() != null) {
                        for (ScreenSupplement screen : supplement.getScreenSupplementCollection()) {
                            screens.add((ScreenSupplement)screen.clone());
                        }
                        supplement.getScreenSupplementCollection().clear();
                    }
                    this.supplementDao.save(supplement);
                    for (ScreenSupplement screen : screens) {
                        screen.setIdSupplement(supplement);
                        this.screenSupplementDao.save(screen);
                    }
                }
                for (Items item : arrayList) {
                    ArrayList<Supplements> supplements_items = new ArrayList<Supplements>();
                    for (Supplements supplement : item.getSupplementsCollection()) {
                        supplements_items.add((Supplements)supplement.clone());
                    }
                    item.getSupplementsCollection().clear();
                    ArrayList<ScreenItemNew> screenItems = new ArrayList<ScreenItemNew>();
                    if (item.getScreenItemCollection() != null) {
                        for (ScreenItemNew screenItem : item.getScreenItemCollection()) {
                            screenItems.add((ScreenItemNew)screenItem.clone());
                        }
                        item.getScreenItemCollection().clear();
                    }
                    item.setIdLine(line);
                    this.itemDao.save(item);
                    for (ScreenItemNew screen : screenItems) {
                        screen.setIdItem(item);
                        this.screenItemDao.save(screen);
                    }
                    for (Supplements supplement_item : supplements_items) {
                        supplement_item.setIdItem(item);
                        supplement_item.setIdLine(line);
                        ArrayList<ScreenSupplement> screens = new ArrayList<ScreenSupplement>();
                        if (supplement_item.getScreenSupplementCollection() != null) {
                            for (ScreenSupplement screen : supplement_item.getScreenSupplementCollection()) {
                                screens.add((ScreenSupplement)screen.clone());
                            }
                            supplement_item.getScreenSupplementCollection().clear();
                        }
                        this.supplementDao.save(supplement_item);
                        for (ScreenSupplement screen : screens) {
                            screen.setIdSupplement(supplement_item);
                            this.screenSupplementDao.save(screen);
                        }
                    }
                    supplements.addAll(supplements_items);
                }
                for (TagLine tagLine : tagsLine) {
                    tagLine.setIdLine(line);
                    this.mTagLineDao.save(tagLine);
                }
                line.setSupplementsCollection(supplements);
                line.setItemsCollection(arrayList);
            }
            order.setLinesOrderCollection(lines);
            tx.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
            tx.rollback();
            boolean bl = false;
            return bl;
        }
        finally {
            this.orderDao.close();
        }
    }

    public void cancelOrder(String id_ticket) {
        try {
            this.orderDao.cancelOrder(id_ticket);
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
    }

    private int getLastNumOrder() {
        OrderNum orderNum = this.orderNumDao.getNumerOrderKitchen();
        int num_order = orderNum.getNumOrder();
        System.out.println("+++++++++ getNumerOrderKitchen date ************************* : " + orderNum.getInitializdAt() + "***************************************");
        Date date_now = new Date();
        if ((date_now.getDate() != orderNum.getInitializdAt().getDate() || date_now.getYear() != orderNum.getInitializdAt().getYear() || date_now.getMonth() != orderNum.getInitializdAt().getMonth()) && DateUtils.isAfterHour(date_now, 6)) {
            this.orderNumDao.initializeNumberOrder();
            num_order = 1;
        }
        return num_order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastNumOrderKitchen(int NumberCall) {
        System.out.println("+++++++++++ getLastNumOrderKitchen");
        Transaction tx = null;
        int num_order = -1;
        if (this.orderNumDao.getCurrentSession() != null) {
            try {
                tx = this.orderNumDao.getCurrentSession().beginTransaction();
                num_order = this.getLastNumOrder();
                this.orderNumDao.incrementNumOrder();
                tx.commit();
            }
            catch (Exception e) {
                LogToFile.log("severe", e.getMessage(), e);
                if (tx != null) {
                    tx.rollback();
                }
                if (NumberCall == 0) {
                    int n = num_order;
                    return n;
                }
                int n = this.getLastNumOrderKitchen(--NumberCall);
                return n;
            }
            finally {
                this.orderNumDao.close();
            }
        }
        System.out.println("+++++++++++++++++++++ num_order : " + num_order);
        return num_order;
    }

    public void paidOrder(int id) {
        this.orderDao.paidOrder(id);
    }

    public void setIdTicketCaisse(int id, String id_ticket) {
        try {
            this.orderDao.setIdTicketCaisse(id, id_ticket);
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public void cancelOrderById(int id_order) {
        this.orderDao.cancelOrderById(id_order);
    }

    public void setIdTicketCaisse(List<Integer> ids_order, String id_ticket) {
        try {
            for (Integer id_order : ids_order) {
                this.orderDao.setIdTicketCaisse(id_order, id_ticket);
            }
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public void paidOrderByTicket(String idTicket) {
        this.orderDao.paidOrderByTicket(idTicket);
    }

    public int updateOrder(Orders order) {
        boolean finished = true;
        ArrayList<LinesOrder> lines_to_delete = new ArrayList<LinesOrder>();
        ArrayList<Supplements> supplements_to_delete = new ArrayList<Supplements>();
        ArrayList<Items> items_to_delete = new ArrayList<Items>();
        ArrayList<Supplements> supplements_items_to_delete = new ArrayList<Supplements>();
        int id_order = 0;
        boolean updatable = false;
        Session session = null;
        Transaction tx = null;
        try {
            session = this.orderDao.getSessionFactory().getCurrentSession();
            tx = session.beginTransaction();
            ArrayList<LinesOrder> oldLines = new ArrayList<LinesOrder>();
            Orders old_order = (Orders)session.find(Orders.class, (Object)order.getId());
            ArrayList<LinesOrder> lines = new ArrayList<LinesOrder>();
            if (order.getLinesOrderCollection() != null) {
                for (LinesOrder line : order.getLinesOrderCollection()) {
                    lines.add((LinesOrder)line.clone());
                }
                order.getLinesOrderCollection().clear();
            }
            if (old_order != null) {
                updatable = old_order.isUpdatable();
                if (!updatable) {
                    tx.rollback();
                    session.close();
                    return 0;
                }
                oldLines.addAll(old_order.getLinesOrderCollection());
                old_order.getLinesOrderCollection().clear();
                session.clear();
                id_order = old_order.getId();
                order.setUpdated(old_order.isUpdated());
                this.checkIfOrderChanged(order, old_order);
            } else {
                order.setCreated(new Date());
                order.setUpdatedAt(new Date());
                session.save((Object)order);
            }
            for (LinesOrder line : lines) {
                System.out.println("line.getId() : " + line.getId() + " name " + line.getName());
                LinesOrder oldLine = (LinesOrder)session.find(LinesOrder.class, (Object)line.getId());
                List<LinesOrder> oldLinesTmp = this.lineOrderDao.getLines(line.getId_ticket_line(), session);
                double oldQuantity = 0.0;
                for (LinesOrder lineTmp : oldLinesTmp) {
                    oldQuantity += lineTmp.getQuantity();
                }
                session.clear();
                if (oldLine != null && line.getQuantity() > oldQuantity && AppLocal.ADD_NEW_LINE_SCREEN) {
                    LinesOrder newLine = (LinesOrder)line.clone();
                    newLine.setQuantity(line.getQuantity() - oldQuantity);
                    newLine.setOld_quantity(oldLine.getQuantity());
                    newLine.setId(null);
                    if (newLine.getScreenLineCollection() != null) {
                        for (ScreenLineNew screenLine : newLine.getScreenLineCollection()) {
                            screenLine.setId(null);
                        }
                    }
                    if (newLine.getSupplementsCollection() != null) {
                        for (Supplements supplement : newLine.getSupplementsCollection()) {
                            supplement.setId(null);
                        }
                    }
                    if (newLine.getItemsCollection() != null) {
                        for (Items item : newLine.getItemsCollection()) {
                            item.setId(null);
                        }
                    }
                    if (newLine.getTagLineCollection() != null) {
                        for (TagLine tagLine : newLine.getTagLineCollection()) {
                            tagLine.setId(null);
                        }
                    }
                    System.out.println("++++++++++ add new line");
                    this.addNewLine(newLine, null, supplements_to_delete, items_to_delete, supplements_items_to_delete, order, session);
                    continue;
                }
                System.out.println("++++++++++ update line");
                this.addNewLine(line, oldLine, supplements_to_delete, items_to_delete, supplements_items_to_delete, order, session);
            }
            for (LinesOrder oldLine : oldLines) {
                if (oldLine.getStatus() == null && !oldLine.getStatus().equals("finished")) {
                    finished = false;
                }
                boolean exist = false;
                for (LinesOrder line : lines) {
                    if (!Objects.equals(oldLine.getId(), line.getId()) && !Objects.equals(oldLine.getId_ticket_line(), line.getId_ticket_line())) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                lines_to_delete.add(oldLine);
            }
            order.setLinesOrderCollection(lines);
            if (updatable) {
                if (id_order != 0) {
                    if (lines_to_delete != null && !lines_to_delete.isEmpty() || this.existSupplementDeleted(supplements_to_delete) || items_to_delete != null && !items_to_delete.isEmpty() || this.existSupplementDeleted(supplements_items_to_delete)) {
                        order.setUpdated(true);
                    }
                    if (finished) {
                        order.setUpdate_reason("add new items");
                    }
                    this.orderDao.updateOrder(order, session);
                }
                this.removeLines(lines_to_delete, session);
                this.removeSupplements(supplements_to_delete, session);
                this.removeItems(items_to_delete, session);
                this.removeSupplements(supplements_items_to_delete, session);
            }
            tx.commit();
            session.close();
            return 1;
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
            e.printStackTrace();
            if (tx != null) {
                tx.rollback();
            }
            if (session != null) {
                session.close();
            }
            return -1;
        }
    }

    private void updateSupplement(Supplements supplement, Orders order, Session session) {
        ArrayList<ScreenSupplement> screens = new ArrayList<ScreenSupplement>();
        if (supplement.getScreenSupplementCollection() != null) {
            for (ScreenSupplement screen : supplement.getScreenSupplementCollection()) {
                screens.add((ScreenSupplement)screen.clone());
            }
            supplement.getScreenSupplementCollection().clear();
        }
        if (!supplement.getIngredientIncluded()) {
            Supplements oldSupplement = supplement.getId() != null ? (Supplements)session.find(Supplements.class, (Object)supplement.getId()) : null;
            session.clear();
            if (oldSupplement != null) {
                supplement.setStatus(oldSupplement.getStatus());
                supplement.setValid(oldSupplement.isValid());
                supplement.setShift_option(oldSupplement.getShift_option());
                supplement.setSupplementSuivi(oldSupplement.getSupplementSuivi());
                supplement.setAlias(oldSupplement.getAlias());
                supplement.setImage_path(oldSupplement.getImage_path());
                if (supplement.getQuantity() != oldSupplement.getQuantity()) {
                    order.setUpdated(true);
                }
                session.saveOrUpdate((Object)supplement);
            } else {
                order.setUpdated(true);
                session.save((Object)supplement);
                for (ScreenSupplement screen : screens) {
                    screen.setIdSupplement(supplement);
                    session.save((Object)screen);
                }
            }
        }
    }

    private void removeLines(List<LinesOrder> lines, Session session) {
        for (LinesOrder line : lines) {
            this.screenLineDao.removeScreensLine(line.getId(), session);
            this.mTagLineDao.removeTagLine(line.getId(), session);
            this.screenSupplementDao.removeScreensSupplement(line.getId(), session);
            this.screenItemDao.removeScreensItem(line.getId(), session);
            this.supplementDao.removeSupplementsByLine(line.getId(), session);
            this.itemDao.removeItemsByLine(line.getId(), session);
            this.lineOrderDao.removeLine(line.getId(), session);
        }
    }

    private void removeSupplements(List<Supplements> supplements, Session session) {
        for (Supplements supplement : supplements) {
            this.screenSupplementDao.removeScreensSupplementBySupp(supplement.getId(), session);
            this.supplementDao.removeSupplement(supplement.getId(), session);
        }
    }

    private void removeItems(List<Items> items, Session session) {
        for (Items item : items) {
            this.screenSupplementDao.removeScreensSupplementByItem(item.getId(), session);
            this.screenItemDao.removeScreensItemByItem(item.getId(), session);
            this.supplementDao.removeSupplementsByItem(item.getId(), session);
            this.itemDao.removeItem(item.getId(), session);
        }
    }

    public void disableUpdate(int id_order_kitchen) {
        this.orderDao.disableUpdate(id_order_kitchen);
    }

    private void addNewLine(LinesOrder line, LinesOrder oldLine, List<Supplements> supplements_to_delete, List<Items> items_to_delete, List<Supplements> supplements_items_to_delete, Orders order, Session session) {
        ArrayList<ScreenLineNew> screenLines = new ArrayList<ScreenLineNew>();
        if (line.getScreenLineCollection() != null) {
            for (ScreenLineNew screenLineNew : line.getScreenLineCollection()) {
                screenLines.add((ScreenLineNew)screenLineNew.clone());
            }
            line.getScreenLineCollection().clear();
        }
        ArrayList<Supplements> supplements = new ArrayList<Supplements>();
        if (line.getSupplementsCollection() != null) {
            for (Supplements supplements2 : line.getSupplementsCollection()) {
                supplements.add((Supplements)supplements2.clone());
            }
            line.getSupplementsCollection().clear();
        }
        ArrayList<Items> arrayList = new ArrayList<Items>();
        if (line.getItemsCollection() != null) {
            for (Items items : line.getItemsCollection()) {
                arrayList.add((Items)items.clone());
            }
            line.getItemsCollection().clear();
        }
        ArrayList<TagLine> arrayList2 = new ArrayList<TagLine>();
        if (line.getTagLineCollection() != null) {
            for (TagLine tagLine : line.getTagLineCollection()) {
                arrayList2.add((TagLine)tagLine.clone());
            }
            line.getTagLineCollection().clear();
        }
        ArrayList<Supplements> arrayList3 = new ArrayList<Supplements>();
        ArrayList<Items> oldItems = new ArrayList<Items>();
        line.setIdOrder(order);
        if (AppLocal.ADD_NEW_LINE_SCREEN) {
            line.setUpdated(true);
        }
        if (oldLine != null) {
            List<Supplements> supplements_tmp = this.supplementDao.getSupplements(oldLine.getId(), session);
            arrayList3.addAll(supplements_tmp);
            List<Items> items_tmp = this.itemDao.getItems(oldLine.getId(), session);
            oldItems.addAll(items_tmp);
            line.setStatus(oldLine.getStatus());
            line.setOld_quantity(oldLine.getQuantity());
            line.setHidden(oldLine.getHidden());
            line.setPrintWarning(oldLine.getPrintWarning());
            line.setImage_path(oldLine.getImage_path());
            line.setValid(oldLine.isValid());
            session.clear();
        }
        if (oldLine != null) {
            if (oldLine.getQuantity() != line.getQuantity()) {
                order.setUpdated(true);
            }
            this.lineOrderDao.updateLine(line, session);
        } else {
            order.setUpdated(true);
            session.save((Object)line);
            for (ScreenLineNew screenLine : screenLines) {
                screenLine.setIdLine(line);
                session.save((Object)screenLine);
            }
            for (TagLine tagLine : arrayList2) {
                tagLine.setIdLine(line);
                session.save((Object)tagLine);
            }
        }
        for (Supplements supplement : supplements) {
            supplement.setIdLine(line);
            if (supplement.getIngredientIncluded()) {
                session.save((Object)supplement);
                continue;
            }
            this.updateSupplement(supplement, order, session);
        }
        for (Supplements oldSupplement : arrayList3) {
            if (oldSupplement.getIdItem() != null) continue;
            boolean exist = false;
            for (Supplements supplements3 : supplements) {
                if (!Objects.equals(oldSupplement.getId(), supplements3.getId())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            supplements_to_delete.add(oldSupplement);
        }
        for (Items item : arrayList) {
            ArrayList<Supplements> supplements_items = new ArrayList<Supplements>();
            for (Supplements supplements4 : item.getSupplementsCollection()) {
                supplements_items.add((Supplements)supplements4.clone());
            }
            item.getSupplementsCollection().clear();
            ArrayList<ScreenItemNew> screenItems = new ArrayList<ScreenItemNew>();
            if (item.getScreenItemCollection() != null) {
                for (ScreenItemNew screenItem : item.getScreenItemCollection()) {
                    screenItems.add((ScreenItemNew)screenItem.clone());
                }
                item.getScreenItemCollection().clear();
            }
            Items items = item.getId() != null ? (Items)session.find(Items.class, (Object)item.getId()) : null;
            ArrayList<Supplements> oldSupplementsItems = new ArrayList<Supplements>();
            item.setIdLine(line);
            if (items != null) {
                List<Supplements> supplements_tmp = this.supplementDao.getSupplementsByItem(items.getId(), session);
                oldSupplementsItems.addAll(supplements_tmp);
                item.setStatus(items.getStatus());
                item.setValid(items.isValid());
                session.clear();
                if (item.getQuantity() != items.getQuantity()) {
                    order.setUpdated(true);
                }
                session.update((Object)item);
            } else {
                order.setUpdated(true);
                session.save((Object)item);
                for (ScreenItemNew screen : screenItems) {
                    screen.setIdItem(item);
                    session.save((Object)screen);
                }
            }
            for (Supplements supplement_item : supplements_items) {
                supplement_item.setIdItem(item);
                supplement_item.setIdLine(line);
                if (supplement_item.getIngredientIncluded()) {
                    session.save((Object)supplement_item);
                    continue;
                }
                this.updateSupplement(supplement_item, order, session);
            }
            for (Supplements oldSupplement : oldSupplementsItems) {
                boolean exist = false;
                for (Supplements supplement : supplements_items) {
                    if (!Objects.equals(oldSupplement.getId(), supplement.getId())) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                supplements_items_to_delete.add(oldSupplement);
            }
            supplements.addAll(supplements_items);
        }
        for (Items oldItem : oldItems) {
            boolean exist = false;
            for (Items items : arrayList) {
                if (!Objects.equals(oldItem.getId(), items.getId())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            items_to_delete.add(oldItem);
        }
        line.setSupplementsCollection(supplements);
        line.setItemsCollection(arrayList);
    }

    private boolean existSupplementDeleted(List<Supplements> supplements_to_delete) {
        if (supplements_to_delete != null) {
            for (Supplements supplement : supplements_to_delete) {
                if (supplement.getIngredientIncluded()) continue;
                return true;
            }
        }
        return false;
    }

    private void checkIfOrderChanged(Orders order, Orders old_order) {
        if (order.getBipper() != 0 && order.getBipper() != old_order.getBipper()) {
            order.setUpdated(true);
        }
        if (order.getComment() != null && !order.getComment().equalsIgnoreCase(old_order.getComment())) {
            order.setUpdated(true);
        }
        if (order.getType() != null && !order.getType().equalsIgnoreCase(old_order.getType())) {
            order.setUpdated(true);
        }
    }

    public void updateOrders(TicketInfo ticket) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.orderDao.getSessionFactory().getCurrentSession();
            tx = session.beginTransaction();
            List<Orders> orders = this.orderDao.getOrders(ticket.getId(), session);
            boolean updateOrders = false;
            for (Orders order : orders) {
                if (ticket.getBipper() != 0 && ticket.getBipper().intValue() != order.getBipper()) {
                    updateOrders = true;
                    order.setBipper(ticket.getBipper());
                }
                if (ticket.getComment() != null && !ticket.getComment().equalsIgnoreCase(order.getComment())) {
                    updateOrders = true;
                    order.setComment(ticket.getComment());
                }
                if (ticket.getType() == null || ticket.getType().equalsIgnoreCase(order.getType())) continue;
                updateOrders = true;
                order.setType(ticket.getType());
            }
            if (updateOrders) {
                for (Orders order : orders) {
                    this.orderDao.updateOrder(session, order);
                }
            }
            tx.commit();
            session.close();
        }
        catch (Exception ex) {
            if (tx != null) {
                tx.rollback();
            }
            if (session != null) {
                session.close();
            }
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

