/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.services;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicProduct;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.OrderKitchenBuilder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.connection.hibernate.DBUtils;
import fr.protactile.kitchen.dao.entities.Items;
import fr.protactile.kitchen.dao.entities.LinesOrder;
import fr.protactile.kitchen.dao.entities.Orders;
import fr.protactile.kitchen.dao.entities.ScreenNew;
import fr.protactile.kitchen.dao.entities.Supplements;
import fr.protactile.kitchen.dao.impl.OrderDao;
import fr.protactile.kitchen.services.OrderService;
import fr.protactile.kitchen.services.ScreenNewService;
import fr.protactile.procaisse.cache.SharedMemoryCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OrderKitchenScreenService {
    private ScreenNewService screenService = ScreenNewService.getInstance();
    private DataLogicSales dlSales;
    private DataLogicProduct dlProduct;
    private List<ScreenNew> screens;
    private DataLogicOrder dlOrders;
    private SharedMemoryCache mSharedMemoryCache;
    private boolean slave;
    private final String UBER_EATS = "Uber Eats";
    private DataLogicItems dlItems;

    public OrderKitchenScreenService(DataLogicSales dlSales, DataLogicProduct dlProduct, DataLogicOrder dlOrders, DataLogicItems dlItems) {
        this.dlSales = dlSales;
        this.dlProduct = dlProduct;
        this.dlOrders = dlOrders;
        this.dlItems = dlItems;
        this.mSharedMemoryCache = SharedMemoryCache.getInstance();
        this.slave = AppLocal.modeCaisse != null && AppLocal.modelCaisse.equals("Esclave");
    }

    public Orders sendOrderToKitchen(TicketInfo ticket, boolean after_restart, boolean setIdOrder) {
        Orders order = new Orders();
        Object[] result = this.sendOrderToKitchen(order, ticket, after_restart, setIdOrder);
        int id_order = result != null ? (Integer)result[0] : 0;
        Date dateCreated = result != null && result.length > 1 && result[1] != null ? (Date)result[1] : null;
        Date dateDelivered = result != null && result.length > 2 && result[2] != null ? (Date)result[2] : null;
        order.setId(id_order);
        order.setCreated(dateCreated);
        order.setDelivery_date(dateDelivered);
        return order;
    }

    public Object[] sendOrderToKitchen(Orders order, TicketInfo ticket, boolean after_restart, boolean setIdOrder) {
        Object[] result = new Object[]{0, null, null};
        try {
            this.screens = this.screenService.getScreens();
            order = new OrderKitchenBuilder().order(order).dlProduct(this.dlProduct).dlSales(this.dlSales).dlItems(this.dlItems).setIdOrder(setIdOrder).ticket(ticket).screens(this.screens).after_restart(after_restart).build().getOrder();
            this.sendOrderToKitchen(order, ticket, setIdOrder);
            result[0] = order.getId();
            result[1] = order.getCreated();
            result[2] = order.getDelivery_date();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return result;
    }

    public void sendOrderToKitchen(Orders order, TicketInfo ticket, boolean setIdOrder) {
        block8: {
            OrderDao orderDao = new OrderDao();
            if (orderDao.getCurrentSession() == null) {
                DBUtils.initDB();
                orderDao.setSession();
            }
            if (orderDao.getCurrentSession() != null) {
                try {
                    if (order.getLinesOrderCollection().size() <= 0) break block8;
                    OrderService orderService = OrderService.getInstance();
                    order.setNumOrderKitchen(ticket.getNum_order_kitchen());
                    order.setNumber_order_with_hour(ticket.getNumberOrderWithHour());
                    boolean result = orderService.addOrder(order);
                    if (result) {
                        System.out.println("setIdOrder : " + setIdOrder);
                        if (setIdOrder) {
                            this.setIdsOrderKitchen(ticket, order);
                        } else {
                            this.setIdsTmpOrderKitchen(ticket, order);
                        }
                        break block8;
                    }
                    this.addTicketToQUEUE(ticket);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    this.addTicketToQUEUE(ticket);
                }
            } else {
                this.addTicketToQUEUE(ticket);
            }
        }
    }

    private void addTicketToQUEUE(TicketInfo ticket) {
        if (AppVarUtils.QUEUE_TICKET_KITCHEN == null) {
            AppVarUtils.QUEUE_TICKET_KITCHEN = new ArrayList<TicketInfo>();
        }
        AppVarUtils.QUEUE_TICKET_KITCHEN.add(ticket);
    }

    public void updateOrderKitchen(TicketInfo ticket, boolean setIdOrder) {
        try {
            this.screens = this.screenService.getScreens();
            Orders order = null;
            order = new OrderKitchenBuilder().order(order).dlProduct(this.dlProduct).dlSales(this.dlSales).dlItems(this.dlItems).setIdOrder(setIdOrder).ticket(ticket).screens(this.screens).after_restart(true).build().getOrder();
            if (order.getLinesOrderCollection().size() > 0) {
                OrderService orderService = OrderService.getInstance();
                order.setNumOrderKitchen(ticket.getNum_order_kitchen());
                int result = orderService.updateOrder(order);
                switch (result) {
                    case 1: {
                        if (!setIdOrder) break;
                        this.setIdsOrderKitchen(ticket, order);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case -1: {
                        this.addTicketToQUEUE(ticket);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setIdsOrderKitchen(TicketInfo ticket, Orders order) throws BasicException {
        ticket.setId_order_kitchen(order.getId());
        this.dlOrders.addInfoKitchenToOrder(ticket.getId(), order.getId());
        for (LinesOrder line : order.getLinesOrderCollection()) {
            OptionItemOrder ticketSupplement;
            TicketLineInfo ticketLine = this.getTickettLineById(ticket, line.getId_ticket_line());
            if (ticketLine != null) {
                ticketLine.setId_line_kitchen(line.getId());
            }
            this.dlOrders.addInfoKitchenToLine(line.getId_ticket_line(), line.getId());
            if (line.getSupplementsCollection() != null) {
                for (Supplements supplement : line.getSupplementsCollection()) {
                    ItemOrderInfo ticketIngredient;
                    if (!supplement.getIsIngredient()) {
                        if (supplement.getId() == null) continue;
                        if (ticketLine != null && (ticketSupplement = this.getTicketSupplementById(ticketLine, supplement.getId_supplement_order())) != null) {
                            ticketSupplement.setId_supplement_kitchen(supplement.getId());
                        }
                        this.dlOrders.addInfoKitchenToSupplement(supplement.getId_supplement_order(), supplement.getId());
                        continue;
                    }
                    if (supplement.getId() == null) continue;
                    if (ticketLine != null && (ticketIngredient = this.getTicketIngredientById(ticketLine, supplement.getId_supplement_order())) != null) {
                        ticketIngredient.setId_ingredient_kitchen(supplement.getId());
                    }
                    this.dlOrders.addInfoKitchenToIngredient(supplement.getId_supplement_order(), supplement.getId());
                }
            }
            if (line.getItemsCollection() == null) continue;
            for (Items item : line.getItemsCollection()) {
                ProductTicket ticketItem;
                if (item.isSupplement()) {
                    if (ticketLine != null && (ticketSupplement = this.getTicketSupplementById(ticketLine, item.getId_item_source())) != null) {
                        ticketSupplement.setId_supplement_kitchen(item.getId());
                    }
                    this.dlOrders.addInfoKitchenToSupplement(item.getId_item_source(), item.getId());
                    continue;
                }
                if (ticketLine != null && (ticketItem = this.getTicketItemById(ticketLine, item.getId_item_source())) != null) {
                    ticketItem.setId_item_kitchen(item.getId());
                }
                this.dlOrders.addInfoKitchenToItem(item.getId_item_source(), item.getId());
            }
        }
    }

    private void setIdsTmpOrderKitchen(TicketInfo ticket, Orders order) throws BasicException {
        ticket.setId_order_kitchen(order.getId());
        for (TicketLineInfo line : ticket.getLines()) {
            Items itemKitchen;
            Supplements supplementKitchen;
            LinesOrder lineKitchen = this.getLineById(order, line.getID());
            if (lineKitchen == null) continue;
            line.setId_line_kitchen(lineKitchen.getId());
            for (OptionItemOrder supplement : line.getListSupplements()) {
                if (supplement.getId_sub_product() == 0) {
                    supplementKitchen = this.getSupplementById(lineKitchen, supplement.getId());
                    if (supplementKitchen == null) continue;
                    supplement.setId_supplement_kitchen(supplementKitchen.getId());
                    continue;
                }
                itemKitchen = this.getItemById(lineKitchen, supplement.getId());
                if (itemKitchen == null) continue;
                supplement.setId_supplement_kitchen(itemKitchen.getId());
            }
            for (ItemOrderInfo ingredient : line.getListIngredients()) {
                supplementKitchen = this.getSupplementById(lineKitchen, ingredient.getId());
                if (supplementKitchen == null) continue;
                ingredient.setId_ingredient_kitchen(supplementKitchen.getId());
            }
            for (ProductTicket item : line.getListProducts()) {
                itemKitchen = this.getItemById(lineKitchen, item.getId());
                if (itemKitchen == null) continue;
                item.setId_item_kitchen(itemKitchen.getId());
            }
        }
    }

    private LinesOrder getLineById(Orders order, int id_line) {
        for (LinesOrder line : order.getLinesOrderCollection()) {
            if (line.getId_line_tmp() != id_line) continue;
            return line;
        }
        return null;
    }

    private Supplements getSupplementById(LinesOrder lineKitchen, int id_supplement) {
        for (Supplements supplement : lineKitchen.getSupplementsCollection()) {
            if (supplement.getId_supplement_tmp() != id_supplement) continue;
            return supplement;
        }
        return null;
    }

    private Items getItemById(LinesOrder lineKitchen, int id_item) {
        for (Items item : lineKitchen.getItemsCollection()) {
            if (item.getId_item_tmp() != id_item) continue;
            return item;
        }
        return null;
    }

    private TicketLineInfo getTickettLineById(TicketInfo order, int id_line) {
        for (TicketLineInfo line : order.getLines()) {
            if (line.getID() != id_line) continue;
            return line;
        }
        return null;
    }

    private ItemOrderInfo getTicketIngredientById(TicketLineInfo line, int id_ingredient) {
        for (ItemOrderInfo ingredient : line.getListIngredients()) {
            if (ingredient.getId() != id_ingredient) continue;
            return ingredient;
        }
        return null;
    }

    private OptionItemOrder getTicketSupplementById(TicketLineInfo line, int id_supplement) {
        for (OptionItemOrder supplement : line.getListSupplements()) {
            if (supplement.getId() != id_supplement) continue;
            return supplement;
        }
        return null;
    }

    private ProductTicket getTicketItemById(TicketLineInfo line, int id_item) {
        for (ProductTicket item : line.getListProducts()) {
            if (item.getId() != id_item) continue;
            return item;
        }
        return null;
    }
}

