/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.dao.impl;

import fr.protactile.kitchen.dao.config.DaoConfig;
import fr.protactile.kitchen.dao.entities.Ticketlines;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class TicketLinesDao
extends DaoConfig<Ticketlines> {
    @Override
    protected Class<Ticketlines> classType() {
        return Ticketlines.class;
    }

    public void deleteOldLines(Date date) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            String hqlUpdate = "delete from Ticketlines L WHERE L.idTicket IN (select O from Tickets O where O.sourceOrder = :sourceOrder and O.created < :date)";
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("sourceOrder", (Object)"Tabletto").setParameter("date", (Object)date).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void deleteOAllLines() {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            String hqlUpdate = "delete from Ticketlines L WHERE L.idTicket IN (select O from Tickets O where O.sourceOrder = :sourceOrder)";
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("sourceOrder", (Object)"Tabletto").executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public List<Ticketlines> getLines(int idTicket) {
        List<Ticketlines> lines = new ArrayList<Ticketlines>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select L from Ticketlines L where L.idTicket = :idTicket ");
            query.setInteger("idTicket", idTicket);
            lines = query.list();
            tx.commit();
            session.close();
        }
        return lines;
    }

    public void paidTicketLine(int id_line, double unit_paid) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Ticketlines T set  T.unit_paid = T.unit_paid + :unit_paid where T.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setInteger("id", id_line).setDouble("unit_paid", unit_paid).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void paidAllTicketLine(int id_ticket) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Ticketlines T set  T.unit_paid = T.quantity where T.idTicket = :idTicket ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setInteger("idTicket", id_ticket).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void deleteLines(int idTicket) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "delete from Ticketlines L WHERE L.idTicket.id = :idTicket";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("idTicket", (Object)idTicket).executeUpdate();
            tx.commit();
            session.close();
        }
    }
}

