/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.dao.impl;

import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.kitchen.dao.config.DaoConfig;
import fr.protactile.kitchen.dao.entities.Tickets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class TicketDao
extends DaoConfig<Tickets> {
    @Override
    protected Class<Tickets> classType() {
        return Tickets.class;
    }

    public Tickets getOrderById(int id) {
        Tickets ticket = null;
        if (sessionFactory != null) {
            Transaction tx = null;
            try {
                Session session = sessionFactory.getCurrentSession();
                tx = session.beginTransaction();
                Query query = session.createQuery("select T from Tickets T where T.id = :id and T.saved = 0", Tickets.class);
                query.setParameter("id", (Object)id);
                List resultList = query.getResultList();
                if (!resultList.isEmpty()) {
                    ticket = (Tickets)resultList.get(0);
                }
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                LogToFile.log("severe", e.getMessage(), e);
            }
        }
        return ticket;
    }

    public Tickets getOrderByBarCode(String barCode) {
        Tickets ticket = null;
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.barcode = :barCode and T.saved  = 0 ");
            query.setString("barCode", barCode);
            if (!query.getResultList().isEmpty()) {
                ticket = (Tickets)query.getResultList().get(0);
            }
            tx.commit();
            session.close();
        }
        return ticket;
    }

    public List<Tickets> getOrders(String source_order) {
        if (sessionFactory != null) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -3);
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.paid = 0 and T.saved  = 0  and T.canceled  = 0 and T.sourceOrder = :sourceOrder and T.created >= :date");
            query.setParameter("sourceOrder", (Object)source_order);
            query.setParameter("date", (Object)cal.getTime());
            List tickets = query.list();
            tx.commit();
            session.close();
            return tickets;
        }
        return null;
    }

    public List<Tickets> getOrders(String source_order, String type_payment) {
        List<Tickets> tickets = new ArrayList<Tickets>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.canceled  = 0 and T.sourceOrder = :sourceOrder and T.typePayment = :typePayment");
            query.setParameter("sourceOrder", (Object)source_order);
            query.setParameter("typePayment", (Object)type_payment);
            tickets = query.list();
            tx.commit();
            session.close();
        }
        return tickets;
    }

    public void saveOrder(int id_order) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            String hqlUpdate = "update Tickets T set T.saved = 1, T.updatedAt = CURRENT_TIMESTAMP  where T.id = :id ";
            int updatedEntities = session.createQuery(hqlUpdate).setInteger("id", id_order).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void deleteOldOrders(Date date) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "delete from Tickets O where O.sourceOrder = :sourceOrder and O.created < :date ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("sourceOrder", (Object)"Tabletto").setParameter("date", (Object)date).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void deleteAllOrders() {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "delete from Tickets O where O.sourceOrder = :sourceOrder";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("sourceOrder", (Object)"Tabletto").executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public List<Tickets> getOrdersByDevice(String name_device) {
        System.out.println("+++++++++++++ sessionFactory : " + sessionFactory);
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.paid = 0 and T.saved  = 0 and T.canceled  = 0 and T.hostName = :hostName");
            query.setParameter("hostName", (Object)name_device);
            List tickets = query.list();
            System.out.println("+++++++++ tickets : " + tickets);
            tx.commit();
            session.close();
            return tickets;
        }
        return null;
    }

    public void cancelOrder(int id_order, String reason_cancel, boolean check_paid) {
        if (sessionFactory != null) {
            String request_paid = check_paid ? " and T.paid = 0 " : "";
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Tickets T set T.canceled = 1, T.reasonCancel = :reason_cancel,  T.updatedAt = CURRENT_TIMESTAMP where T.id = :id " + request_paid;
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setInteger("id", id_order).setString("reason_cancel", reason_cancel).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void cancelOrder(int id_order, boolean check_paid) {
        if (sessionFactory != null) {
            String request_paid = check_paid ? " and T.paid = 0 " : "";
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Tickets T set T.canceled = 1, T.updatedAt = CURRENT_TIMESTAMP where T.id = :id " + request_paid;
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setInteger("id", id_order).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void encaisserOrder(int id_order, String hostName) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Tickets T set T.saved = 1, T.paid = 1, T.updatedAt = CURRENT_TIMESTAMP, T.hostName = :hostName where T.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setString("hostName", hostName).setInteger("id", id_order).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public Date getLastUpdatedOrderDate() {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query q = session.createQuery("SELECT MAX(t.updatedAt) as lastUpdatedAt FROM Tickets t");
            Object o = q.getSingleResult();
            tx.commit();
            session.close();
            if (o != null) {
                return (Date)o;
            }
        }
        return null;
    }

    public List<Tickets> getOrdersCanceledByDevice(String name_device) {
        List<Tickets> tickets = new ArrayList<Tickets>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.verified  = 0 and T.canceled  = 1 and T.hostName = :hostName");
            query.setParameter("hostName", (Object)name_device);
            tickets = query.list();
            tx.commit();
            session.close();
        }
        return tickets;
    }

    public List<Tickets> getOrdersToVerifyByDevice(String name_device) {
        List<Tickets> tickets = new ArrayList<Tickets>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where (T.paid = 1 or T.canceled  = 1) and T.verified  = 0 and T.hostName = :hostName");
            query.setParameter("hostName", (Object)name_device);
            tickets = query.list();
            tx.commit();
            session.close();
        }
        return tickets;
    }

    public void verifyOrder(int id_order) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Tickets T set T.verified = 1 where T.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setInteger("id", id_order).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public List<Tickets> getOrders(String source_order, String type_payment, Date date_start, Date date_end) {
        System.out.println("++++++ caisse orders");
        if (sessionFactory != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.canceled  = 0 and T.sourceOrder = :sourceOrder and T.typePayment = :typePayment and T.created > :dateStart and T.created < :dateEnd");
            query.setParameter("sourceOrder", (Object)source_order);
            query.setParameter("typePayment", (Object)type_payment);
            query.setParameter("dateStart", (Object)date_start);
            query.setParameter("dateEnd", (Object)date_end);
            List tickets = query.list();
            tx.commit();
            session.close();
            return tickets;
        }
        return null;
    }

    public void validPrintOrder(int id_order) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Tickets T set T.error_print_kitchen = 0 where T.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setInteger("id", id_order).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public List<Tickets> getOrderPrintError() {
        if (sessionFactory != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.error_print_kitchen  = 1 and year(T.created) = :year and month(T.created) = :month and DAY(T.created) = :day ");
            query.setInteger("year", cal.get(1));
            query.setInteger("month", cal.get(2) + 1);
            query.setInteger("day", cal.get(5));
            List tickets = query.list();
            tx.commit();
            session.close();
            AppLocal.LOOP_SQL_REQUEST = false;
            return tickets;
        }
        return null;
    }

    public List<Tickets> getPendingOrders() {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.paid = 0 and T.canceled  = 0 and T.num_table <> 0");
            List tickets = query.list();
            tx.commit();
            session.close();
            return tickets;
        }
        return null;
    }

    public void paidSharedOrder(int id_order, String hostName) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            String hqlUpdate = "update Tickets T set T.paid = 1, T.updatedAt = CURRENT_TIMESTAMP, T.hostName = :hostName where T.id = :id ";
            int updatedEntities = session.createQuery(hqlUpdate).setString("hostName", hostName).setInteger("id", id_order).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void changeTable(int id_order, int num_table) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Tickets T set T.num_table = :num_table, T.updatedAt = CURRENT_TIMESTAMP where T.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setInteger("num_table", num_table).setInteger("id", id_order).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public List<Tickets> getOrdersByHostName(String source_order, String host_name) {
        List<Tickets> tickets = new ArrayList<Tickets>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.paid = 0 and T.saved  = 0  and T.canceled  = 0 and T.sourceOrder = :sourceOrder and T.hostName <> :host_name");
            query.setParameter("sourceOrder", (Object)source_order);
            query.setParameter("host_name", (Object)host_name);
            tickets = query.list();
            tx.commit();
            session.close();
        }
        return tickets;
    }

    public Double getCA(Date date_open, Date date_close) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select sum(T.total) from Tickets T where T.paid = 1 and T.canceled = 0 and T.created >= :date_open and T.created <= : date_close");
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            Object o = query.getSingleResult();
            tx.commit();
            session.close();
            if (o != null) {
                return (Double)o;
            }
        }
        return null;
    }

    public Double getCACanceled(Date date_open, Date date_close) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select sum(T.total) from Tickets T where T.paid = 1 and T.canceled = 1 and T.created >= :date_open and T.created <= : date_close");
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            Object o = query.getSingleResult();
            tx.commit();
            session.close();
            if (o != null) {
                return (Double)o;
            }
        }
        return null;
    }

    public Long getNbOrder(Date date_open, Date date_close) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select count(T.id) from Tickets T where T.paid = 1 and T.canceled = 0 and T.created >= :date_open and T.created <= : date_close");
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            Object o = query.getSingleResult();
            tx.commit();
            session.close();
            if (o != null) {
                return (Long)o;
            }
        }
        return null;
    }

    public List<UserCaisseInfo> getCaisseUsers(Date date_open, Date date_close) {
        ArrayList<UserCaisseInfo> users = new ArrayList<UserCaisseInfo>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T.user, T.name_user, SUM(T.total) from Tickets T where T.paid = 1  and T.canceled  = 0 and T.sourceOrder <> :sourceOrder and T.created >= :date_open and T.created <= : date_close GROUP BY T.user, T.name_user");
            query.setParameter("sourceOrder", (Object)"borne");
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            List users_result = query.getResultList();
            tx.commit();
            session.close();
            if (users_result != null) {
                for (Object[] user : users_result) {
                    users.add(new UserCaisseInfo((String)user[0], (String)user[1], (Double)user[2]));
                }
            }
        }
        return users;
    }

    public Double getBorneTurnover(Date date_open, Date date_close) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select  SUM(T.total) from Tickets T where T.paid = 1  and T.canceled  = 0 and T.sourceOrder = :sourceOrder and T.created >= :date_open and T.created <= : date_close");
            query.setParameter("sourceOrder", (Object)"borne");
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            Object o = query.getSingleResult();
            tx.commit();
            session.close();
            if (o != null) {
                return (Double)o;
            }
        }
        return null;
    }

    public List<UserCaisseInfo> getUsers(Date date_open, Date date_close) {
        List<UserCaisseInfo> users = this.getCaisseUsers(date_open, date_close);
        System.out.println("+++++++++++ users : " + users);
        Double borneTurnover = this.getBorneTurnover(date_open, date_close);
        if (borneTurnover != null) {
            users.add(new UserCaisseInfo("", "Borne", borneTurnover));
        }
        for (UserCaisseInfo user : users) {
            System.out.println("++++++ user " + user.getName() + " " + user.getTotal());
        }
        return users;
    }

    public List<RankTypeOrder> getTypesOrders(Date date_open, Date date_close) {
        ArrayList<RankTypeOrder> typesOrders = new ArrayList<RankTypeOrder>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T.type, SUM(T.total) from Tickets T where T.paid = 1  and T.canceled  = 0 and T.created >= :date_open and T.created <= : date_close GROUP BY T.type");
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            List users_result = query.getResultList();
            tx.commit();
            session.close();
            if (users_result != null) {
                for (Object[] typeOrders : users_result) {
                    typesOrders.add(new RankTypeOrder((String)typeOrders[0], (Double)typeOrders[1]));
                }
            }
        }
        return typesOrders;
    }

    public Double getNumberProductOrderd(Integer id_product, Date date_start) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select sum(T.quantity) from Ticketlines T where T.refProduct = :refProduct and T.idTicket.created >= :date_start");
            query.setParameter("date_start", (Object)date_start);
            query.setParameter("refProduct", (Object)String.valueOf(id_product));
            Object o = query.getSingleResult();
            tx.commit();
            session.close();
            if (o != null) {
                return (Double)o;
            }
        }
        return null;
    }

    public HashMap<String, Double> getCAByHostName(Date date_open, Date date_close) {
        HashMap<String, Double> results = new HashMap<String, Double>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T.hostName, sum(T.total) from Tickets T where T.paid = 1 and T.canceled = 0 and T.created >= :date_open and T.created <= : date_close GROUP BY T.hostName");
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            List ca_result = query.getResultList();
            tx.commit();
            session.close();
            if (ca_result != null) {
                for (Object[] ca : ca_result) {
                    results.put((String)ca[0], (Double)ca[1]);
                }
            }
        }
        return results;
    }

    public Double getTotalDiscountOrderOfType(Date date_open, Date date_close, String type_discount) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Object request = type_discount.equalsIgnoreCase("pourcentage") ? "SELECT SUM(CASE WHEN T.discount=100 THEN (select sum(l.quantity * l.price) from Ticketlines l where l.idTicket = T.id) ELSE ((T.discount * T.total)/(100-T.discount)) END) from Tickets T where " : "select SUM (T.discount) from Tickets T where ";
            request = (String)request + " T.paid = 1 and T.canceled = 0 and T.created >= :date_open and T.created <= : date_close AND T.type_discount = :type_discount ";
            Query query = session.createQuery((String)request);
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            query.setParameter("type_discount", (Object)type_discount);
            Object o = query.getSingleResult();
            tx.commit();
            session.close();
            if (o != null) {
                return (Double)o;
            }
        }
        return null;
    }

    public Double getTotalDiscountOnTicketLines(Date date_open, Date date_close) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            String request = "select SUM(L.quantity * (L.discount*L.price/100)) from Ticketlines L ,Tickets T where T.id=L.idTicket AND T.paid = 1 and T.canceled = 0 and T.created >= :date_open and T.created <= : date_close";
            Query query = session.createQuery(request);
            query.setParameter("date_open", (Object)date_open);
            query.setParameter("date_close", (Object)date_close);
            Object o = query.getSingleResult();
            tx.commit();
            session.close();
            if (o != null) {
                return (Double)o;
            }
        }
        return null;
    }

    public void deleteOrders(int idTicket) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            String hqlUpdate = "delete from Tickets O where O.id = :idTicket";
            int updatedEntities = session.createQuery(hqlUpdate).setParameter("idTicket", (Object)idTicket).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public List<Tickets> getExteriorOrders(String typeOrder, Date date_start, Date date_end) {
        List<Tickets> tickets = new ArrayList<Tickets>();
        if (sessionFactory != null) {
            Session session = null;
            Transaction tx = null;
            try {
                session = sessionFactory.getCurrentSession();
                if (!session.getTransaction().isActive()) {
                    tx = session.beginTransaction();
                }
                String requestTypeOrder = typeOrder != null && !typeOrder.equals("TOUT") ? " and T.type = :type" : "";
                Query query = session.createQuery("select T from Tickets T where T.paid = 0 and T.canceled = 0 and T.exterior_order = 1 and T.created > :dateStart and T.created < :dateEnd" + requestTypeOrder);
                query.setParameter("dateStart", (Object)date_start);
                query.setParameter("dateEnd", (Object)date_end);
                if (typeOrder != null && !typeOrder.equals("TOUT")) {
                    query.setParameter("type", (Object)typeOrder);
                }
                tickets = query.list();
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return tickets;
    }

    public List<Tickets> getOrders(String source_order, Date date_start, Date date_end) {
        System.out.println("++++++ caisse orders");
        if (sessionFactory != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where  T.paid = 0 and T.saved  = 0  and T.canceled  = 0 and T.sourceOrder = :sourceOrder and T.created > :dateStart and T.created < :dateEnd");
            query.setParameter("sourceOrder", (Object)source_order);
            query.setParameter("dateStart", (Object)date_start);
            query.setParameter("dateEnd", (Object)date_end);
            List tickets = query.list();
            tx.commit();
            session.close();
            return tickets;
        }
        return null;
    }

    public List<Tickets> getAllOrders(Date date_start, Date date_end) {
        System.out.println("++++++ All caisse orders");
        if (sessionFactory != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.created > :dateStart and T.created < :dateEnd");
            query.setParameter("dateStart", (Object)date_start);
            query.setParameter("dateEnd", (Object)date_end);
            List tickets = query.list();
            tx.commit();
            session.close();
            return tickets;
        }
        return null;
    }

    public void setInfoKitchenOrder(int id_order, int id_order_kitchen, int num_order_kitchen) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("update Tickets T set T.id_order_kitchen = :id_order_kitchen, T.num_order_kitchen = :num_order_kitchen  where T.id = :id ");
            query.setParameter("id_order_kitchen", (Object)id_order_kitchen);
            query.setParameter("num_order_kitchen", (Object)num_order_kitchen);
            query.setParameter("id", (Object)id_order);
            query.executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public Tickets getOrderByIdsurce(String id_ticket) {
        System.out.println("+++++++++++++ sessionFactory : " + sessionFactory);
        if (sessionFactory != null) {
            Session session = null;
            Transaction tx = null;
            try {
                session = sessionFactory.getCurrentSession();
                if (!session.getTransaction().isActive()) {
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("select T from Tickets T where T.id_ticket_source = :id_ticket");
                query.setParameter("id_ticket", (Object)id_ticket);
                List ticketList = query.list();
                if (!ticketList.isEmpty()) {
                    Tickets tickets = (Tickets)ticketList.get(0);
                    System.out.println("+++++++++ tickets : " + tickets);
                    if (tx != null) {
                        tx.commit();
                    }
                    Tickets tickets2 = tickets;
                    return tickets2;
                }
                System.out.println("++++++++++++++++++++++tickets not exist");
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return null;
    }

    public Tickets getSharedOrder(int id) {
        Tickets ticket = null;
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("select T from Tickets T where T.paid = 1 and T.id = :id ");
            query.setParameter("id", (Object)id);
            List tickets = query.list();
            tx.commit();
            session.close();
            ticket = tickets != null && !tickets.isEmpty() ? (Tickets)tickets.get(0) : null;
        }
        return ticket;
    }

    public void cancelOrder(String id_source) {
        Tickets mticket = this.getOrderByIdsurce(id_source);
        if (sessionFactory != null && mticket != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Tickets T set T.canceled = 1,  T.updatedAt = CURRENT_TIMESTAMP where T.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setInteger("id", mticket.getId().intValue()).executeUpdate();
            tx.commit();
            session.close();
        }
    }
}

