/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.kitchen.dao.impl;

import fr.protactile.kitchen.dao.config.DaoConfig;
import fr.protactile.kitchen.dao.entities.Screen;
import fr.protactile.kitchen.dao.entities.ScreenItem;
import fr.protactile.kitchen.dao.entities.ScreenLine;
import fr.protactile.kitchen.dao.entities.ScreenSupplement;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public class ScreenDao
extends DaoConfig<Screen> {
    @Override
    protected Class<Screen> classType() {
        return Screen.class;
    }

    public List<Screen> getScreens() {
        List<Screen> screens = new ArrayList<Screen>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query q = session.createQuery("from Screen s WHERE  s.deleted = :deleted");
            q.setParameter("deleted", (Object)false);
            screens = q.list();
            tx.commit();
            session.close();
        }
        return screens;
    }

    public void updateScreen(Screen mScreen) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            String hqlUpdate = "update Screen s set s.name = :name, s.number = :number where s.id = :id ";
            Transaction tx = session.beginTransaction();
            int updatedEntities = session.createQuery(hqlUpdate).setString("name", mScreen.getName()).setInteger("number", mScreen.getNumber().intValue()).setInteger("id", mScreen.getId().intValue()).executeUpdate();
            tx.commit();
            session.close();
        }
    }

    public void deleteScreen(int id_screen) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update Screen s set s.deleted = :deleted where s.id = :id ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setParameter("deleted", (Object)true).setInteger("id", id_screen).executeUpdate();
        tx.commit();
        s.close();
    }

    public void deleteOldScreenItem() {
        if (!s.isOpen()) {
            this.openSession();
        }
        Transaction tx = s.beginTransaction();
        NativeQuery query = s.createSQLQuery("delete  from screen_item").addEntity(ScreenItem.class);
        query.executeUpdate();
        tx.commit();
        s.close();
    }

    public void deleteOldScreenSupplement() {
        if (!s.isOpen()) {
            this.openSession();
        }
        Transaction tx = s.beginTransaction();
        NativeQuery query = s.createSQLQuery("delete  from SCREEN_SUPPLEMENT").addEntity(ScreenSupplement.class);
        query.executeUpdate();
        tx.commit();
        s.close();
    }

    public void deleteOldScreenLine() {
        if (!s.isOpen()) {
            this.openSession();
        }
        Transaction tx = s.beginTransaction();
        NativeQuery query = s.createSQLQuery("delete  from SCREEN_LINE").addEntity(ScreenLine.class);
        query.executeUpdate();
        tx.commit();
        s.close();
    }
}

